/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.cache.UserCache;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.model.process.config.ProcessTitleConfig;
import org.bgerp.util.Log;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.dao.expression.ProcessExpressionObject;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.Status;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.model.process.TypeProperties;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class Process
extends IdTitle
implements Comparable<Process>,
Cloneable {
    private static final Log log = Log.getLog();
    public static final String OBJECT_TYPE = "process";
    public static final String LINK_TYPE_LINK = "processLink";
    public static final String LINK_TYPE_DEPEND = "processDepend";
    public static final String LINK_TYPE_MADE = "processMade";
    private int typeId;
    private String typeTitle;
    private Date createTime;
    private int createUserId;
    private Date closeTime;
    private int closeUserId;
    private int statusId;
    private String statusTitle;
    private Date statusTime;
    private int statusUserId;
    private StatusChange statusChange;
    private int priority;
    private String description = "";
    private ProcessGroups groups = new ProcessGroups();
    private Set<ProcessExecutor> executors = new HashSet<ProcessExecutor>();

    public Process() {
    }

    public Process(int id) {
        this.id = id;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int value) {
        this.typeId = value;
    }

    public Process withTypeId(int value) {
        this.setTypeId(value);
        return this;
    }

    @JsonIgnore
    public ProcessType getType() {
        return ProcessTypeCache.getProcessTypeSafe(this.typeId);
    }

    public String getTypeTitle() {
        return this.getType().getTitle();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public int getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(int createUserId) {
        this.createUserId = createUserId;
    }

    public int getCloseUserId() {
        return this.closeUserId;
    }

    public void setCloseUserId(int closeUserId) {
        this.closeUserId = closeUserId;
    }

    public Date getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public Process withStatusId(int value) {
        this.setStatusId(value);
        return this;
    }

    @JsonIgnore
    public Status getStatus() {
        return ProcessTypeCache.getStatusSafe(this.statusId);
    }

    public String getStatusTitle() {
        return this.getStatus().getTitle();
    }

    public Set<Integer> getAllowedToChangeStatusIds() {
        HashSet<Integer> result = new HashSet<Integer>();
        ProcessType type = ProcessTypeCache.getProcessType(this.typeId);
        if (type == null) {
            return result;
        }
        Set<Integer> allowedStatusSet = type.getProperties().getAllowedStatusSet(this.statusId);
        allowedStatusSet.add(this.statusId);
        List<Status> statusList = Utils.getObjectList(ProcessTypeCache.getStatusMap(), type.getProperties().getStatusIds());
        for (Status status : statusList) {
            if (!allowedStatusSet.contains(status.getId())) continue;
            result.add(status.getId());
        }
        return result;
    }

    public Date getStatusTime() {
        return this.statusTime;
    }

    public void setStatusTime(Date statusTime) {
        this.statusTime = statusTime;
    }

    public int getStatusUserId() {
        return this.statusUserId;
    }

    public void setStatusUserId(int statusUserId) {
        this.statusUserId = statusUserId;
    }

    public StatusChange getStatusChange() {
        return this.statusChange;
    }

    public void setStatusChange(StatusChange status) {
        this.statusChange = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public String getTitle() {
        ProcessTitleConfig config;
        TypeProperties typeProperties;
        Object result = this.title;
        if (Utils.isBlankString((String)result) && (typeProperties = this.getType().getProperties()) != null && (config = typeProperties.getConfigMap().getConfig(ProcessTitleConfig.class)) != null && config.isProcessUsed() && !config.isAnyParamUsed()) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            new ProcessExpressionObject(this).toContext(context);
            result = new Expression(context).executeGetString(config.getExpression());
        }
        if (Utils.isBlankString((String)result)) {
            result = "#" + this.id + " " + Utils.escapeXml(this.description);
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Process withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ProcessGroups getGroups() {
        return this.groups;
    }

    public void setGroups(ProcessGroups value) {
        this.groups = value;
    }

    public Process withGroups(ProcessGroups value) {
        this.setGroups(value);
        return this;
    }

    public Set<Integer> getGroupIds() {
        return Collections.unmodifiableSet(ProcessGroup.toGroupSet(this.groups));
    }

    public Set<Integer> getRoleSet() {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        for (ProcessGroup processGroup : this.groups) {
            if (resultSet.contains(processGroup.getRoleId())) continue;
            resultSet.add(processGroup.getRoleId());
        }
        return resultSet;
    }

    public Set<Integer> getGroupIdsWithRole(int roleId) {
        return this.groups.stream().filter(pg -> pg.getRoleId() == roleId).map(ProcessGroup::getGroupId).collect(Collectors.toSet());
    }

    public Set<Integer> getGroupIdsWithRoles(Set<Integer> roleIds) {
        return this.groups.stream().filter(pg -> roleIds.contains(pg.getRoleId())).map(ProcessGroup::getGroupId).collect(Collectors.toSet());
    }

    public Set<ProcessExecutor> getExecutors() {
        return this.executors;
    }

    public void setExecutors(Set<ProcessExecutor> value) {
        this.executors = value;
    }

    public Process withExecutors(Set<ProcessExecutor> value) {
        this.setExecutors(value);
        return this;
    }

    public Set<Integer> getExecutorIds() {
        return Collections.unmodifiableSet(ProcessExecutor.toExecutorSet(this.executors));
    }

    public Set<Integer> getExecutorIdsWithRole(int roleId) {
        return this.executors.stream().filter(pe -> pe.getRoleId() == roleId).map(ProcessExecutor::getUserId).collect(Collectors.toSet());
    }

    public Set<Integer> getExecutorIdsWithRoles(Set<Integer> roleIds) {
        return this.executors.stream().filter(pe -> roleIds.contains(pe.getRoleId())).map(ProcessExecutor::getUserId).collect(Collectors.toSet());
    }

    public Set<Integer> getExecutorIdsWithGroupAndRole(int groupId, int roleId) {
        return this.executors.stream().filter(pe -> roleId == pe.getRoleId() && groupId == pe.getGroupId()).map(ProcessExecutor::getUserId).collect(Collectors.toSet());
    }

    public Set<Integer> getExecutorIdsWithGroups(Set<Integer> groupIds) {
        return this.executors.stream().filter(pe -> groupIds.contains(pe.getGroupId())).map(ProcessExecutor::getUserId).collect(Collectors.toSet());
    }

    public String getChangesLog(Process oldProcess) {
        Localizer l = Localization.getLocalizer();
        StringBuilder result = new StringBuilder();
        String separator = "; ";
        if (!this.description.equals(oldProcess.getDescription())) {
            Utils.addSeparated(result, "; ", l.l("Description: {}", this.description));
        }
        if (this.typeId != oldProcess.getTypeId()) {
            Utils.addSeparated(result, "; ", l.l("Type: {}", ProcessTypeCache.getProcessTypeSafe(this.typeId).getTitle()));
        }
        if (this.priority != oldProcess.getPriority()) {
            Utils.addSeparated(result, "; ", l.l("Priority: {}", this.priority));
        }
        if (!CollectionUtils.isEqualCollection((Collection)this.groups, (Collection)oldProcess.groups)) {
            StringBuilder groupString = new StringBuilder();
            for (ProcessGroup pg : this.groups) {
                Group group = UserCache.getUserGroup(pg.getGroupId());
                if (group == null) continue;
                Utils.addCommaSeparated(groupString, group.getTitle());
            }
            result.append(l.l("Execution groups: [{}]", groupString));
        }
        if (!CollectionUtils.isEqualCollection(this.executors, oldProcess.executors)) {
            Object executorString = "";
            for (Integer item : ProcessExecutor.toExecutorSet(this.executors)) {
                executorString = (String)executorString + UserCache.getUser(item).getTitle() + ", ";
            }
            if (((String)executorString).length() > 2) {
                executorString = ((String)executorString).substring(0, ((String)executorString).length() - 2);
            }
            result.append(l.l("Executors: [{}]", executorString));
        }
        return result.toString();
    }

    @Override
    public int compareTo(Process o) {
        return o.getId() - this.id;
    }

    @Override
    public boolean equals(Object obj) {
        return ((Process)obj).getId() == this.id;
    }

    public boolean isEqualProperties(Process process) {
        boolean result = this.id == process.getId() && (this.createTime == null ? process.getCreateTime() == null : this.createTime.equals(process.getCreateTime())) && (this.closeTime == null ? process.getCloseTime() == null : this.closeTime.equals(process.getCloseTime())) && this.statusId == process.getStatusId() && this.priority == process.getPriority() && this.typeId == process.getTypeId() && (this.statusTime == null ? process.getStatusTime() == null : this.statusTime.equals(process.getStatusTime())) && process.getDescription().equals(this.description) && CollectionUtils.isEqualCollection((Collection)process.groups, (Collection)this.groups) && CollectionUtils.isEqualCollection(process.executors, this.executors);
        return result;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(200);
        result.append("ID: ").append(Integer.toString(this.id)).append("; Type: ").append(this.typeTitle);
        if (this.createTime != null) {
            result.append("; Created: ").append(TimeUtils.format(this.createTime, "ymdhms"));
        }
        if (this.closeTime != null) {
            result.append("; Closed: ").append(TimeUtils.format(this.closeTime, "ymdhms"));
        }
        result.append("; Priority: ").append(this.priority).append("; Status: ").append(this.statusTitle).append("; Description: ").append(this.description);
        return result.toString();
    }

    public Process clone() {
        Process process = new Process();
        process.closeTime = this.closeTime;
        process.closeUserId = this.closeUserId;
        process.createTime = this.createTime;
        process.createUserId = this.createUserId;
        process.description = this.description;
        process.id = this.id;
        process.priority = this.priority;
        process.executors = new LinkedHashSet<ProcessExecutor>(this.executors);
        process.groups = new ProcessGroups(this.groups);
        process.statusId = this.statusId;
        process.statusTime = this.statusTime;
        process.statusTitle = this.statusTitle;
        process.statusUserId = this.statusUserId;
        process.typeId = this.typeId;
        process.typeTitle = this.typeTitle;
        return process;
    }

    @Deprecated
    @JsonIgnore
    public Set<ProcessExecutor> getProcessExecutors() {
        log.warndMethod("getProcessExecutors", "getExecutors");
        return this.getExecutors();
    }

    @Deprecated
    public Set<Integer> getProcessExecutorsWithRole(int roleId) {
        log.warndMethod("getProcessExecutorsWithRole", "getExecutorIdsWithRole");
        return this.getExecutorIdsWithRole(roleId);
    }

    @Deprecated
    public Set<Integer> getProcessExecutorsWithRoles(Set<Integer> roleIds) {
        log.warndMethod("getProcessExecutorsWithRoles", "getExecutorIdsWithRoles");
        return this.getExecutorIdsWithRoles(roleIds);
    }

    @Deprecated
    public Set<Integer> getProcessExecutorsInGroupWithRole(int roleId, int groupId) {
        log.warndMethod("getProcessExecutorsInGroupWithRole", "getExecutorIdsWithGroupAndRole");
        return this.getExecutorIdsWithGroupAndRole(groupId, roleId);
    }

    @Deprecated
    public Set<Integer> getProcessExecutorsWithGroups(Set<Integer> groupIds) {
        log.warndMethod("getProcessExecutorsWithGroups", "getExecutorIdsWithGroups");
        return this.getExecutorIdsWithGroups(groupIds);
    }

    @Deprecated
    public void setProcessExecutors(Set<ProcessExecutor> processExecutors) {
        log.warndMethod("setProcessExecutors", "setExecutors");
        this.setExecutors(processExecutors);
    }

    @Deprecated
    @JsonIgnore
    public Set<ProcessGroup> getProcessGroups() {
        log.warndMethod("getProcessGroups", "setGroups");
        return this.getGroups();
    }

    @Deprecated
    public Set<ProcessGroup> getProcessGroupWithRole(int roleId) {
        HashSet<ProcessGroup> groupsWithRole = new HashSet<ProcessGroup>();
        for (ProcessGroup group : this.groups) {
            if (group.getRoleId() != roleId) continue;
            groupsWithRole.add(group);
        }
        return groupsWithRole;
    }

    @Deprecated
    public Set<ProcessGroup> getProcessGroupWithRoles(Set<Integer> roleIds) {
        HashSet<ProcessGroup> groupsWithRole = new HashSet<ProcessGroup>();
        for (ProcessGroup group : this.groups) {
            if (!roleIds.contains(group.getRoleId())) continue;
            groupsWithRole.add(group);
        }
        return groupsWithRole;
    }

    @Deprecated
    public void setProcessGroups(Set<ProcessGroup> processGroups) {
        this.setGroups(new ProcessGroups(processGroups));
    }
}

