/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.sql.Connection;
import java.util.Date;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.iface.Event;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageTypeCall;
import ru.bgcrm.event.RunClassRequestEvent;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SQLUtils;

public class MessageTypeCallRegister
implements EventListener<Event> {
    private static final Log log = Log.getLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event e, ConnectionSet connectionSet) {
        RunClassRequestEvent event = (RunClassRequestEvent)e;
        DynActionForm form = event.getForm();
        MessageTypeCall messageType = (MessageTypeCall)Setup.getSetup().getConfig(MessageTypeConfig.class).getTypeMap().get(form.getParamInt("typeId"));
        if (messageType == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.", new Object[0]);
        }
        String from = form.getParam("from", "");
        String to = form.getParam("to", "");
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            MessageTypeCall.CallRegistration reg = messageType.getRegistrationByNumber(to);
            if (reg != null) {
                log.info("Call to registered number: {}", reg.getNumber());
            }
            Message message = new Message();
            message.setDirection(1);
            message.setTypeId(messageType.getId());
            message.setUserId(reg != null ? reg.getUserId() : 0);
            message.setText("");
            message.setFrom(from);
            message.setTo(to);
            message.setFromTime(new Date());
            message.setSystemId(messageType.getId() + ":" + System.currentTimeMillis());
            messageType.updateMessage(con, DynActionForm.SYSTEM_FORM, message);
            con.commit();
            log.info("Created message: {}", message.getId());
            if (reg != null) {
                reg.setMessageForOpen(message);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        finally {
            SQLUtils.closeConnection(con);
        }
    }
}

