/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.util.Date;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.Event;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.message.MessageTypeCall;
import ru.bgcrm.event.GetPoolTasksEvent;
import ru.bgcrm.event.client.MessageOpenEvent;
import ru.bgcrm.util.sql.ConnectionSet;

public class MessageTypeCallListener
implements EventListener<Event> {
    private static final Log log = Log.getLog();
    private static MessageTypeCallListener instance;

    public MessageTypeCallListener() {
        if (instance != null) {
            log.warn("Attempt of creation a second singleton instance", new Object[0]);
            return;
        }
        instance = this;
        EventProcessor.subscribe(this, GetPoolTasksEvent.class);
    }

    @Override
    public void notify(Event e, ConnectionSet connectionSet) {
        if (!(e instanceof GetPoolTasksEvent)) {
            return;
        }
        GetPoolTasksEvent event = (GetPoolTasksEvent)e;
        MessageTypeConfig config = Setup.getSetup().getConfig(MessageTypeConfig.class);
        for (MessageType type : config.getTypeMap().values()) {
            MessageTypeCall.CallRegistration reg;
            if (!(type instanceof MessageTypeCall) || (reg = ((MessageTypeCall)type).getRegistrationByUser(event.getUser().getId())) == null) continue;
            reg.setLastPooling(new Date());
            Message message = reg.getMessageForOpen();
            if (message == null) continue;
            event.getForm().getResponse().addEvent(new MessageOpenEvent(message));
            reg.setMessageForOpen(null);
        }
    }
}

