/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.event.ProcessFilesEvent;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValuePair;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.FileData;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.sql.ConnectionSet;

public class Files {
    public Files() {
        EventProcessor.subscribe((e, conSet) -> this.processFiles((ProcessFilesEvent)e, conSet), ProcessFilesEvent.class);
    }

    private void processFiles(ProcessFilesEvent e, ConnectionSet conSet) throws Exception {
        try (Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();){
            Process process = new ProcessDAO(con).getProcess(e.getProcessId());
            if (process == null) {
                return;
            }
            List<Integer> paramIds = ProcessTypeCache.getProcessType(process.getTypeId()).getProperties().getParameterIds();
            List<Parameter> paramList = ParameterCache.getParameterList(paramIds).stream().filter(param -> "file".equals(param.getType())).collect(Collectors.toList());
            if (paramList.isEmpty()) {
                return;
            }
            List<ParameterValuePair> list = new ParamValueDAO(con).loadParameters(paramList, e.getProcessId(), false);
            for (ParameterValuePair pair : list) {
                Map value = (Map)pair.getValue();
                if (value == null) continue;
                for (FileData file : value.values()) {
                    e.addFile(file);
                }
            }
        }
    }
}

