/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.OldParamSearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.TimeConvert;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.model.user.User;
import ru.bgcrm.model.user.UserGroup;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class UserDAO
extends CommonDAO {
    private static final String SELECT_PERMSETS_QUERY = "( SELECT GROUP_CONCAT(up.permset_id ORDER BY up.pos, up.permset_id SEPARATOR ',') FROM  user_permset  AS up WHERE up.user_id=user.id) AS permsets, ";
    private static final String SELECT_GROUPS_QUERY = "( SELECT GROUP_CONCAT(ug.group_id SEPARATOR ',') FROM  user_group  AS ug WHERE ug.user_id=user.id) AS groups ";

    public UserDAO(Connection con) {
        super(con);
    }

    public void searchUser(Pageable<User> result, String filterLike, Set<Integer> groupFilter, Set<Integer> groupSelectFilter, Date date, Set<Integer> permsetFilter, int statusFilter) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Date prevDay;
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS DISTINCT user.*, ");
            pq.addQuery(SELECT_PERMSETS_QUERY);
            Date date2 = prevDay = date != null ? TimeUtils.getPrevDay(date) : null;
            if (date == null) {
                pq.addQuery(SELECT_GROUPS_QUERY);
            } else {
                pq.addQuery("( SELECT GROUP_CONCAT(ug.group_id SEPARATOR ',') FROM  user_group  AS ug WHERE ug.user_id=user.id AND (ug.date_from IS NULL OR ug.date_from<=?) AND (ug.date_to >? OR ug.date_to IS NULL) ) AS `groups` ");
                pq.addTimestamp(TimeConvert.toTimestamp(date));
                pq.addTimestamp(TimeConvert.toTimestamp(prevDay));
            }
            pq.addQuery(" FROM  user  AS user ");
            if (groupFilter != null && groupFilter.size() > 0) {
                pq.addQuery(" INNER JOIN ");
                pq.addQuery(" user_group  AS user_group ON user.id=user_group.user_id AND user_group.group_id IN(");
                pq.addQuery(Utils.toString(groupFilter));
                pq.addQuery(")");
                if (date != null) {
                    pq.addQuery(" AND (user_group.date_from IS NULL OR user_group.date_from<=?) AND (user_group.date_to>? OR user_group.date_to IS NULL) ");
                    pq.addTimestamp(TimeConvert.toTimestamp(date));
                    pq.addTimestamp(TimeConvert.toTimestamp(prevDay));
                }
            }
            if (groupSelectFilter != null && groupSelectFilter.size() > 0) {
                pq.addQuery(" INNER JOIN ");
                pq.addQuery(" user_group  AS user_select_group ON user.id=user_select_group.user_id AND user_select_group.group_id IN(");
                pq.addQuery(Utils.toString(groupSelectFilter));
                pq.addQuery(")");
                if (date != null) {
                    pq.addQuery(" AND user_select_group.date_from <=? AND (user_select_group.date_to >? OR user_select_group.date_to IS NULL) ");
                    pq.addTimestamp(TimeConvert.toTimestamp(date));
                    pq.addTimestamp(TimeConvert.toTimestamp(prevDay));
                }
            }
            if (permsetFilter != null && permsetFilter.size() > 0) {
                pq.addQuery(" INNER JOIN ");
                pq.addQuery(" user_permset  AS user_permset ON user.id=user_permset.user_id AND user_permset.permset_id IN(");
                pq.addQuery(Utils.toString(permsetFilter));
                pq.addQuery(")");
            }
            pq.addQuery(" WHERE 1=1 ");
            if (Utils.notBlankString(filterLike)) {
                pq.addQuery(" AND (id LIKE ? OR title LIKE ? OR login LIKE ? OR description LIKE ?) ");
                pq.addString(filterLike).addString(filterLike).addString(filterLike).addString(filterLike);
            }
            if (statusFilter >= 0) {
                pq.addQuery(" AND status=? ");
                pq.addInt(statusFilter);
            }
            pq.addQuery(" ORDER BY title ");
            pq.addQuery(this.getPageLimit(result.getPage()));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.getList().add(this.getFromRS(rs, "", true, false));
            }
            this.setRecordCount(result.getPage(), pq.getPrepared());
        }
    }

    public void searchUserListByEmail(Pageable<ParameterSearchedObject<User>> searchResult, List<Integer> emailParamIdList, String email) {
        new OldParamSearchDAO(this.con).searchObjectListByEmail(" user ", rs -> this.getFromRS(rs, "c.", false, false), searchResult, emailParamIdList, email);
    }

    public List<User> getUserList() throws SQLException {
        return this.getUserList(null, null, true);
    }

    public List<User> getUserList(Set<Integer> groupIds) throws SQLException {
        return this.getUserList(groupIds, null, false);
    }

    public List<User> getUserList(Set<Integer> groupIds, String userTitleMask) throws SQLException {
        return this.getUserList(groupIds, userTitleMask, false);
    }

    public List<User> getUserList(Set<Integer> groupIds, String userTitleMask, boolean loadPassword) throws SQLException {
        ArrayList<User> result = new ArrayList<User>();
        StringBuilder query = new StringBuilder().append("SELECT DISTINCT user.* FROM user ");
        if (groupIds != null && groupIds.size() > 0) {
            query.append(" INNER JOIN  user_group  ON user.id=user_group.user_id AND user_group.group_id IN (");
            query.append(Utils.toString(groupIds));
            query.append(")");
        }
        if (userTitleMask != null) {
            query.append(" WHERE title like '%" + userTitleMask + "%'");
        }
        query.append(" ORDER BY title");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getFromRS(rs, "", false, loadPassword));
        }
        ps.close();
        return result;
    }

    public List<User> getUserList(Set<Integer> groupFilter, Date dateGroupFrom, Date dateGroupTo) throws SQLException {
        ArrayList<User> result = new ArrayList<User>();
        PreparedQuery psDelay = new PreparedQuery(this.con);
        psDelay.addQuery("SELECT DISTINCT user.* ");
        psDelay.addQuery(" FROM  user  AS user ");
        if (CollectionUtils.isNotEmpty(groupFilter)) {
            psDelay.addQuery(" INNER JOIN ");
            psDelay.addQuery(" user_group  AS user_group ON user.id=user_group.user_id AND user_group.group_id IN(");
            psDelay.addQuery(Utils.toString(groupFilter));
            psDelay.addQuery(")");
            if (dateGroupFrom != null) {
                psDelay.addQuery(" AND (user_group.date_to IS NULL OR ?<=user_group.date_to)");
                psDelay.addDate(TimeUtils.convertDateToSqlDate(dateGroupFrom));
            }
            if (dateGroupTo != null) {
                psDelay.addQuery(" AND (user_group.date_from IS NULL OR user_group.date_from<=?)");
                psDelay.addDate(TimeUtils.convertDateToSqlDate(dateGroupTo));
            }
        }
        psDelay.addQuery(" ORDER BY title ");
        ResultSet rs = psDelay.executeQuery();
        while (rs.next()) {
            result.add(this.getFromRS(rs));
        }
        psDelay.close();
        return result;
    }

    public Map<Integer, List<UserGroup>> getAllUserGroups() throws SQLException {
        HashMap<Integer, List<UserGroup>> result = new HashMap<Integer, List<UserGroup>>();
        String query = "SELECT * FROM  user_group ";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int userId = rs.getInt("user_id");
            UserGroup userGroup = this.getUserGroupFromRs(rs);
            if (result.get(userId) != null) {
                ((List)result.get(userId)).add(userGroup);
                continue;
            }
            ArrayList<UserGroup> groupList = new ArrayList<UserGroup>();
            groupList.add(userGroup);
            result.put(userId, groupList);
        }
        ps.close();
        return result;
    }

    public Set<Integer> getUserGroupIds(int userId) throws SQLException {
        return this.getIds(" user_group ", "user_id", "group_id", userId);
    }

    public Map<Integer, Set<Integer>> getAllUserGroupIds() throws SQLException {
        return this.getGroupedIds(" user_group ", "user_id", "group_id");
    }

    public List<Integer> getUserPermsetIds(int userId) throws SQLException {
        return this.getIds(" user_permset ", "user_id", "permset_id", "pos", userId);
    }

    public Map<Integer, List<Integer>> getAllUserPermsetIds() throws SQLException {
        return this.getGroupedIds(" user_permset ", "user_id", "permset_id", "pos");
    }

    public Set<Integer> getUserQueueIds(int userId) throws SQLException {
        return this.getIds(" user_queue ", "user_id", "queue_id", userId);
    }

    public Map<Integer, Set<Integer>> getAllUserQueueIds() throws SQLException {
        return this.getGroupedIds(" user_queue ", "user_id", "queue_id");
    }

    private User getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, "", false, false);
    }

    private User getFromRS(ResultSet rs, String prefix, boolean loadGroupAndPermsets, boolean loadPassword) throws SQLException {
        User user = new User();
        user.setId(rs.getInt(prefix + "id"));
        user.setTitle(rs.getString(prefix + "title"));
        user.setStatus(rs.getInt(prefix + "status"));
        user.setConfig(rs.getString(prefix + "config"));
        user.setPersonalization(prefix + rs.getString("personalization"));
        user.setDescription(rs.getString(prefix + "description"));
        user.setLogin(rs.getString(prefix + "login"));
        if (loadPassword) {
            user.setPassword(rs.getString(prefix + "pswd"));
        }
        if (loadGroupAndPermsets) {
            user.setPermsetIds(Utils.toIntegerList(rs.getString(prefix + "permsets")));
            user.setGroupIds(Utils.toIntegerSet(rs.getString(prefix + "groups")));
        }
        return user;
    }

    public void updateUser(int userId, String title, String login, String pswd, String description) throws SQLException {
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement("UPDATE user SET title=?, login=?, description=? WHERE id=?");
        ps.setString(index++, title);
        ps.setString(index++, login);
        ps.setString(index++, description);
        ps.setInt(index++, userId);
        ps.executeUpdate();
        ps.close();
        this.updateUserPassword(userId, pswd);
    }

    public void updateUser(User user) throws SQLException {
        PreparedStatement ps;
        boolean newUser = false;
        int index = 1;
        if (user.getId() <= 0) {
            newUser = true;
            String query = "INSERT INTO  user  SET title=?, login=?, description=?, config=?, create_dt=?, status=?";
            ps = this.con.prepareStatement(query, 1);
            ps.setString(index++, user.getTitle());
            ps.setString(index++, user.getLogin());
            ps.setString(index++, user.getDescription());
            ps.setString(index++, user.getConfig());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(new Date()));
            ps.setInt(index++, user.getStatus());
            ps.executeUpdate();
            user.setId(this.lastInsertId(ps));
        } else {
            ps = this.con.prepareStatement("UPDATE  user  SET title=?, login=?, status=?, description=?, config=? WHERE id=?");
            ps.setString(index++, user.getTitle());
            ps.setString(index++, user.getLogin());
            ps.setInt(index++, user.getStatus());
            ps.setString(index++, user.getDescription());
            ps.setString(index++, user.getConfig());
            ps.setInt(index++, user.getId());
            ps.executeUpdate();
        }
        ps.close();
        this.updateUserPassword(user.getId(), user.getPassword());
        if (user.getPermsetIds() != null) {
            this.updateIds(" user_permset ", "user_id", "permset_id", "pos", user.getId(), user.getPermsetIds());
        }
        if (user.getQueueIds() != null) {
            this.updateIds(" user_queue ", "user_id", "queue_id", user.getId(), user.getQueueIds());
        }
        if (newUser && user.getGroupIds() != null) {
            this.updateUserGroups(user);
        }
    }

    private void updateUserPassword(int userId, String pswd) throws SQLException {
        if ("*******".equals(pswd)) {
            return;
        }
        try (PreparedQuery pq = new PreparedQuery(this.con, "UPDATE  user  SET pswd=? WHERE id=?");){
            pq.addString(pswd).addInt(userId).executeUpdate();
        }
    }

    public User getUserByLogin(String name) {
        User result = null;
        try {
            String query = "SELECT * FROM  user  WHERE login=? AND status=0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            if (result != null) {
                result.setGroupIds(this.getUserGroupIds(result.getId()));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public User getUser(int id) throws SQLException {
        User result = null;
        String query = "SELECT * FROM  user  WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = this.getFromRS(rs);
        }
        if (result != null) {
            result.setGroupIds(this.getUserGroupIds(id));
            result.setPermsetIds(this.getUserPermsetIds(id));
            result.setQueueIds(this.getUserQueueIds(id));
        }
        ps.close();
        return result;
    }

    public void deleteUser(int id) throws SQLException {
        this.deleteById(" user ", id);
    }

    @Override
    protected String getPageLimit(Page page) {
        StringBuilder sql = new StringBuilder();
        if (page != null && page.getPageSize() > 0) {
            sql.append(" LIMIT ");
            sql.append(page.getPageFirstRecordNumber());
            sql.append(", ");
            sql.append(page.getPageSize());
        }
        return sql.toString();
    }

    public Map<Integer, Map<String, ConfigMap>> getAllPermissions(String tableName, String selectColumn) throws SQLException {
        HashMap<Integer, Map<String, ConfigMap>> result = new HashMap<Integer, Map<String, ConfigMap>>(1000);
        try (PreparedStatement ps = this.con.prepareStatement("SELECT " + selectColumn + ", action, config FROM " + tableName);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int userId = rs.getInt(selectColumn);
                String action = rs.getString("action");
                String config = rs.getString("config");
                Map map = result.computeIfAbsent(userId, unused -> new HashMap(300));
                ConfigMap pref = Utils.isBlankString(config) ? UserCache.EMPTY_PERMISSION : new Preferences(config);
                map.put(action, pref);
                this.derivedPermission(map, action, pref);
            }
        }
        return result;
    }

    private void derivedPermission(Map<String, ConfigMap> map, String action, ConfigMap pref) {
        String parentAction;
        PermissionNode parent;
        PermissionNode node = PermissionNode.getPermissionNode(action);
        if (node != null && (parent = node.getParent()) != null && Utils.notBlankString(parentAction = parent.getAction())) {
            map.putIfAbsent(parentAction, pref);
        }
    }

    public Map<Integer, Map<String, ConfigMap>> getAllUserPerm() throws SQLException {
        return this.getAllPermissions(" user_permission ", "user_id");
    }

    public void updatePermissions(Set<String> action, Set<String> config, int userId) throws SQLException {
        this.updatePermissions(action, config, " user_permission ", "user_id", userId);
    }

    protected void updatePermissions(Set<String> action, Set<String> config, String table, String column, int id) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + table + " WHERE " + column + "=?");
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
        for (String newAction : action) {
            String newConfig = "";
            for (String c : config) {
                if (!c.startsWith(newAction + "#")) continue;
                newConfig = StringUtils.substringAfter((String)c, (String)(newAction + "#"));
                break;
            }
            if (!Utils.notEmptyString(newAction)) continue;
            ps = this.con.prepareStatement("INSERT INTO " + table + " (" + column + ", action, config) VALUES ( ? , ? , ? )");
            ps.setInt(1, id);
            ps.setString(2, newAction);
            ps.setString(3, newConfig);
            ps.executeUpdate();
            ps.close();
        }
    }

    public Map<String, ConfigMap> getPermissions(int userId) {
        try {
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("SELECT * FROM  user_permission  WHERE user_id=?");
            ps.setInt(1, userId);
            ResultSet rs = ps.executeQuery();
            HashMap<String, ConfigMap> perms = new HashMap<String, ConfigMap>();
            while (rs.next()) {
                String action = rs.getString("action");
                String config = rs.getString("config");
                perms.put(action, new Preferences(config));
            }
            ps.close();
            return perms;
        }
        catch (SQLException e) {
            throw new BGException();
        }
    }

    public void updatePersonalization(String mapDataBefore, User user) throws SQLException {
        if (user.getPersonalizationMap().getDataString().equals(mapDataBefore)) {
            return;
        }
        this.log.debug("Updating personalization {}", user.getId());
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE  user  SET personalization=? WHERE id=?");){
            ps.setString(1, user.getPersonalizationMap().getDataString());
            ps.setInt(2, user.getId());
            ps.executeUpdate();
        }
    }

    public void updatePersonalization(User user, ConfigMap newMap) throws SQLException {
        Preferences map = user.getPersonalizationMap();
        String mapDataBefore = map.getDataString();
        for (Map.Entry<String, String> me : newMap.entrySet()) {
            map.put(me.getKey(), me.getValue());
        }
        this.updatePersonalization(mapDataBefore, user);
    }

    public void addUserGroup(int userId, UserGroup group) throws SQLException {
        String query = "INSERT INTO  user_group  (user_id, group_id, date_from, date_to) VALUES (?, ?, ?, ?) ";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, userId);
        ps.setInt(2, group.getGroupId());
        ps.setTimestamp(3, TimeConvert.toTimestamp(group.getDateFrom()));
        ps.setTimestamp(4, TimeConvert.toTimestamp(group.getDateTo()));
        ps.executeUpdate();
        ps.close();
    }

    public void removeUserGroup(int userId, int groupId, Date dateFrom, Date dateTo) throws SQLException {
        String query = "DELETE FROM  user_group  WHERE  user_id=" + userId + (String)(groupId == -1 ? "" : " AND group_id=" + groupId);
        query = query + (dateFrom != null ? " AND date_from = ? " : " AND date_from IS NULL ");
        query = query + (dateTo != null ? " AND date_to = ? " : " AND date_to IS NULL ");
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement(query);
        if (dateFrom != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(dateFrom));
        }
        if (dateTo != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(dateTo));
        }
        ps.executeUpdate();
        ps.close();
    }

    public List<UserGroup> getUserGroupList(int userId, Date date) {
        ArrayList<UserGroup> result = new ArrayList<UserGroup>();
        try {
            PreparedQuery pq = new PreparedQuery(this.con);
            pq.addQuery("SELECT * FROM  user_group  WHERE user_id=? ");
            pq.addInt(userId);
            if (date != null) {
                pq.addQuery("AND (date_from IS NULL OR date_from<=?) AND (date_to IS NULL OR ?<=date_to) ");
                pq.addDate(date);
                pq.addDate(date);
            }
            pq.addQuery("ORDER BY date_from");
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(this.getUserGroupFromRs(rs));
            }
            pq.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void updateUserGroups(User user) throws SQLException {
        this.removeUserGroup(user.getId(), -1, null, null);
        for (Integer groupId : user.getGroupIds()) {
            UserGroup group = new UserGroup();
            group.setGroupId(groupId);
            group.setDateFrom(new Date());
            this.addUserGroup(user.getId(), group);
        }
    }

    private UserGroup getUserGroupFromRs(ResultSet rs) throws SQLException {
        return new UserGroup(rs.getInt("group_id"), rs.getTimestamp("date_from"), rs.getTimestamp("date_to"));
    }

    public void closeUserGroupPeriod(int userId, int groupId, Date date, Date dateFrom, Date dateTo) throws SQLException {
        Object query = "UPDATE  user_group  SET date_to=?  WHERE  user_id=? AND group_id=?";
        query = (String)query + (dateFrom != null ? " AND date_from = ? " : " AND date_from IS NULL ");
        query = (String)query + (dateTo != null ? " AND date_to = ? " : " AND date_to IS NULL ");
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement((String)query);
        ps.setDate(index++, TimeUtils.convertDateToSqlDate(date));
        ps.setInt(index++, userId);
        ps.setInt(index++, groupId);
        if (dateFrom != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(dateFrom));
        }
        if (dateTo != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(dateTo));
        }
        ps.executeUpdate();
        ps.close();
    }
}

