/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ru.bgcrm.dao.CommonDAO;

public class PeriodicDAO
extends CommonDAO {
    protected static final Set<String> EXISTING_TABLES = Collections.newSetFromMap(new ConcurrentHashMap());

    protected PeriodicDAO(Connection con) {
        super(con);
    }

    protected String checkAndCreateMonthTable(String tableNamePrefix, Date date, String createQuery) throws SQLException {
        String table = this.getMonthTableName(tableNamePrefix, date);
        if (this.tableExists(table)) {
            return table;
        }
        String query = "CREATE TABLE IF NOT EXISTS `" + table + "` " + createQuery;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
            EXISTING_TABLES.add(table);
        }
        return table;
    }

    protected String getMonthTableName(String tableNamePrefix, Date date) {
        SimpleDateFormat getModuleMonthTableNameFormat = new SimpleDateFormat("_yyyyMM");
        StringBuilder sb = new StringBuilder(tableNamePrefix.trim());
        sb.append(getModuleMonthTableNameFormat.format(date));
        return sb.toString();
    }

    protected boolean tableExists(String tableName) throws SQLException {
        if (EXISTING_TABLES.isEmpty()) {
            try (PreparedStatement ps = this.con.prepareStatement("SHOW TABLES");){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    EXISTING_TABLES.add(rs.getString(1));
                }
            }
        }
        return EXISTING_TABLES.contains(tableName);
    }
}

