/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.util.Set;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class ParamValueSelect
extends CommonDAO {
    public static final String PARAM_ADDRESS_FIELD_QUARTER = "quarter";
    public static final String PARAM_ADDRESS_FIELD_STREET = "street";
    public static final Set<String> PARAM_ADDRESS_FIELDS = Set.of("quarter", "street");

    public static void paramSelectQuery(String variable, String linkColumn, StringBuilder selectPart, StringBuilder joinPart, boolean addColumnValueAlias) {
        String[] tokens = variable.split(":");
        if (tokens.length >= 2) {
            Parameter param;
            int paramId = Utils.parseInt(tokens[1].trim());
            String afterParamId = "";
            if (tokens.length > 2) {
                afterParamId = tokens[2].trim();
            }
            if ((param = ParameterCache.getParameter(paramId)) == null) {
                selectPart.append("'PARAM NOT FOUND:" + paramId + "' ");
            } else {
                boolean isMultiple = param.getConfigMap().getBoolean("multiple", false);
                String type = param.getType();
                String tableAlias = "param_" + paramId;
                Object columnValueAlias = "";
                if (addColumnValueAlias) {
                    columnValueAlias = " AS param_" + paramId + "_val";
                }
                switch (Parameter.Type.of(type)) {
                    case ADDRESS: {
                        if (Utils.notBlankString(afterParamId) && !PARAM_ADDRESS_FIELDS.contains(afterParamId)) {
                            selectPart.append("\n( SELECT GROUP_CONCAT( CONCAT( CAST( house_id AS CHAR ), ':', flat, ':', room, ':', CAST( pod AS CHAR ), ':', CAST( floor AS CHAR ), ':', comment ) SEPARATOR '|') ").append("FROM  param_address  AS param ").append("WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                            break;
                        }
                        if (isMultiple) {
                            selectPart.append("\n( SELECT GROUP_CONCAT(param.value SEPARATOR '; ') ").append("FROM  param_address  AS param ").append("WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                            break;
                        }
                        if (PARAM_ADDRESS_FIELDS.contains(afterParamId)) {
                            String joinQuery = " LEFT JOIN param_" + type + " AS " + tableAlias + " ON " + tableAlias + ".id=" + linkColumn + " AND " + tableAlias + ".param_id=" + paramId;
                            ParamValueSelect.addIfNotContains(joinPart, joinQuery);
                            String houseTableAlias = tableAlias + "_house";
                            joinQuery = " LEFT JOIN  address_house  AS " + houseTableAlias + " ON " + houseTableAlias + ".id=" + tableAlias + ".house_id";
                            ParamValueSelect.addIfNotContains(joinPart, joinQuery);
                            if (PARAM_ADDRESS_FIELD_QUARTER.equals(afterParamId)) {
                                String quarterTableAlias = tableAlias + "_quarter";
                                joinQuery = " LEFT JOIN  address_quarter  AS " + quarterTableAlias + " ON " + quarterTableAlias + ".id=" + houseTableAlias + ".quarter_id";
                                joinPart.append(joinQuery);
                                selectPart.append(quarterTableAlias + ".title ");
                                break;
                            }
                            if (!PARAM_ADDRESS_FIELD_STREET.equals(afterParamId)) break;
                            String streetTableAlias = tableAlias + "_street ";
                            joinQuery = " LEFT JOIN  address_street  AS " + streetTableAlias + " ON " + streetTableAlias + ".id=" + houseTableAlias + ".street_id";
                            joinPart.append(joinQuery);
                            selectPart.append(streetTableAlias + ".title ");
                            break;
                        }
                        ParamValueSelect.addParamValueJoin(linkColumn, joinPart, paramId, type, tableAlias);
                        selectPart.append(tableAlias).append(".value ");
                        break;
                    }
                    case EMAIL: {
                        selectPart.append("\n(SELECT GROUP_CONCAT(IF(param.comment != '', CONCAT(param.comment, ' <', param.value, '>'), param.value) SEPARATOR ', ') FROM  param_email AS param WHERE param.id=").append(linkColumn).append(" AND param.param_id=").append(paramId).append(" GROUP BY param.id)");
                        break;
                    }
                    case LIST: {
                        String tableName = param.getConfigMap().get("directory");
                        if (Utils.notBlankString(tableName)) {
                            selectPart.append("\n(SELECT GROUP_CONCAT(CONCAT(val.title, IF(param.comment, CONCAT(' [', param.comment, ']'), '')) SEPARATOR ', ') ").append("FROM  param_list  AS param LEFT JOIN " + tableName + " AS val ON param.value=val.id ").append("WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                            break;
                        }
                        selectPart.append("\n(SELECT GROUP_CONCAT(CONCAT(val.title, IF(param.comment != '', CONCAT(' [', param.comment, ']'), '')) SEPARATOR ', ') ").append("FROM  param_list  AS param LEFT JOIN  param_list_value  AS val ON param.param_id=val.param_id AND param.value=val.id ").append("WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                        break;
                    }
                    case LISTCOUNT: {
                        selectPart.append("\n( SELECT GROUP_CONCAT( CONCAT(val.title, ': ', CAST(param.count AS CHAR)) SEPARATOR ', ') ").append("FROM  param_listcount  AS param LEFT JOIN  param_listcount_value  AS val ON param.param_id=val.param_id AND param.value=val.id ").append("WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                        break;
                    }
                    case TREE: {
                        selectPart.append("\n( SELECT GROUP_CONCAT(val.title SEPARATOR ', ') ").append("FROM  param_tree  AS param LEFT JOIN  param_tree_value  AS val ON param.param_id=val.param_id AND param.value=val.id ").append("WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                        break;
                    }
                    case TREECOUNT: {
                        selectPart.append("\n( SELECT GROUP_CONCAT( CONCAT(val.title, ': ', CAST(param.count AS CHAR)) SEPARATOR ', ') ").append(" FROM  param_treecount AS param LEFT JOIN  param_treecount_value AS val ON param.param_id=val.param_id AND param.value=val.id").append(" WHERE param.id=" + linkColumn + " AND param.param_id=" + paramId + " GROUP BY param.id").append(") " + (String)columnValueAlias + " ");
                        break;
                    }
                    default: {
                        if (("date".equals(type) || "datetime".equals(type)) && !"value".equals(afterParamId)) {
                            String format = SQLUtils.javaDateFormatToSql(param.getDateParamFormat());
                            selectPart.append("DATE_FORMAT(").append(tableAlias).append(".value, '").append(format).append("') " + (String)columnValueAlias + " ");
                        } else {
                            selectPart.append(tableAlias).append(".value " + (String)columnValueAlias + " ");
                        }
                        ParamValueSelect.addParamValueJoin(linkColumn, joinPart, paramId, type, tableAlias);
                    }
                }
            }
        }
    }

    private static void addParamValueJoin(String linkColumn, StringBuilder joinPart, int paramId, String type, String tableAlias) {
        String joinQuery = " LEFT JOIN param_" + type + " AS " + tableAlias + " ON " + tableAlias + ".id=" + linkColumn + " AND " + tableAlias + ".param_id=" + paramId;
        ParamValueSelect.addIfNotContains(joinPart, joinQuery);
    }

    private static void addIfNotContains(StringBuilder joinPart, String joinQuery) {
        if (joinPart.indexOf(joinQuery) < 0) {
            joinPart.append(joinQuery);
        }
    }
}

