/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.file.FileStat;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.FileData;
import ru.bgcrm.util.Utils;

public class FileDataDAO
extends CommonDAO {
    private static final Log log = Log.getLog();
    private static final DateTimeFormatter DIR_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DecimalFormat NAME_FORMAT = new DecimalFormat("0000000000");
    private File storeDir = Utils.createDirectoryIfNoExistInWorkDir("filestorage");

    public FileDataDAO(Connection con) {
        super(con);
    }

    public List<FileData> list(List<Integer> ids) throws SQLException {
        ArrayList<FileData> result = new ArrayList<FileData>();
        String idsStr = Utils.toString(ids, "-1", ",");
        String query = "SELECT * FROM  file_data AS fd WHERE id IN (" + idsStr + ") ORDER BY FIELD(id," + idsStr + ")";
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                result.add(FileDataDAO.getFromRs(rs, "fd."));
            }
        }
        return result;
    }

    public FileOutputStream add(FileData fileData) throws Exception {
        this.checkDir();
        fileData.setSecret(Utils.generateSecret());
        fileData.setTime(new Date());
        String query = "INSERT INTO  file_data  (title, dt, secret) VALUES (?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, fileData.getTitle());
            ps.setTimestamp(2, TimeConvert.toTimestamp(fileData.getTime()));
            ps.setString(3, fileData.getSecret());
            ps.executeUpdate();
            fileData.setId(this.lastInsertId(ps));
        }
        FileOutputStream outputStream = new FileOutputStream(this.getFile(fileData));
        fileData.setOutputStream(outputStream);
        return outputStream;
    }

    public void delete(FileData fileData) throws Exception {
        this.checkDir();
        this.getFile(fileData).delete();
        String query = "DELETE FROM  file_data  WHERE id=? AND secret=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, fileData.getId());
            ps.setString(2, fileData.getSecret());
            ps.executeUpdate();
        }
    }

    public static FileData getFromRs(ResultSet rs, String prefix) throws SQLException {
        FileData result = new FileData();
        result.setId(rs.getInt(prefix + "id"));
        result.setTitle(rs.getString(prefix + "title"));
        result.setTime(rs.getTimestamp(prefix + "dt"));
        result.setSecret(rs.getString("secret"));
        return result;
    }

    public File getFile(FileData fileData) throws SQLException {
        String name;
        File result;
        if (fileData.getTime() == null) {
            try (PreparedStatement ps = this.con.prepareStatement("SELECT dt FROM  file_data  WHERE id=?");){
                ps.setInt(1, fileData.getId());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    fileData.setTime(rs.getTimestamp(1));
                }
            }
        }
        if (!(result = new File(this.storeDir, name = NAME_FORMAT.format(fileData.getId()) + "_" + fileData.getSecret())).exists()) {
            File dir = new File(this.storeDir, DIR_FORMAT.format(TimeConvert.toLocalDate(fileData.getTime())));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            result = new File(dir, name);
        }
        return result;
    }

    public FileStat stat() {
        this.checkDir();
        return new FileStat(this.storeDir);
    }

    public boolean moveBatch(int batchSize) throws SQLException, IOException {
        String[] files = this.storeDir.list();
        String query = "SELECT * FROM  file_data  WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (int i = 0; i < Math.min(batchSize, files.length); ++i) {
                String fileName = files[i];
                File file = new File(this.storeDir, fileName);
                if (file.isDirectory()) continue;
                log.info("Moving file: {}", fileName);
                ps.setInt(1, Utils.parseInt(StringUtils.substringBefore((String)fileName, (String)"_")));
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    log.error("Not found DB entry for file: {}", fileName);
                    continue;
                }
                FileData fileData = FileDataDAO.getFromRs(rs, "");
                FileUtils.moveFileToDirectory((File)file, (File)new File(this.storeDir, DIR_FORMAT.format(TimeConvert.toLocalDate(fileData.getTime()))), (boolean)true);
            }
        }
        return batchSize < files.length;
    }

    private void checkDir() {
        if (!this.storeDir.exists() || !this.storeDir.isDirectory()) {
            throw new BGException("Not found directory file storage", new Object[0]);
        }
        if (!this.storeDir.canRead() || !this.storeDir.canWrite()) {
            throw new BGException("Can't access the file storage directory", new Object[0]);
        }
    }
}

