/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.dao.param.OldParamSearchDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.EntityLogDAO;
import ru.bgcrm.dao.ParamValueSelect;
import ru.bgcrm.dao.PatternDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.client.CustomerTitleChangedEvent;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.param.Pattern;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.struts.form.Response;
import ru.bgcrm.util.PatternFormatter;
import ru.bgcrm.util.Utils;

public class CustomerDAO
extends CommonDAO {
    private boolean history;
    private int userId;

    public CustomerDAO(Connection con) {
        super(con);
    }

    public CustomerDAO(Connection con, boolean history, int userId) {
        super(con);
        this.history = history;
        this.userId = userId;
    }

    public void searchCustomerList(Pageable<Customer> searchResult, String title) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Customer> list = searchResult.getList();
            StringBuilder selectPart = new StringBuilder();
            StringBuilder joinPart = new StringBuilder();
            String referenceTemplate = this.addCustomerReferenceQuery(selectPart, joinPart);
            PreparedQuery ps = new PreparedQuery(this.con);
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append((CharSequence)selectPart);
            query.append("customer.* FROM  customer  AS customer");
            query.append((CharSequence)joinPart);
            if (Utils.notBlankString(title)) {
                query.append(" WHERE title LIKE ? ");
                ps.addString(title);
            }
            query.append(" ORDER BY title");
            query.append(this.getPageLimit(page));
            ps.addQuery(query.toString());
            this.extractCustomersWithRef(page, list, referenceTemplate, ps);
        }
    }

    public void searchCustomerList(Pageable<Customer> searchResult, Set<Integer> groupIds) {
        StringBuilder query;
        PreparedQuery ps;
        Page page = searchResult.getPage();
        List<Customer> list = searchResult.getList();
        StringBuilder selectPart = new StringBuilder();
        StringBuilder joinPart = new StringBuilder();
        String referenceTemplate = this.addCustomerReferenceQuery(selectPart, joinPart);
        if (CollectionUtils.isNotEmpty(groupIds)) {
            joinPart.append(" INNER JOIN  customer_group  AS customer_group ON customer.id=customer_group.customer_id AND customer_group.group_id IN (" + Utils.toString(groupIds) + ") ");
            ps = new PreparedQuery(this.con);
            query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS  DISTINCT ");
            query.append((CharSequence)selectPart);
            query.append("customer.* FROM  customer  AS customer");
            query.append((CharSequence)joinPart);
            query.append(" ORDER BY title");
            query.append(this.getPageLimit(page));
            ps.addQuery(query.toString());
            this.extractCustomersWithRef(page, list, referenceTemplate, ps);
        }
        ps = new PreparedQuery(this.con);
        query = new StringBuilder();
        query.append("SELECT SQL_CALC_FOUND_ROWS  DISTINCT ");
        query.append((CharSequence)selectPart);
        query.append("customer.* FROM  customer  AS customer");
        query.append((CharSequence)joinPart);
        query.append(" ORDER BY title");
        query.append(this.getPageLimit(page));
        this.log.debug(query.toString(), new Object[0]);
        ps.addQuery(query.toString());
        this.extractCustomersWithRef(page, list, referenceTemplate, ps);
    }

    public Customer extractCustomerWithRef(int customerId) {
        try {
            int index = 1;
            StringBuilder query = new StringBuilder();
            StringBuilder selectPart = new StringBuilder();
            StringBuilder joinPart = new StringBuilder();
            String referenceTemplate = this.addCustomerReferenceQuery(selectPart, joinPart);
            query.append("SELECT ");
            query.append((CharSequence)selectPart);
            query.append(" customer.* ");
            query.append(" FROM ");
            query.append(" customer ");
            query.append(" AS customer");
            query.append((CharSequence)joinPart);
            query.append(" WHERE customer.id = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, customerId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!Utils.notBlankString(referenceTemplate)) continue;
                Customer customer = CustomerDAO.getCustomerFromRs(rs, "");
                String reference = PatternFormatter.processPattern(referenceTemplate, variable -> {
                    String value = "";
                    try {
                        if (variable.startsWith("param:")) {
                            value = rs.getString(variable.replace(':', '_') + "_val");
                        }
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), e);
                    }
                    return value;
                });
                ps.close();
                customer.setReference(reference);
                return customer;
            }
            ps.close();
            return null;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private void extractCustomersWithRef(Page page, List<Customer> list, String referenceTemplate, PreparedQuery ps) {
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Customer customer = CustomerDAO.getCustomerFromRs(rs, "");
                list.add(customer);
                if (!Utils.notBlankString(referenceTemplate)) continue;
                String reference = PatternFormatter.processPattern(referenceTemplate, variable -> {
                    String value = "";
                    try {
                        if (variable.startsWith("param:")) {
                            value = rs.getString(variable.replace(':', '_') + "_val");
                        }
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), e);
                    }
                    return value;
                });
                customer.setReference(reference);
            }
            if (page != null) {
                page.setRecordCount(this.foundRows(ps.getPrepared()));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private String addCustomerReferenceQuery(StringBuilder selectPart, StringBuilder joinPart) {
        String referenceTemplate = Setup.getSetup().get("customer.reference.pattern", "");
        if (Utils.notBlankString(referenceTemplate)) {
            PatternFormatter.processPattern(referenceTemplate, variable -> {
                if (variable.startsWith("param:")) {
                    ParamValueSelect.paramSelectQuery(variable, "customer.id", selectPart, joinPart, true);
                    selectPart.append(", ");
                }
                return "";
            });
        }
        return referenceTemplate;
    }

    public void searchCustomerListByEmail(Pageable<ParameterSearchedObject<Customer>> searchResult, List<Integer> emailParamIdList, String email) {
        new OldParamSearchDAO(this.con).searchObjectListByEmail(" customer ", rs -> CustomerDAO.getCustomerFromRs(rs, "c."), searchResult, emailParamIdList, email);
    }

    public void searchCustomerListByText(Pageable<Customer> searchResult, List<Integer> textParamIdList, String value) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Customer> list = searchResult.getList();
            StringBuilder query = new StringBuilder();
            String ids = Utils.toString(textParamIdList);
            query.append("SELECT ");
            query.append("DISTINCT c.*");
            query.append(" FROM ");
            query.append(" customer ");
            query.append("AS c ");
            query.append(" INNER JOIN ");
            query.append(" param_text ");
            query.append("AS param ON c.id=param.id AND ");
            query.append("param.value LIKE ?");
            if (Utils.notBlankString(ids)) {
                query.append(" AND param.param_id IN (");
                query.append(ids);
                query.append(")");
            }
            query.append(" ORDER BY ");
            query.append("c.title");
            query.append(this.getPageLimit(page));
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, value);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(CustomerDAO.getCustomerFromRs(rs, ""));
            }
            if (page != null) {
                page.setRecordCount(this.foundRows(ps));
            }
            ps.close();
        }
    }

    public void searchCustomerListByAddress(Pageable<ParameterSearchedObject<Customer>> searchResult, List<Integer> addressParamIdList, int streetId, String house, String houseFlat, String houseRoom) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<ParameterSearchedObject<Customer>> list = searchResult.getList();
            PreparedQuery ps = new PreparedQuery(this.con);
            String ids = Utils.toString(addressParamIdList, "-1", ",");
            AddressHouse searchParams = new AddressHouse().withHouseAndFrac(house);
            int number = searchParams.getHouse();
            String frac = searchParams.getFrac();
            ps.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
            ps.addQuery("DISTINCT param.param_id, param.value, c.* ");
            ps.addQuery(" FROM ");
            ps.addQuery(" customer ");
            ps.addQuery("AS c ");
            ps.addQuery(" INNER JOIN ");
            ps.addQuery(" param_address ");
            ps.addQuery("AS param ON c.id=param.id AND param.param_id IN (");
            ps.addQuery(ids);
            ps.addQuery(")");
            if (Utils.notBlankString(houseFlat)) {
                ps.addQuery(" AND param.flat=?");
                ps.addString(houseFlat);
            }
            if (Utils.notBlankString(houseRoom)) {
                ps.addQuery(" AND param.room=?");
                ps.addString(houseRoom);
            }
            ps.addQuery(" INNER JOIN ");
            ps.addQuery(" address_house ");
            ps.addQuery("AS house ON param.house_id=house.id");
            ps.addQuery(" AND house.street_id=?");
            ps.addInt(streetId);
            if (number > 0) {
                ps.addQuery(" AND house.house=?");
                ps.addInt(number);
            }
            if (Utils.notBlankString(frac)) {
                ps.addQuery(" AND house.frac=?");
                ps.addString(frac);
            }
            ps.addQuery(" LEFT JOIN ");
            ps.addQuery(" param_pref ");
            ps.addQuery("AS pref ON param.param_id=pref.id ");
            ps.addQuery(" ORDER BY ");
            ps.addQuery("c.title");
            ps.addQuery(this.getPageLimit(page));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new ParameterSearchedObject<Customer>(CustomerDAO.getCustomerFromRs(rs, "c."), rs.getInt(1), rs.getString(2)));
            }
            this.setRecordCount(page, ps.getPrepared());
            ps.close();
        }
    }

    public void searchCustomerListByAddress(Pageable<ParameterSearchedObject<Customer>> searchResult, List<Integer> addressParamIdList, int houseId, String houseFlat, String houseRoom) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<ParameterSearchedObject<Customer>> list = searchResult.getList();
            PreparedQuery ps = new PreparedQuery(this.con);
            String ids = Utils.toString(addressParamIdList);
            ps.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
            ps.addQuery("DISTINCT param.param_id, param.value, c.* ");
            ps.addQuery(" FROM ");
            ps.addQuery(" customer ");
            ps.addQuery("AS c ");
            ps.addQuery(" INNER JOIN ");
            ps.addQuery(" param_address ");
            ps.addQuery("AS param ON c.id=param.id AND param.param_id IN (");
            ps.addQuery(ids);
            ps.addQuery(")");
            ps.addQuery(" AND param.house_id=?");
            ps.addInt(houseId);
            if (Utils.notBlankString(houseFlat)) {
                ps.addQuery(" AND param.flat=?");
                ps.addString(houseFlat);
            }
            if (Utils.notBlankString(houseRoom)) {
                ps.addQuery(" AND param.room=?");
                ps.addString(houseRoom);
            }
            ps.addQuery(" ORDER BY ");
            ps.addQuery("c.title");
            ps.addQuery(this.getPageLimit(page));
            try (PreparedQuery preparedQuery = ps;){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(new ParameterSearchedObject<Customer>(CustomerDAO.getCustomerFromRs(rs, "c."), rs.getInt(1), rs.getString(2)));
                }
                this.setRecordCount(page, ps.getPrepared());
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }

    public void searchCustomerListByPhone(Pageable<Customer> searchResult, Collection<Integer> phoneParamIdList, String ... phoneNumbers) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Customer> list = searchResult.getList();
            String ids = Utils.toString(phoneParamIdList);
            StringBuilder selectPart = new StringBuilder();
            StringBuilder joinPart = new StringBuilder();
            StringBuilder query = new StringBuilder();
            selectPart.append("SELECT ");
            selectPart.append(" DISTINCT ");
            joinPart.append(" INNER JOIN ");
            joinPart.append(" param_phone_item ");
            joinPart.append(" AS p ON customer.id=p.id ");
            if (ids.length() > 0) {
                joinPart.append("AND p.param_id IN ( ");
                joinPart.append(ids);
                joinPart.append(" ) ");
            }
            for (int i = 0; i < phoneNumbers.length; ++i) {
                phoneNumbers[i] = "'" + phoneNumbers[i] + "'";
            }
            joinPart.append(" AND p.phone IN (");
            joinPart.append(Utils.toString(Arrays.asList(phoneNumbers)));
            joinPart.append(")");
            String referenceTemplate = this.addCustomerReferenceQuery(selectPart, joinPart);
            query.append((CharSequence)selectPart);
            query.append(" customer.* ");
            query.append(" FROM ");
            query.append(" customer ");
            query.append((CharSequence)joinPart);
            query.append(" WHERE ");
            query.append("1=1 ");
            query.append(" ORDER BY customer.title ");
            query.append(this.getPageLimit(page));
            PreparedQuery ps = new PreparedQuery(this.con);
            ps.addQuery(query.toString());
            this.extractCustomersWithRef(page, list, referenceTemplate, ps);
            ps.close();
        }
    }

    public void searchCustomerByLinkedObjectTitle(Pageable<Customer> searchResult, String linkedObjectTypeLike, String linkedObjectTitle) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Customer> list = searchResult.getList();
            StringBuilder selectPart = new StringBuilder();
            StringBuilder joinPart = new StringBuilder();
            StringBuilder query = new StringBuilder();
            selectPart.append("SELECT ");
            selectPart.append(" DISTINCT ");
            joinPart.append(" INNER JOIN ");
            joinPart.append(" customer_link ");
            joinPart.append(" AS link ON link.customer_id = customer.id ");
            joinPart.append("AND link.object_title LIKE ? ");
            joinPart.append("AND link.object_type LIKE ? ");
            String referenceTemplate = this.addCustomerReferenceQuery(selectPart, joinPart);
            query.append((CharSequence)selectPart);
            query.append(" customer.* ");
            query.append(" FROM ");
            query.append(" customer ");
            query.append((CharSequence)joinPart);
            query.append(" ORDER BY customer.title ");
            query.append(this.getPageLimit(page));
            PreparedQuery ps = new PreparedQuery(this.con);
            ps.addQuery(query.toString());
            ps.addString(linkedObjectTitle);
            ps.addString(linkedObjectTypeLike);
            this.extractCustomersWithRef(page, list, referenceTemplate, ps);
            ps.close();
        }
    }

    public Customer getCustomerById(int customerId) {
        Customer customer = null;
        try {
            String sql = "SELECT * FROM customer WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(1, customerId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                customer = CustomerDAO.getCustomerFromRs(rs, "");
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return customer;
    }

    public Customer getCustomerByTitle(String customerTitle) throws SQLException {
        Customer customer = null;
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement("SELECT * FROM customer WHERE UPPER(title)=?");
        ps.setString(index++, customerTitle.toUpperCase());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            customer = CustomerDAO.getCustomerFromRs(rs, "");
        }
        ps.close();
        return customer;
    }

    public void updateCustomer(Customer customer) throws SQLException {
        if (customer != null) {
            int index = 1;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            if (customer.getId() > 0) {
                query.append("UPDATE ");
                query.append(" customer ");
                query.append(" SET title=?, title_pattern=?, title_pattern_id=?, param_group_id=?");
                query.append(" WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(index++, customer.getTitle());
                ps.setString(index++, customer.getTitlePattern());
                ps.setInt(index++, customer.getTitlePatternId());
                ps.setInt(index++, customer.getParamGroupId());
                ps.setInt(index++, customer.getId());
                ps.executeUpdate();
            } else {
                query.append("INSERT INTO ");
                query.append(" customer ");
                query.append(" SET title=?, title_pattern=?, title_pattern_id=?, param_group_id=?,");
                query.append(" create_dt=now(), create_user_id=?");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setString(index++, customer.getTitle());
                ps.setString(index++, customer.getTitlePattern());
                ps.setInt(index++, customer.getTitlePatternId());
                ps.setInt(index++, customer.getParamGroupId());
                ps.setInt(index++, customer.getCreateUserId());
                ps.executeUpdate();
                customer.setId(this.lastInsertId(ps));
            }
            ps.close();
        }
    }

    public void deleteCustomer(int id) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM  customer  WHERE id=?");
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public void updateCustomerTitle(String titleBefore, Customer customer, int changedParamId, Response response) throws Exception {
        PatternDAO patternDAO = new PatternDAO(this.con);
        ParamValueDAO paramValueDAO = new ParamValueDAO(this.con);
        Customer oldCustomer = this.getCustomerById(customer.getId());
        oldCustomer.setGroupIds(this.getGroupIds(customer.getId()));
        try {
            boolean changed;
            Pattern pattern;
            String titlePattern = customer.getTitlePattern();
            if (customer.getTitlePatternId() == 0) {
                titlePattern = "";
                customer.setTitlePattern("");
            } else if (customer.getTitlePatternId() > 0 && (pattern = patternDAO.getPattern(customer.getTitlePatternId())) != null) {
                titlePattern = pattern.getPattern();
            }
            if (Utils.notBlankString(titlePattern) && (changedParamId < 0 || titlePattern.contains(String.valueOf(changedParamId)))) {
                customer.setTitle(Utils.formatPatternString("customer", customer.getId(), paramValueDAO, titlePattern));
            }
            if (oldCustomer != null) {
                this.logCustomerChange(customer, oldCustomer);
            }
            this.updateCustomer(customer);
            boolean bl = changed = !titleBefore.equals(customer.getTitle());
            if (changed && response != null) {
                response.addEvent(new CustomerTitleChangedEvent(customer.getId(), customer.getTitle()));
            }
            if (changed) {
                new ProcessLinkDAO(this.con).updateLinkTitles(customer.getId(), "customer%", customer.getTitle());
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public List<String> getCustomerTitles(String title, int count) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String query = " SELECT title FROM  customer  WHERE title LIKE ?  GROUP BY title ORDER BY title LIMIT ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ps.setInt(2, count);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Set<Integer> getGroupIds(int customerId) throws SQLException {
        return this.getIds(" customer_group ", "customer_id", "group_id", customerId);
    }

    public void updateGroupIds(int customerId, Set<Integer> groupIds) throws SQLException {
        this.updateIds(" customer_group ", "customer_id", "group_id", customerId, groupIds);
    }

    public static Customer getCustomerFromRs(ResultSet rs, String prefix) throws SQLException {
        Customer customer = new Customer();
        customer.setId(rs.getInt(prefix + "id"));
        customer.setTitle(rs.getString(prefix + "title"));
        customer.setTitlePattern(rs.getString(prefix + "title_pattern"));
        customer.setTitlePatternId(rs.getInt(prefix + "title_pattern_id"));
        customer.setParamGroupId(rs.getInt(prefix + "param_group_id"));
        customer.setCreateTime(rs.getTimestamp(prefix + "create_dt"));
        customer.setCreateUserId(rs.getInt(prefix + "create_user_id"));
        customer.setPassword(rs.getString(prefix + "pswd"));
        return customer;
    }

    private void logCustomerChange(Customer customer, Customer oldCustomer) throws SQLException {
        if (this.history) {
            EntityLogDAO entityLogDAO = new EntityLogDAO(this.con, " customer_log ");
            entityLogDAO.insertEntityLog(customer.getId(), this.userId, customer.toLog(this.con, oldCustomer));
        }
    }

    @Deprecated
    public static Set<Customer> getCustomers(Connection connection, Collection<Integer> customerIds) {
        HashSet<Customer> customers = new HashSet<Customer>();
        Object sql = "SELECT * FROM customer WHERE customer.id IN ( ";
        sql = (String)sql + Utils.toString(customerIds);
        sql = (String)sql + " )";
        try {
            PreparedStatement ps = connection.prepareStatement((String)sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                customers.add(CustomerDAO.getCustomerFromRs(rs, ""));
            }
            ps.close();
        }
        catch (SQLException exception) {
            throw new BGException(exception);
        }
        return customers;
    }

    @Deprecated
    public Set<Customer> getCustomers(Collection<Integer> customerIds) {
        return CustomerDAO.getCustomers(this.con, customerIds);
    }
}

