/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.address.AddressCity;
import ru.bgcrm.model.param.address.AddressCountry;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.param.address.AddressItem;
import ru.bgcrm.util.Utils;

public class AddressDAO
extends CommonDAO {
    public static final int LOAD_LEVEL_HOUSE = 1;
    public static final int LOAD_LEVEL_STREET = 2;
    public static final int LOAD_LEVEL_CITY = 3;
    public static final int LOAD_LEVEL_COUNTRY = 4;

    private static final int getHouseLoadLevel(boolean loadCountryData, boolean loadCityData, boolean loadStreetData) {
        if (loadCountryData) {
            return 4;
        }
        if (loadCityData) {
            return 3;
        }
        if (loadStreetData) {
            return 2;
        }
        return 0;
    }

    public AddressDAO(Connection con) {
        super(con);
    }

    public void searchAddressCountryList(Pageable<AddressCountry> searchResult, String title) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<AddressCountry> result = searchResult.getList();
            PreparedQuery ps = new PreparedQuery(this.con);
            ps.addQuery("SELECT SQL_CALC_FOUND_ROWS * ");
            ps.addQuery("FROM ");
            ps.addQuery(" address_country ");
            if (!Utils.isEmptyString(title)) {
                ps.addQuery("WHERE ");
                ps.addQuery("title LIKE ? ");
                ps.addString(title);
            }
            ps.addQuery(" ORDER BY title");
            ps.addQuery(this.getPageLimit(page));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AddressDAO.getAddressCountryFromRs(rs, ""));
            }
            if (page != null) {
                page.setRecordCount(this.foundRows(ps.getPrepared()));
            }
            ps.close();
        }
    }

    public AddressCountry getAddressCountry(int id) throws SQLException {
        AddressCountry addressCountry = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(" address_country ");
        query.append(" WHERE id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressCountry = AddressDAO.getAddressCountryFromRs(rs, "");
        }
        ps.close();
        return addressCountry;
    }

    public void searchAddressCityList(Pageable<AddressCity> searchResult, int countryId, String title, boolean loadCountryData, Set<Integer> cityIdFilter) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<AddressCity> result = searchResult.getList();
            PreparedQuery ps = new PreparedQuery(this.con);
            ps.addQuery("SELECT SQL_CALC_FOUND_ROWS * ");
            ps.addQuery("FROM ");
            ps.addQuery(" address_city ");
            ps.addQuery("AS city ");
            if (loadCountryData) {
                ps.addQuery("LEFT JOIN ");
                ps.addQuery(" address_country ");
                ps.addQuery("AS country ON city.country_id = country.id ");
            }
            ps.addQuery("WHERE 1=1");
            if (!Utils.isEmptyString(title)) {
                ps.addQuery(" AND city.title LIKE ? ");
                ps.addString(title);
            }
            if (countryId > 0) {
                ps.addQuery(" AND city.country_id = ? ");
                ps.addInt(countryId);
            }
            if (cityIdFilter != null && cityIdFilter.size() > 0) {
                ps.addQuery(" AND city.id IN ( ");
                ps.addQuery(Utils.toString(cityIdFilter, "", ","));
                ps.addQuery(" ) ");
            }
            ps.addQuery(" ORDER BY city.title");
            ps.addQuery(this.getPageLimit(page));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AddressCity addressCity = AddressDAO.getAddressCityFromRs(rs, "city.");
                if (loadCountryData) {
                    addressCity.setAddressCountry(AddressDAO.getAddressCountryFromRs(rs, "country."));
                }
                result.add(addressCity);
            }
            this.setRecordCount(page, ps.getPrepared());
            ps.close();
        }
    }

    public AddressCity getAddressCity(int id, boolean loadCountryData) throws SQLException {
        AddressCity addressCity = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(" address_city ");
        query.append(" AS city");
        if (loadCountryData) {
            query.append(" LEFT JOIN ");
            query.append(" address_country ");
            query.append(" AS country ON city.country_id=country.id");
        }
        query.append(" WHERE city.id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressCity = AddressDAO.getAddressCityFromRs(rs, "city.");
            if (!loadCountryData) continue;
            addressCity.setAddressCountry(AddressDAO.getAddressCountryFromRs(rs, "country."));
        }
        ps.close();
        return addressCity;
    }

    public List<IdTitle> getAddressCities(List<Integer> ids) throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        String idsStr = Utils.toString(ids);
        String query = "SELECT * FROM  address_city  WHERE id IN (" + idsStr + ") ORDER BY FIELD (id," + idsStr + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt("id"), rs.getString("title")));
            }
        }
        return result;
    }

    public void searchAddressAreaList(Pageable<AddressItem> searchResult, int cityId) throws SQLException {
        this.searchAddressItemList(" address_area ", searchResult, Collections.singleton(cityId), null, false, false);
    }

    public void searchAddressAreaList(Pageable<AddressItem> searchResult, int cityId, List<String> title, boolean loadCountryData, boolean loadCityData) throws SQLException {
        this.searchAddressItemList(" address_area ", searchResult, Collections.singleton(cityId), title, loadCountryData, loadCityData);
    }

    public AddressItem getAddressArea(int id, boolean loadCountryData, boolean loadCityData) throws SQLException {
        return this.getAddressItem(" address_area ", id, loadCountryData, loadCityData);
    }

    public void searchAddressQuarterList(Pageable<AddressItem> searchResult, int cityId) throws SQLException {
        this.searchAddressItemList(" address_quarter ", searchResult, Collections.singleton(cityId), null, false, false);
    }

    public void searchAddressQuarterList(Pageable<AddressItem> searchResult, int cityId, List<String> title, boolean loadCountryData, boolean loadCityData) throws SQLException {
        this.searchAddressItemList(" address_quarter ", searchResult, Collections.singleton(cityId), title, loadCountryData, loadCityData);
    }

    public AddressItem getAddressQuarter(int id, boolean loadCountryData, boolean loadCityData) throws SQLException {
        return this.getAddressItem(" address_quarter ", id, loadCountryData, loadCityData);
    }

    public void searchAddressStreetList(Pageable<AddressItem> searchResult, int cityId) throws SQLException {
        this.searchAddressItemList(" address_street ", searchResult, Collections.singleton(cityId), null, false, false);
    }

    public void searchAddressStreetList(Pageable<AddressItem> searchResult, Set<Integer> cityIds, List<String> title, boolean loadCountryData, boolean loadCityData) throws SQLException {
        this.searchAddressItemList(" address_street ", searchResult, cityIds, title, loadCountryData, loadCityData);
    }

    public AddressItem getAddressStreet(int id, boolean loadCountryData, boolean loadCityData) throws SQLException {
        return this.getAddressItem(" address_street ", id, loadCountryData, loadCityData);
    }

    private void searchAddressItemList(String tableName, Pageable<AddressItem> searchResult, Set<Integer> cityIds, List<String> title, boolean loadCountryData, boolean loadCityData) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<AddressItem> result = searchResult.getList();
            PreparedQuery pq = new PreparedQuery(this.con, "SELECT SQL_CALC_FOUND_ROWS *");
            if (title != null && title.size() > 1) {
                pq.addQuery(", CONCAT(item.title");
                if (loadCityData) {
                    pq.addQuery(", ' ', city.title");
                }
                pq.addQuery(") AS titles ");
            }
            pq.addQuery(" FROM ");
            pq.addQuery(tableName);
            pq.addQuery(" AS item ");
            if (loadCityData) {
                pq.addQuery("LEFT JOIN ");
                pq.addQuery(" address_city ");
                pq.addQuery(" AS city ON item.city_id = city.id ");
                if (loadCountryData) {
                    pq.addQuery("LEFT JOIN ");
                    pq.addQuery(" address_country ");
                    pq.addQuery(" AS country ON city.country_id = country.id ");
                }
            }
            pq.addQuery("WHERE 1=1 ");
            if (CollectionUtils.isNotEmpty(cityIds)) {
                boolean hasPositiveCityIds = false;
                Iterator<Integer> iterator = cityIds.iterator();
                while (!hasPositiveCityIds && iterator.hasNext()) {
                    Integer cityId = iterator.next();
                    if (cityId <= 0) continue;
                    hasPositiveCityIds = true;
                    pq.addQuery(" AND city_id IN( " + Utils.toString(cityIds) + " ) ");
                }
            }
            if (title != null) {
                if (title.size() == 1) {
                    pq.addQuery(" AND item.title LIKE ? ");
                    pq.addString(title.get(0));
                } else if (title.size() > 1) {
                    pq.addQuery(" HAVING titles LIKE ?");
                    pq.addString(title.get(0));
                    for (int i = 1; i < title.size(); ++i) {
                        pq.addQuery(" AND titles LIKE ?");
                        pq.addString(title.get(1));
                    }
                }
            }
            pq.addQuery(" ORDER BY ");
            if (loadCityData) {
                pq.addQuery("city.title, ");
            }
            pq.addQuery("item.title ");
            pq.addQuery(this.getPageLimit(page));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                AddressItem addressItem = AddressDAO.getAddressItemFromRs(rs, "item.");
                if (loadCityData) {
                    AddressCity addressCity = AddressDAO.getAddressCityFromRs(rs, "city.");
                    addressItem.setAddressCity(addressCity);
                    if (loadCountryData && addressCity != null) {
                        AddressCountry addressCountry = AddressDAO.getAddressCountryFromRs(rs, "country.");
                        addressCity.setAddressCountry(addressCountry);
                    }
                }
                result.add(addressItem);
            }
            if (page != null) {
                page.setRecordCount(this.foundRows(pq.getPrepared()));
            }
            pq.close();
        }
    }

    private AddressItem getAddressItem(String tableName, int id, boolean loadCountryData, boolean loadCityData) throws SQLException {
        AddressItem addressItem = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ");
        query.append(tableName);
        query.append(" AS item");
        if (loadCityData) {
            query.append(" LEFT JOIN ");
            query.append(" address_city ");
            query.append(" AS city ON item.city_id=city.id");
            if (loadCountryData) {
                query.append(" LEFT JOIN ");
                query.append(" address_country ");
                query.append(" AS country ON city.country_id=country.id");
            }
        }
        query.append(" WHERE item.id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressItem = AddressDAO.getAddressItemFromRs(rs, "item.");
            if (!loadCityData) continue;
            AddressCity addressCity = AddressDAO.getAddressCityFromRs(rs, "city.");
            addressItem.setAddressCity(addressCity);
            if (!loadCountryData || addressCity == null) continue;
            AddressCountry addressCountry = AddressDAO.getAddressCountryFromRs(rs, "country.");
            addressCity.setAddressCountry(addressCountry);
        }
        ps.close();
        return addressItem;
    }

    public void searchAddressHouseList(Pageable<AddressHouse> searchResult, int streetId, String housePrefix) throws SQLException {
        this.searchAddressHouseList(searchResult, streetId, housePrefix, false, false, false, false);
    }

    public void searchAddressHouseList(Pageable<AddressHouse> searchResult, int streetId, String house, boolean absolute, boolean loadCountryData, boolean loadCityData, boolean loadStreetData) throws SQLException {
        if (searchResult != null && streetId > 0) {
            Page page = searchResult.getPage();
            List<AddressHouse> result = searchResult.getList();
            PreparedQuery pq = new PreparedQuery(this.con);
            AddressHouse searchParams = new AddressHouse().withHouseAndFrac(house);
            int number = searchParams.getHouse();
            String frac = searchParams.getFrac();
            int loadLevel = AddressDAO.getHouseLoadLevel(loadCountryData, loadCityData, loadStreetData);
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS * FROM ");
            pq.addQuery(" address_house ");
            pq.addQuery(" AS house");
            AddressDAO.addHouseSelectQueryJoins(pq.getQuery(), loadLevel);
            pq.addQuery(" WHERE 1=1 AND house.street_id=?");
            pq.addInt(streetId);
            if (absolute) {
                if (number > 0) {
                    pq.addQuery(" AND house.house=? ");
                    pq.addInt(number);
                    if (frac != null) {
                        pq.addQuery(" AND house.frac=?");
                        pq.addString(frac);
                    }
                }
            } else {
                if (number > 0) {
                    pq.addQuery(" AND house.house LIKE CONCAT(?, '%')");
                    pq.addInt(number);
                }
                if (Utils.notBlankString(frac)) {
                    pq.addQuery(" AND house.frac LIKE CONCAT('%', ?, '%')");
                    pq.addString(frac);
                }
            }
            pq.addQuery(" ORDER BY house.house, house.frac");
            pq.addQuery(this.getPageLimit(page));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(AddressDAO.getAddressHouseFromRs(rs, "house.", loadLevel));
            }
            if (page != null) {
                page.setRecordCount(this.foundRows(pq.getPrepared()));
            }
            pq.close();
        }
    }

    public AddressHouse getAddressHouse(int id, boolean loadCountryData, boolean loadCityData, boolean loadStreetData) throws SQLException {
        AddressHouse addressHouse = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder();
        int loadLevel = AddressDAO.getHouseLoadLevel(loadCountryData, loadCityData, loadStreetData);
        query.append("SELECT * FROM ");
        query.append(" address_house ");
        query.append(" AS house");
        AddressDAO.addHouseSelectQueryJoins(query, loadLevel);
        query.append(" WHERE house.id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressHouse = AddressDAO.getAddressHouseFromRs(rs, "house.", loadLevel);
        }
        ps.close();
        return addressHouse;
    }

    public static void addHouseSelectQueryJoins(StringBuilder query, int loadLevel) {
        if (loadLevel >= 2) {
            query.append(" LEFT JOIN ");
            query.append(" address_street ");
            query.append(" AS street ON house.street_id=street.id");
            query.append(" LEFT JOIN ");
            query.append(" address_area ");
            query.append(" AS area ON house.area_id=area.id");
            query.append(" LEFT JOIN ");
            query.append(" address_quarter ");
            query.append(" AS quarter ON house.quarter_id=quarter.id");
            if (loadLevel >= 3) {
                query.append(" LEFT JOIN ");
                query.append(" address_city ");
                query.append(" AS city ON street.city_id=city.id");
                if (loadLevel >= 4) {
                    query.append(" LEFT JOIN ");
                    query.append(" address_country ");
                    query.append(" AS country ON city.country_id=country.id");
                }
            }
        }
    }

    public AddressCountry updateAddressCountry(AddressCountry value) throws SQLException {
        if (value != null) {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            if (value.getId() <= 0) {
                query.append("INSERT INTO ");
                query.append(" address_country ");
                query.append(" SET title=?, last_update = NOW()");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setString(1, value.getTitle());
                ps.executeUpdate();
                value.setId(this.lastInsertId(ps));
                ps.close();
            } else {
                query.append("UPDATE ");
                query.append(" address_country ");
                query.append(" SET title=?, last_update = NOW() WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(1, value.getTitle());
                ps.setInt(2, value.getId());
                ps.executeUpdate();
                ps.close();
            }
        }
        return value;
    }

    public void deleteAddressCountry(int id) throws SQLException, BGMessageException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM ");
        query.append(" address_city ");
        query.append("WHERE country_id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && rs.getInt(1) > 0) {
            throw new BGMessageException("\u0421\u0442\u0440\u0430\u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0433\u043e\u0440\u043e\u0434\u0430\u0445.", new Object[0]);
        }
        ps.close();
        query.setLength(0);
        query.append("DELETE FROM ");
        query.append(" address_country ");
        query.append("WHERE id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public AddressCity updateAddressCity(AddressCity city) throws SQLException {
        if (city != null) {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            if (city.getId() <= 0) {
                query.append("INSERT INTO ");
                query.append(" address_city ");
                query.append(" SET country_id=?, title=?, last_update = NOW()");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(1, city.getCountryId());
                ps.setString(2, city.getTitle());
                ps.executeUpdate();
                city.setId(this.lastInsertId(ps));
                ps.close();
            } else {
                query.append("UPDATE ");
                query.append(" address_city ");
                query.append(" SET title=?, last_update = NOW() WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(1, city.getTitle());
                ps.setInt(2, city.getId());
                ps.executeUpdate();
                ps.close();
            }
        }
        return city;
    }

    public void deleteAddressCity(int id) throws SQLException, BGMessageException {
        this.checkItem(id, " address_street ", "\u0443\u043b\u0438\u0446\u0430\u0445");
        this.checkItem(id, " address_quarter ", "\u043a\u0432\u0430\u0440\u0442\u0430\u043b\u0430\u0445");
        this.checkItem(id, " address_area ", "\u0440\u0430\u0439\u043e\u043d\u0430\u0445");
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ");
        query.append(" address_city ");
        query.append("WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    private void checkItem(int id, String table, String title) throws SQLException, BGMessageException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM ");
        query.append(table);
        query.append("WHERE city_id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && rs.getInt(1) > 0) {
            throw new BGMessageException("\u0413\u043e\u0440\u043e\u0434 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 " + title + ".", new Object[0]);
        }
        ps.close();
    }

    public AddressItem updateAddressArea(AddressItem item) throws SQLException {
        return this.updateAddressItem(" address_area ", item);
    }

    public AddressItem updateAddressQuarter(AddressItem addressItem) throws SQLException {
        return this.updateAddressItem(" address_quarter ", addressItem);
    }

    public AddressItem updateAddressStreet(AddressItem addressItem) throws SQLException {
        return this.updateAddressItem(" address_street ", addressItem);
    }

    public void deleteAddressArea(int id) throws SQLException, BGMessageException {
        this.deleteAddressItem(" address_area ", "area_id", id);
    }

    public void deleteAddressQuarter(int id) throws SQLException, BGMessageException {
        this.deleteAddressItem(" address_quarter ", "quarter_id", id);
    }

    public void deleteAddressStreet(int id) throws SQLException, BGMessageException {
        this.deleteAddressItem(" address_street ", "street_id", id);
    }

    private AddressItem updateAddressItem(String tableName, AddressItem addressItem) throws SQLException {
        if (addressItem != null) {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            if (addressItem.getId() <= 0) {
                query.append("INSERT INTO ");
                query.append(tableName);
                query.append(" SET city_id=?, title=?, last_update = NOW()");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(1, addressItem.getCityId());
                ps.setString(2, addressItem.getTitle());
                ps.executeUpdate();
                addressItem.setId(this.lastInsertId(ps));
                ps.close();
            } else {
                query.append("UPDATE ");
                query.append(tableName);
                query.append(" SET title=?, last_update = NOW() WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(1, addressItem.getTitle());
                ps.setInt(2, addressItem.getId());
                ps.executeUpdate();
                ps.close();
            }
        }
        return addressItem;
    }

    private void deleteAddressItem(String tableName, String columnName, int id) throws SQLException, BGMessageException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("COUNT(*)");
        query.append(" FROM ");
        query.append(" address_house ");
        query.append(" WHERE ");
        query.append(columnName + "=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && rs.getInt(1) > 0) {
            throw new BGMessageException("\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0434\u043e\u043c\u0443.", new Object[0]);
        }
        ps.close();
        query.setLength(0);
        query.append("DELETE FROM ");
        query.append(tableName);
        query.append(" WHERE ");
        query.append("id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public AddressHouse updateAddressHouse(AddressHouse addressHouse) throws SQLException {
        if (addressHouse != null) {
            int index = 1;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            if (addressHouse.getId() <= 0) {
                query.append("INSERT INTO ");
                query.append(" address_house ");
                query.append(" SET area_id=?, quarter_id=?, street_id=?, house=?, frac=?, post_index=?, comment=?, last_update=NOW()");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, addressHouse.getAreaId());
                ps.setInt(index++, addressHouse.getQuarterId());
                ps.setInt(index++, addressHouse.getStreetId());
                ps.setInt(index++, addressHouse.getHouse());
                ps.setString(index++, addressHouse.getFrac() == null ? "" : addressHouse.getFrac());
                ps.setString(index++, addressHouse.getPostIndex());
                ps.setString(index++, addressHouse.getComment());
                ps.executeUpdate();
                addressHouse.setId(this.lastInsertId(ps));
                ps.close();
            } else {
                query.append("UPDATE ");
                query.append(" address_house ");
                query.append(" SET area_id=?, quarter_id=?, street_id=?, house=?, frac=?, post_index=?, comment=?, last_update=NOW() WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, addressHouse.getAreaId());
                ps.setInt(index++, addressHouse.getQuarterId());
                ps.setInt(index++, addressHouse.getStreetId());
                ps.setInt(index++, addressHouse.getHouse());
                ps.setString(index++, addressHouse.getFrac() == null ? "" : addressHouse.getFrac());
                ps.setString(index++, addressHouse.getPostIndex());
                ps.setString(index++, addressHouse.getComment());
                ps.setInt(index++, addressHouse.getId());
                ps.executeUpdate();
                ps.close();
            }
        }
        return addressHouse;
    }

    public void deleteAddressHouse(int id) throws SQLException, BGMessageException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM");
        query.append(" param_address ");
        query.append("WHERE house_id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && rs.getInt(1) > 0) {
            throw new BGMessageException("\u0414\u043e\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445.", new Object[0]);
        }
        ps.close();
        query.setLength(0);
        query.append("DELETE FROM ");
        query.append(" address_house ");
        query.append("WHERE id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public static AddressHouse getAddressHouseFromRs(ResultSet rs, String prefix, int loadLevel) throws SQLException {
        AddressHouse addressHouse = new AddressHouse();
        addressHouse.setId(rs.getInt(prefix + "id"));
        addressHouse.setAreaId(rs.getInt(prefix + "area_id"));
        addressHouse.setQuarterId(rs.getInt(prefix + "quarter_id"));
        addressHouse.setStreetId(rs.getInt(prefix + "street_id"));
        addressHouse.setHouse(rs.getInt(prefix + "house"));
        addressHouse.setFrac(rs.getString(prefix + "frac"));
        addressHouse.setPostIndex(rs.getString(prefix + "post_index"));
        addressHouse.setComment(rs.getString(prefix + "comment"));
        if (loadLevel >= 2) {
            AddressItem addressStreet = AddressDAO.getAddressItemFromRs(rs, "street.");
            addressHouse.setAddressStreet(addressStreet);
            addressHouse.setAddressArea(AddressDAO.getAddressItemFromRs(rs, "area."));
            addressHouse.setAddressQuarter(AddressDAO.getAddressItemFromRs(rs, "quarter."));
            if (loadLevel >= 3) {
                AddressCity addressCity = AddressDAO.getAddressCityFromRs(rs, "city.");
                addressStreet.setAddressCity(addressCity);
                if (loadLevel >= 4) {
                    AddressCountry addressCountry = AddressDAO.getAddressCountryFromRs(rs, "country.");
                    addressCity.setAddressCountry(addressCountry);
                }
            }
        }
        return addressHouse;
    }

    public static AddressItem getAddressItemFromRs(ResultSet rs, String prefix) throws SQLException {
        AddressItem addressItem = new AddressItem();
        addressItem.setId(rs.getInt(prefix + "id"));
        addressItem.setCityId(rs.getInt(prefix + "city_id"));
        addressItem.setTitle(rs.getString(prefix + "title"));
        return addressItem;
    }

    public static AddressCountry getAddressCountryFromRs(ResultSet rs, String prefix) throws SQLException {
        AddressCountry addressCountry = new AddressCountry();
        addressCountry.setId(rs.getInt(prefix + "id"));
        addressCountry.setTitle(rs.getString(prefix + "title"));
        return addressCountry;
    }

    public static AddressCity getAddressCityFromRs(ResultSet rs, String prefix) throws SQLException {
        AddressCity addressCity = new AddressCity();
        addressCity.setId(rs.getInt(prefix + "id"));
        addressCity.setCountryId(rs.getInt(prefix + "country_id"));
        addressCity.setTitle(rs.getString(prefix + "title"));
        return addressCity;
    }

    public List<AddressCountry> getUpdatedCountries(long time, int[] countriesId) throws SQLException {
        ArrayList<AddressCountry> result = new ArrayList<AddressCountry>();
        String ids = this.getIdsString(countriesId);
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(" address_country ");
        query.append(" WHERE last_update>=?");
        if (ids.length() > 0) {
            query.append(" AND id IN ( ");
            query.append(ids);
            query.append(" )");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setTimestamp(1, new Timestamp(time));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AddressDAO.getAddressCountryFromRs(rs, ""));
            }
        }
        return result;
    }

    public List<AddressCity> getUpdatedCities(long time, int[] citiesId) throws SQLException {
        ArrayList<AddressCity> result = new ArrayList<AddressCity>();
        String ids = this.getIdsString(citiesId);
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(" address_city ");
        query.append(" WHERE last_update>=?");
        if (ids.length() > 0) {
            query.append(" AND id IN ( ");
            query.append(ids);
            query.append(" )");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setTimestamp(1, new Timestamp(time));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AddressDAO.getAddressCityFromRs(rs, ""));
            }
        }
        return result;
    }

    public List<AddressHouse> getUpdatedHouses(long time, int[] citiesId) throws SQLException {
        ArrayList<AddressHouse> result = new ArrayList<AddressHouse>();
        String ids = this.getIdsString(citiesId);
        StringBuilder query = new StringBuilder("SELECT h.* FROM ");
        query.append(" address_house ");
        query.append(" AS h LEFT JOIN ");
        query.append(" address_street ");
        query.append(" AS s ON h.street_id=s.id WHERE h.last_update>=?");
        if (ids.length() > 0) {
            query.append(" AND s.city_id IN ( ");
            query.append(ids);
            query.append(" )");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setTimestamp(1, new Timestamp(time));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AddressDAO.getAddressHouseFromRs(rs, "h.", 0));
            }
        }
        return result;
    }

    private List<AddressItem> getUpdatedItems(String tableName, long time, int[] citiesId) throws SQLException {
        ArrayList<AddressItem> result = new ArrayList<AddressItem>();
        String ids = this.getIdsString(citiesId);
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(tableName);
        query.append(" WHERE last_update>=?");
        if (ids.length() > 0) {
            query.append(" AND city_id IN ( ");
            query.append(ids);
            query.append(" )");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setTimestamp(1, new Timestamp(time));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AddressDAO.getAddressItemFromRs(rs, ""));
            }
        }
        return result;
    }

    public List<AddressItem> getUpdatedAreas(long time, int[] citiesId) throws SQLException {
        return this.getUpdatedItems(" address_area ", time, citiesId);
    }

    public List<AddressItem> getUpdatedQuarters(long time, int[] citiesId) throws SQLException {
        return this.getUpdatedItems(" address_quarter ", time, citiesId);
    }

    public List<AddressItem> getUpdatedStreets(long time, int[] citiesId) throws SQLException {
        return this.getUpdatedItems(" address_street ", time, citiesId);
    }

    public List<Integer> getCountryIdByCityId(int[] citiesId) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashSet<Integer> countryIdSet = new HashSet<Integer>();
        String ids = this.getIdsString(citiesId);
        StringBuilder query = new StringBuilder("SELECT country_id FROM ");
        query.append(" address_city ");
        query.append(" WHERE true");
        if (ids.length() > 0) {
            query.append(" AND id IN ( ");
            query.append(ids);
            query.append(" )");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Integer countryId = rs.getInt(1);
            if (countryIdSet.contains(countryId)) continue;
            countryIdSet.add(countryId);
            list.add(countryId);
        }
        ps.close();
        return list;
    }

    public List<AddressItem> getAddressStreetsBySubstring(String streetSubstring, List<Integer> cityIds) throws SQLException {
        ArrayList<AddressItem> matchStreets = new ArrayList<AddressItem>();
        if (cityIds == null || cityIds.size() > 0) {
            StringBuilder query = new StringBuilder("SELECT * FROM ");
            query.append(" address_street ");
            query.append(" WHERE title like ?");
            if (cityIds != null) {
                query.append(" AND ");
                for (int i = 0; i < cityIds.size(); ++i) {
                    if (i == 0) {
                        query.append(" ( ");
                    }
                    query.append(" city_id=? ");
                    if (i != cityIds.size() - 1) {
                        query.append(" OR ");
                        continue;
                    }
                    query.append(" ) ");
                }
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            ps.setString(index++, "%" + streetSubstring + "%");
            if (cityIds != null) {
                for (Integer cityId : cityIds) {
                    ps.setInt(index++, cityId);
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                matchStreets.add(AddressDAO.getAddressItemFromRs(rs, ""));
            }
            ps.close();
        }
        return matchStreets;
    }

    public int getCityIdByAddress(String address) throws SQLException {
        int cityId = -1;
        PreparedStatement ps = this.con.prepareStatement("SELECT id FROM  address_city WHERE title = ?");
        ps.setString(1, address.split(",")[0]);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            cityId = rs.getInt(1);
        }
        ps.close();
        return cityId;
    }

    public List<Integer> getHouseIdsByStreetAndHouse(int streetId, String house, List<Integer> cityIds) throws SQLException {
        ArrayList<Integer> houseIds = new ArrayList<Integer>();
        if (cityIds == null || cityIds.size() > 0) {
            String houseFrac;
            AddressHouse houseAndFrac = new AddressHouse().withHouseAndFrac(house);
            PreparedQuery pq = new PreparedQuery(this.con);
            pq.addQuery("SELECT house.id FROM ");
            pq.addQuery(" address_house ");
            pq.addQuery(" AS house");
            if (cityIds != null) {
                pq.addQuery(" LEFT JOIN ");
                pq.addQuery(" address_street ");
                pq.addQuery(" AS street ON house.street_id=street.id");
            }
            pq.addQuery(" WHERE street_id=?");
            pq.addInt(streetId);
            if (houseAndFrac.getHouse() > 0) {
                pq.addQuery(" AND house=?");
                pq.addInt(houseAndFrac.getHouse());
            }
            if ((houseFrac = houseAndFrac.getFrac()) != null && !houseFrac.equals("*")) {
                pq.addString(houseFrac);
                if (houseFrac.startsWith("/")) {
                    pq.addQuery(" AND (frac=? OR frac=?)");
                    pq.addString(houseFrac);
                } else {
                    pq.addQuery(" AND frac=?");
                }
            }
            if (cityIds != null) {
                pq.addQuery(" AND street.city_id IN (");
                pq.addQuery(Utils.toString(cityIds));
                pq.addQuery(")");
            }
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                houseIds.add(rs.getInt(1));
            }
            pq.close();
        }
        return houseIds;
    }

    private String getIdsString(int[] array) {
        StringBuilder ids = new StringBuilder();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(array[i]);
            }
        }
        return ids.toString();
    }
}

