/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.bgerp.util.Log;
import org.bgerp.util.xml.NodeListElementIterator;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLUtils {
    private static final Log logger = Log.getLog();

    public static String getElementText(Node node) {
        StringBuffer reply = new StringBuffer();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof CharacterData && !(child instanceof Comment) || child instanceof EntityReference) {
                reply.append(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() != 1) continue;
            if (child.getChildNodes().getLength() == 0) {
                reply.append("<").append(child.getNodeName()).append("/>");
                continue;
            }
            reply.append("<").append(child.getNodeName());
            NamedNodeMap attrs = child.getAttributes();
            if (attrs.getLength() > 0) {
                reply.append(" ");
            }
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                reply.append(attr.getNodeName()).append("=\"");
                if (j == attrs.getLength() - 1) {
                    reply.append(attr.getNodeValue()).append("\"");
                    continue;
                }
                reply.append(attr.getNodeValue()).append("\" ");
            }
            reply.append(">");
            reply.append(XMLUtils.getElementText(child));
            reply.append("</").append(child.getNodeName()).append(">");
        }
        return reply.toString();
    }

    public static final Document newDocument() {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static final Element newElement(Element parent, String name) {
        Element result = parent.getOwnerDocument().createElement(name);
        parent.appendChild(result);
        return result;
    }

    public static final Element newElement(Document parent, String name) {
        Element result = parent.createElement(name);
        parent.appendChild(result);
        return result;
    }

    public static void createTextNode(Node node, String text) {
        if (node != null && text != null) {
            node.appendChild(node.getOwnerDocument().createTextNode(text));
        }
    }

    public static void setAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttribute(name, value);
        }
    }

    public static Document parseDocument(InputStream stream) {
        return XMLUtils.parseDocument(stream, true);
    }

    public static Document parseDocument(InputStream stream, boolean showError) {
        return XMLUtils.parseDocument(new InputSource(stream), showError);
    }

    public static Document parseDocument(InputSource source) {
        return XMLUtils.parseDocument(source, true);
    }

    public static Document parseDocument(InputSource source, boolean showError) {
        Document result;
        block3: {
            result = null;
            if (source != null) {
                try {
                    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                    dFactory.setNamespaceAware(true);
                    dFactory.setValidating(false);
                    DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                    result = docBuilder.parse(source);
                }
                catch (Exception e) {
                    if (!showError) break block3;
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    public static void parseDocument(InputSource source, ContentHandler handler) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            parser.setContentHandler(handler);
            parser.parse(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Element getElement(Document doc, String elementName) {
        return (Element)XMLUtils.getNode(doc, elementName);
    }

    public static Node getNode(Document doc, String nodeName) {
        Node node = null;
        if (doc == null) {
            return node;
        }
        NodeList list = doc.getElementsByTagName(nodeName);
        if (list != null && list.getLength() > 0) {
            node = list.item(0);
        } else {
            node = doc.createElement(nodeName);
            doc.getDocumentElement().appendChild(node);
        }
        return node;
    }

    public static Element selectElement(Node node, String expression) {
        return (Element)XMLUtils.selectNode(node, expression);
    }

    public static Node selectNode(Node node, String expression) {
        try {
            return (Node)XPathFactory.newInstance().newXPath().evaluate(expression, node, XPathConstants.NODE);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static NodeList selectNodeList(Node node, String expression) {
        try {
            return (NodeList)XPathFactory.newInstance().newXPath().evaluate(expression, node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static Iterable<Element> selectElements(Node node, String expression) {
        try {
            NodeList nodeList = XMLUtils.selectNodeList(node, expression);
            return XMLUtils.elements(nodeList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static Iterable<Element> elements(final NodeList nodeList) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new NodeListElementIterator(nodeList);
            }
        };
    }

    public static String selectText(Node node, String expression) {
        return XMLUtils.selectText(node, expression, null);
    }

    public static String selectText(Node node, String expression, String defaultValue) {
        try {
            Node result = XMLUtils.selectNode(node, expression);
            return result != null ? result.getNodeValue() : defaultValue;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            return defaultValue;
        }
    }

    public static void serialize(Node xml, OutputStream result, String encoding, boolean pretty) throws Exception {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSOutput formattedOutput = domImplementation.createLSOutput();
        formattedOutput.setByteStream(result);
        formattedOutput.setEncoding(encoding);
        LSSerializer domSerializer = domImplementation.createLSSerializer();
        domSerializer.getDomConfig().setParameter("format-pretty-print", pretty);
        domSerializer.getDomConfig().setParameter("xml-declaration", false);
        domSerializer.write(xml, formattedOutput);
    }

    public static void prepareElementToSerialize(Node el) {
        StringBuilder buf = new StringBuilder(100);
        int size = 0;
        NamedNodeMap map = el.getAttributes();
        if (map != null) {
            size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = map.item(i);
                String nodeValue = node.getNodeValue();
                node.setNodeValue(XMLUtils.prepareString(buf, nodeValue));
            }
        }
        if (el.getNodeValue() != null) {
            el.setNodeValue(XMLUtils.prepareString(buf, el.getNodeValue()));
        }
        NodeList childs = el.getChildNodes();
        size = childs.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = childs.item(i);
            XMLUtils.prepareElementToSerialize(child);
        }
    }

    public static String prepareString(StringBuilder buf, String nodeValue) {
        buf.setLength(0);
        for (int j = 0; j < nodeValue.length(); ++j) {
            char ch = nodeValue.charAt(j);
            char ich = ch;
            if (ich == '\t' || ich == '\n' || ich == '\r' || ich >= ' ' && ich <= '\ud7ff' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                buf.append(ch);
                continue;
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        return buf.toString();
    }

    public static void transform(Source xml, Source xslt, Result res, String enc) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslt);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        if (enc != null) {
            transformer.setOutputProperty("encoding", enc);
        }
        transformer.transform(xml, res);
    }
}

