/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.mail;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.util.Log;
import org.bgerp.util.mail.Addresses;
import org.bgerp.util.mail.MailConfig;
import ru.bgcrm.model.FileData;

public class MailMsg {
    private static final Log log = Log.getLog();
    private final String encoding;
    private final MimeMessage msg;
    private List<FileData> attachments;

    public static String getParamMailEncoding(ConfigMap config) {
        return config.get("mail.encoding", StandardCharsets.UTF_8.name());
    }

    public static void setAttachContentTypeHeader(MimeBodyPart part) throws MessagingException {
        part.setHeader("Content-Type", "charset=\"UTF-8\"; format=\"flowed\"");
    }

    public static void setAttachFileName(MimeBodyPart part, String value, String encoding) throws MessagingException {
        try {
            part.setFileName(MimeUtility.encodeWord((String)value, (String)encoding, null));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e);
        }
    }

    public MailMsg(ConfigMap config) {
        String fromAddress = config.get("mail.from.email", null);
        String fromName = config.get("mail.from.name", "BGERP");
        if (fromAddress == null) {
            throw new IllegalArgumentException("Parameter 'mail.from.email' not defined in config!");
        }
        this.encoding = MailMsg.getParamMailEncoding(config);
        this.msg = new MimeMessage(new MailConfig(config).getSmtpSession(null));
        try {
            this.msg.setSentDate(new Date());
            this.msg.setFrom((Address)new InternetAddress(fromAddress, fromName, this.encoding));
        }
        catch (UnsupportedEncodingException | MessagingException ex) {
            log.error(ex);
        }
    }

    public MailMsg withAttachments(List<FileData> value) {
        this.attachments = value;
        return this;
    }

    public void send(String recipients, String subject, String txt) throws MessagingException {
        this.msg.setRecipients(Message.RecipientType.TO, (Address[])Addresses.parseSafe(recipients).recipients().get(Message.RecipientType.TO));
        this.msg.setSubject(subject, this.encoding);
        if (this.attachments == null || this.attachments.isEmpty()) {
            this.msg.setText(txt, this.encoding);
        } else {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setText(txt, this.encoding);
            mp.addBodyPart((BodyPart)part);
            for (FileData attachment : this.attachments) {
                part = new MimeBodyPart();
                MailMsg.setAttachContentTypeHeader(part);
                MailMsg.setAttachFileName(part, attachment.getTitle(), this.encoding);
                part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachment.getData(), "application/octet-stream; name=" + attachment.getTitle())));
                mp.addBodyPart((BodyPart)part);
            }
            this.msg.setContent((Multipart)mp);
        }
        this.send();
    }

    private void send() throws MessagingException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            this.msg.writeTo((OutputStream)bos);
            log.info("Sending a mail:\n{}", new String(bos.toByteArray(), this.encoding));
        }
        catch (Exception e) {
            log.error(e);
        }
        Transport transport = this.msg.getSession().getTransport();
        transport.connect();
        transport.sendMessage((Message)this.msg, this.msg.getAllRecipients());
        transport.close();
    }
}

