/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba.action.admin;

import java.sql.Statement;
import java.time.YearMonth;
import java.util.List;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.plugin.svc.dba.Config;
import org.bgerp.plugin.svc.dba.dao.DatabaseDAO;
import org.bgerp.plugin.svc.dba.model.TableStatus;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/plugin/dba/db", pathId=true)
public class DatabaseAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/plugin/dba";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        List<TableStatus> tables = new DatabaseDAO(conSet.getConnection()).tables();
        this.setup.getConfig(Config.class).dropCandidates(tables, YearMonth.now());
        Long rows = tables.stream().map(status -> status.getRows()).reduce(0L, Long::sum);
        form.setResponseData("rows", rows);
        Long size = tables.stream().map(status -> status.getDataLength() + status.getIndexLength()).reduce(0L, Long::sum);
        form.setResponseData("size", size);
        Integer dropCandidateCnt = tables.stream().map(status -> status.isDropCandidate() ? 1 : 0).reduce(0, Integer::sum);
        form.setResponseData("dropCandidateCnt", dropCandidateCnt);
        form.setResponseData("tables", tables);
        return this.html(conSet, form, "/WEB-INF/jspf/admin/plugin/dba/database.jsp");
    }

    public ActionForward tableDrop(DynActionForm form, ConnectionSet conSet) throws Exception {
        List<String> tables = form.getParamValuesListStr("table");
        try (Statement st = conSet.getConnection().createStatement();){
            for (String table : tables) {
                st.executeUpdate("DROP TABLE " + table);
            }
        }
        return this.unspecified(form, conSet);
    }
}

