/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.sec.access.action;

import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.user.User;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/access/credential")
public class CredentialAction
extends BaseAction {
    public ActionForward get(DynActionForm form, ConnectionSet conSet) throws Exception {
        User user = UserCache.getUser(form.getId());
        if (user == null) {
            throw new BGException("User not found: " + form.getId(), new Object[0]);
        }
        String text = this.l.l("credentials.get.text", user.getTitle(), user.getLogin(), user.getPassword());
        form.setResponseData("text", text);
        return this.json(conSet, form);
    }

    public ActionForward sendToUser(DynActionForm form, ConnectionSet conSet) throws Exception {
        int userId = form.getId();
        if (UserCache.getUser(userId) == null) {
            throw new BGException("User not found: " + userId, new Object[0]);
        }
        Parameter emailParam = ParameterCache.getObjectTypeParameterList("user").stream().filter(p -> p.getType().equals("email")).findFirst().orElse(null);
        if (emailParam == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0442\u0438\u043f\u043e\u043c 'email'", new Object[0]);
        }
        ParameterEmailValue emailValue = Utils.getFirst(new ParamValueDAO(conSet.getSlaveConnection()).getParamEmail(userId, emailParam.getId()).values());
        if (emailValue == null || Utils.isBlankString(emailValue.getValue())) {
            throw new BGMessageException("E-Mail \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d", new Object[0]);
        }
        return this.json(conSet, form);
    }
}

