/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.report.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.plugin.report.model.Column;

public class Columns {
    private final List<Column> columnList;
    private final Map<String, Column> columnMap;
    private final List<Column> visibleColumns;

    public Columns(Column ... column) {
        this.columnList = List.of(column);
        HashMap<String, Column> columnMap = new HashMap<String, Column>(column.length);
        for (int i = 0; i < this.columnList.size(); ++i) {
            Column col = this.columnList.get(i);
            col.setIndex(i);
            columnMap.put(col.getId(), col);
        }
        this.columnMap = Collections.unmodifiableMap(columnMap);
        this.visibleColumns = this.columnList.stream().filter(Column::isVisible).collect(Collectors.toUnmodifiableList());
    }

    public int size() {
        return this.columnList.size();
    }

    public List<Column> getVisibleColumns() {
        return this.visibleColumns;
    }

    public Column get(String id) {
        Column result = this.columnMap.get(id);
        if (result == null) {
            throw new IllegalArgumentException("Column not found: " + id);
        }
        return result;
    }

    public Column getByIndex(int index) {
        return this.columnList.get(index);
    }

    public int getIndex(String id) {
        return this.get(id).getIndex();
    }
}

