/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.report.action;

import java.sql.ResultSet;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.cache.UserCache;
import org.bgerp.plugin.kernel.Plugin;
import org.bgerp.plugin.report.action.ReportActionBase;
import org.bgerp.plugin.report.model.Column;
import org.bgerp.plugin.report.model.Columns;
import org.bgerp.plugin.report.model.Data;
import org.bgerp.plugin.report.model.Record;
import org.bgerp.plugin.report.model.chart.Chart;
import org.bgerp.plugin.report.model.chart.ChartBar;
import org.bgerp.plugin.report.model.chart.ChartPie;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/report/report/process")
public class ReportProcessAction
extends ReportActionBase {
    private static final Column COL_ID = new Column.ColumnInteger("id", "ID", null);
    private static final Column COL_TYPE_TITLE = new Column.ColumnString("type_title", null, "Type");
    private static final Column COL_EXECUTORS = new Column.ColumnString("executors", null, "Executors").withCommaSeparatedValues();
    private static final Columns COLUMNS = new Columns(COL_ID, COL_TYPE_TITLE, new Column.ColumnString("user_id", null, null), new Column.ColumnString("user_title", null, "User"), new Column.ColumnDateTime("time", null, "Time", "ymdhm"), new Column.ColumnString("process_description", null, "Description"), COL_EXECUTORS);
    private final List<Chart> CHARTS = List.of(new ChartBar("Quantities by process types", COL_TYPE_TITLE), new ChartPie("Quantities by process types", COL_TYPE_TITLE), new ChartBar("Quantities by executors", COL_EXECUTORS), new ChartPie("Quantities by executors", COL_EXECUTORS));

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return super.unspecified(form, conSet);
    }

    @Override
    public String getTitle() {
        return Plugin.INSTANCE.getLocalizer().l("\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u044b", new Object[0]);
    }

    @Override
    protected String getJsp() {
        return "/WEB-INF/jspf/user/plugin/report/report/process.jsp";
    }

    @Override
    protected String getHref() {
        return "report/process";
    }

    @Override
    public Columns getColumns() {
        return COLUMNS;
    }

    @Override
    public List<Chart> getCharts() {
        return this.CHARTS;
    }

    @Override
    protected ReportActionBase.Selector getSelector() {
        return new ReportActionBase.Selector(this){

            @Override
            protected void select(ConnectionSet conSet, Data data) throws Exception {
                DynActionForm form = data.getForm();
                Date dateFrom = form.getParamDate("dateFrom", new Date(), true);
                Date dateTo = form.getParamDate("dateTo", new Date(), true);
                String mode = form.getParam("mode", "create", true, null);
                if (!StringUtils.equalsAny((CharSequence)mode, (CharSequence[])new CharSequence[]{"create", "close"})) {
                    throw new BGIllegalArgumentException();
                }
                boolean isModeCreate = "create".equals(mode);
                Set<Integer> typeIds = form.getParamValues("type");
                try (PreparedQuery pq = new PreparedQuery(conSet.getSlaveConnection());){
                    pq.addQuery("SELECT SQL_CALC_FOUND_ROWS * FROM  process ");
                    pq.addQuery(" WHERE ");
                    pq.addQuery(mode + "_dt");
                    pq.addQuery(" BETWEEN ? AND ?");
                    pq.addDate(dateFrom);
                    pq.addDate(TimeUtils.getNextDay(dateTo));
                    if (!typeIds.isEmpty()) {
                        pq.addQuery(" AND type_id IN (" + Utils.toString(typeIds) + ")");
                    }
                    pq.addQuery(" ORDER BY ");
                    pq.addQuery(mode + "_dt");
                    pq.addQuery(this.getPageLimit(form.getPage()));
                    TreeSet<ProcessType> processTypes = new TreeSet<ProcessType>();
                    ResultSet rs = pq.executeQuery();
                    while (rs.next()) {
                        Record record = data.addRecord();
                        Process process = ProcessDAO.getProcessFromRs(rs);
                        record.add(process.getId());
                        ProcessType processType = process.getType();
                        record.add(processType.getTitle());
                        processTypes.add(processType);
                        int userId = isModeCreate ? process.getCreateUserId() : process.getCloseUserId();
                        record.add(userId);
                        record.add(UserCache.getUser(userId).getTitle());
                        record.add(isModeCreate ? process.getCreateTime() : process.getCloseTime());
                        record.add(process.getDescription());
                        record.add(Utils.getObjectTitles(UserCache.getUserList(), process.getExecutorIds()));
                    }
                    form.setResponseData("types", processTypes.stream().sorted((t1, t2) -> t1.getTitle().compareTo(t2.getTitle())).collect(Collectors.toList()));
                    this.setRecordCount(form.getPage(), pq.getPrepared());
                }
            }
        };
    }
}

