/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl.model;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.cache.UserCache;
import org.bgerp.plugin.pln.grpl.model.Row;
import org.bgerp.plugin.pln.grpl.model.ShiftConfig;
import org.bgerp.plugin.pln.grpl.model.Slot;
import org.bgerp.plugin.pln.grpl.model.SlotPlacement;
import org.bgerp.util.Dynamic;
import ru.bgcrm.model.user.Group;

public class Cell {
    private final Row row;
    private final int columnId;
    private final Group group;
    private final List<Slot> slots;

    public Cell(Row row, int columnId, Group group) {
        this.row = row;
        this.columnId = columnId;
        this.group = group;
        this.slots = new ArrayList<Slot>();
    }

    public Row getRow() {
        return this.row;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public Group getGroup() {
        return this.group;
    }

    @Dynamic
    public List<Group> getFreeGroups() {
        Set<Integer> excludedIds = this.row.excludeGroupIds();
        return this.row.getBoard().getGroupIds().stream().filter(id -> !excludedIds.contains(id)).map(id -> UserCache.getUserGroup(id)).collect(Collectors.toList());
    }

    public void addSlotPlacements() {
        ShiftConfig shift = this.row.getBoard().getShift();
        LocalTime time = shift.getFrom();
        LocalTime timeTo = shift.getTo();
        int firstIndexNoTime = -1;
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = this.slots.get(i);
            if (slot.getTime() == null) {
                timeTo = timeTo.minus(slot.getDuration());
                if (firstIndexNoTime >= 0) continue;
                firstIndexNoTime = i;
                continue;
            }
            if (time.isBefore(slot.getTime())) {
                this.slots.add(i++, new SlotPlacement(this, time, slot.getTime()));
            }
            time = slot.getTime().plus(slot.getDuration());
        }
        if (time.isBefore(timeTo)) {
            SlotPlacement placement = new SlotPlacement(this, time, timeTo);
            if (firstIndexNoTime < 0) {
                this.slots.add(placement);
            } else {
                this.slots.add(firstIndexNoTime, placement);
            }
        }
    }

    public List<Slot> getSlots() {
        return this.slots;
    }
}

