/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model.work;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bgerp.plugin.pln.callboard.cache.CallboardCache;
import org.bgerp.plugin.pln.callboard.model.WorkTask;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import org.bgerp.plugin.pln.callboard.model.WorkTypeTime;
import org.bgerp.plugin.pln.callboard.model.config.CallboardPlanConfig;
import org.bgerp.plugin.pln.callboard.model.work.CellRange;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;

public class ShiftData {
    private static final Log log = Log.getLog();
    public int team;
    public int shiftId;
    public Set<Integer> userIds;
    public List<WorkTypeTime> workTypeTimeList;
    private List<WorkTask> taskList;

    public int getTeam() {
        return this.team;
    }

    public int getShiftId() {
        return this.shiftId;
    }

    @Dynamic
    public Set<Integer> getUserIds() {
        return this.userIds;
    }

    public List<WorkTypeTime> getWorkTypeTimeList() {
        return this.workTypeTimeList;
    }

    public List<WorkTask> getTaskList() {
        return this.taskList;
    }

    public void addTask(WorkTask task) {
        if (this.taskList == null) {
            this.taskList = new ArrayList<WorkTask>();
        }
        this.taskList.add(task);
    }

    public List<CellRange> getCellRanges(CallboardPlanConfig planConfig) {
        ArrayList<CellRange> result = new ArrayList<CellRange>();
        CellRange currentRange = null;
        Iterator<WorkTypeTime> iterator = this.workTypeTimeList.iterator();
        WorkTypeTime currentWtt = null;
        int timeTo = planConfig.getDayMinuteTo();
        for (int currentTime = planConfig.getDayMinuteFrom(); currentTime < timeTo; currentTime += planConfig.getDayMinuteStep()) {
            if (currentWtt == null || currentWtt.getDayMinuteTo() <= currentTime) {
                WorkTypeTime workTypeTime = currentWtt = iterator.hasNext() ? iterator.next() : null;
            }
            if (currentWtt == null || currentTime < currentWtt.getDayMinuteFrom()) {
                if (currentRange == null || currentRange.workTypeTime != null) {
                    currentRange = new CellRange(null, null, 1);
                    result.add(currentRange);
                    continue;
                }
                ++currentRange.cells;
                continue;
            }
            if (currentRange == null || currentRange.workTypeTime != currentWtt) {
                WorkType workType = null;
                if (currentWtt != null) {
                    workType = CallboardCache.getWorkType(currentWtt.getWorkTypeId());
                }
                currentRange = new CellRange(workType, currentWtt, 1);
                result.add(currentRange);
                continue;
            }
            ++currentRange.cells;
        }
        if (this.taskList != null) {
            for (WorkTask task : this.taskList) {
                int minuteFrom = task.getMinuteFrom();
                for (CellRange range : result) {
                    if (range.workTypeTime == null) continue;
                    int workTypeId = range.workTypeTime.getWorkTypeId();
                    WorkType workType = CallboardCache.getWorkType(workTypeId);
                    if (workType == null) {
                        log.warn("Not found WorkType with id: {}", workTypeId);
                        continue;
                    }
                    if (range.workTypeTime.getDayMinuteFrom() > minuteFrom || minuteFrom >= range.workTypeTime.getDayMinuteTo()) continue;
                    range.taskList.add(task);
                    task.setSlotTo(task.getSlotFrom() + task.getDuration() / workType.getTimeSetStep());
                }
            }
        }
        return result;
    }
}

