/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.callboard.model.DayType;
import org.bgerp.plugin.pln.callboard.model.WorkDaysCalendarRule;
import org.bgerp.plugin.pln.callboard.model.config.DayTypeConfig;
import ru.bgcrm.model.Pair;
import ru.bgcrm.util.TimeUtils;

public class WorkDaysCalendar
extends IdTitle {
    private String comment = "";
    private List<WorkDaysCalendarRule> rules = new ArrayList<WorkDaysCalendarRule>();

    public WorkDaysCalendar() {
    }

    public WorkDaysCalendar(int id, String title, String comment, List<WorkDaysCalendarRule> rules) {
        super(id, title);
        this.comment = comment;
        this.rules = rules;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Pair<DayType, Boolean> getDayType(Date date, Map<Date, Integer> excludeDates) {
        DayTypeConfig config = Setup.getSetup().getConfig(DayTypeConfig.class);
        Integer result = null;
        if (excludeDates != null && (result = excludeDates.get(date)) != null) {
            return new Pair<DayType, Boolean>(config.getType(result), true);
        }
        int dayOfWeek = TimeUtils.getDayOfWeekPosition(date);
        for (WorkDaysCalendarRule rule : this.rules) {
            if (rule.getDay() != dayOfWeek) continue;
            result = rule.getType();
            break;
        }
        if (result != null) {
            return new Pair<DayType, Boolean>(config.getType(result), false);
        }
        return null;
    }
}

