/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class WorkTypeDAO
extends CommonDAO {
    public WorkTypeDAO(Connection con) {
        super(con);
    }

    public void searchWorkType(Pageable<WorkType> searchResult, int category) {
        if (searchResult != null) {
            try {
                Page page = searchResult.getPage();
                List<WorkType> list = searchResult.getList();
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS ");
                query.append("*");
                query.append(" FROM ");
                query.append(" callboard_work_type ");
                query.append(" t ");
                query.append(" WHERE ");
                query.append(" category=" + category + " ");
                query.append(" ORDER BY ");
                query.append("t.id");
                query.append(this.getPageLimit(page));
                ps = this.con.prepareStatement(query.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(WorkTypeDAO.getWorkTypeFromRs(rs));
                }
                page.setRecordCount(this.foundRows(ps));
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public List<WorkType> getWorkTypeList() {
        return this.getWorkTypeList(null);
    }

    public List<WorkType> getWorkTypeList(Set<?> workTypeIds) {
        ArrayList<WorkType> result = new ArrayList<WorkType>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append("*");
            query.append(" FROM ");
            query.append(" callboard_work_type ");
            query.append(" t ");
            if (workTypeIds != null && workTypeIds.size() > 0) {
                query.append(" WHERE id IN ( " + Utils.toString(workTypeIds, "", ",") + " ) ");
            }
            query.append(" ORDER BY ");
            query.append("t.id");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(WorkTypeDAO.getWorkTypeFromRs(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Map<Integer, WorkType> getWorkTypeMap() {
        return this.getWorkTypeMap(false);
    }

    public Map<Integer, WorkType> getWorkTypeMap(boolean dynamicOnly) {
        HashMap<Integer, WorkType> result = new HashMap<Integer, WorkType>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append("*");
            query.append(" FROM ");
            query.append(" callboard_work_type ");
            query.append(" t ");
            if (dynamicOnly) {
                query.append(" WHERE d.id IS NOT NULL ");
            }
            query.append(" ORDER BY ");
            query.append("t.id");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                WorkType workType = WorkTypeDAO.getWorkTypeFromRs(rs);
                result.put(workType.getId(), workType);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void updateWorkType(WorkType workType) {
        int index = 1;
        PreparedStatement ps = null;
        try {
            if (workType.getId() > 0) {
                String query = " UPDATE  callboard_work_type  SET category=?, title=?, comment=?, config=?, non_work_hours=?, rule_config=? WHERE id=? ";
                ps = this.con.prepareStatement(query);
                ps.setInt(index++, workType.getCategory());
                ps.setString(index++, workType.getTitle());
                ps.setString(index++, workType.getComment());
                ps.setString(index++, workType.getConfig());
                ps.setBoolean(index++, workType.isNonWorkHours());
                ps.setString(index++, workType.getRuleConfig());
                ps.setInt(index++, workType.getId());
                ps.executeUpdate();
            } else {
                String query = " INSERT INTO  callboard_work_type  SET category=?, title=?, comment=?, config=?, non_work_hours=?, rule_config=? ";
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, workType.getCategory());
                ps.setString(index++, workType.getTitle());
                ps.setString(index++, workType.getComment());
                ps.setString(index++, workType.getConfig());
                ps.setBoolean(index++, workType.isNonWorkHours());
                ps.setString(index++, workType.getRuleConfig());
                ps.executeUpdate();
                workType.setId(this.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public WorkType getWorkType(int id) {
        WorkType result = null;
        try {
            String query = "SELECT * FROM  callboard_work_type  t WHERE t.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = WorkTypeDAO.getWorkTypeFromRs(rs);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void deleteWorkType(int id) {
        try {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append(" callboard_work_type ");
            query.append(" WHERE ");
            query.append("id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateWorkDaysCalendar(int calendarId, int type, Date date) {
        PreparedStatement ps = null;
        try {
            ps = this.con.prepareStatement("DELETE FROM callboard_workdays_calendar WHERE id=? AND date=?");
            ps.setInt(1, calendarId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
            ps.executeUpdate();
            ps.close();
            if (type > 0) {
                ps = this.con.prepareStatement("INSERT INTO callboard_workdays_calendar SET id=?, date=?, type=?");
                ps.setInt(1, calendarId);
                ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
                ps.setInt(3, type);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void copyWorkDaysCalendar(int calendarId, int from, int to) {
        PreparedStatement ps = null;
        try {
            ps = this.con.prepareStatement("DELETE FROM callboard_workdays_calendar WHERE id=" + calendarId + " AND date BETWEEN '" + to + "-01-01' AND '" + to + "-12-31'; ");
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("INSERT INTO callboard_workdays_calendar SELECT id, DATE_SUB( date, INTERVAL (YEAR(date)-" + to + ") YEAR ), type from callboard_workdays_calendar WHERE id=" + calendarId + " and YEAR(date)=" + from);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public Map<Date, Integer> getWorkDaysCalendarExcludes(int calendarId) {
        HashMap<Date, Integer> resultSet = new HashMap<Date, Integer>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("SELECT date, type FROM callboard_workdays_calendar WHERE id=?");
            ps.setInt(1, calendarId);
            rs = ps.executeQuery();
            while (rs.next()) {
                resultSet.put(rs.getDate(1), rs.getInt(2));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return resultSet;
    }

    private static WorkType getWorkTypeFromRs(ResultSet rs) {
        WorkType result = new WorkType();
        try {
            result.setId(rs.getInt("id"));
            result.setTitle(rs.getString("title"));
            result.setCategory(rs.getInt("category"));
            result.setComment(rs.getString("comment"));
            result.setConfigMap(new Preferences(rs.getString("config")));
            result.setNonWorkHours(rs.getBoolean("non_work_hours"));
            result.setRuleConfig(rs.getString("rule_config"));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }
}

