/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.dao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.UserCache;
import org.bgerp.model.Pageable;
import org.bgerp.plugin.pln.callboard.model.CallboardTask;
import org.bgerp.plugin.pln.callboard.model.Shift;
import org.bgerp.plugin.pln.callboard.model.WorkShift;
import org.bgerp.plugin.pln.callboard.model.WorkTypeTime;
import org.bgerp.plugin.pln.callboard.model.config.CallboardConfig;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.user.UserGroup;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ShiftDAO
extends CommonDAO {
    private static Comparator<WorkTypeTime> workShiftComparator = new Comparator<WorkTypeTime>(){

        @Override
        public int compare(WorkTypeTime w1, WorkTypeTime w2) {
            return w1.getWorkTypeId() - w2.getWorkTypeId();
        }
    };

    public ShiftDAO(Connection con) {
        super(con);
    }

    public void searchShift(Pageable<Shift> searchResult, int category) {
        if (searchResult != null) {
            try {
                Page page = searchResult.getPage();
                List<Shift> list = searchResult.getList();
                ResultSet rs = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("SELECT SQL_CALC_FOUND_ROWS ");
                query.append("*");
                query.append(" FROM ");
                query.append(" callboard_shift ");
                query.append(" WHERE ");
                query.append(" category=" + category + " ");
                query.append(" ORDER BY ");
                query.append("id");
                query.append(this.getPageLimit(page));
                ps = this.con.prepareStatement(query.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(ShiftDAO.getShiftFromRs(rs));
                }
                page.setRecordCount(this.foundRows(ps));
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public List<Shift> getShiftList(int category) {
        ArrayList<Shift> list = new ArrayList<Shift>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append("*");
            query.append(" FROM ");
            query.append(" callboard_shift ");
            query.append(" WHERE ");
            query.append(" category=" + category + " ");
            query.append(" ORDER BY ");
            query.append("id");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(ShiftDAO.getShiftFromRs(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return list;
    }

    public List<Shift> getShiftList(Set<Integer> shiftIds) {
        ArrayList<Shift> list = new ArrayList<Shift>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append("*");
            query.append(" FROM ");
            query.append(" callboard_shift ");
            query.append(" WHERE ");
            query.append(" id IN ( " + Utils.toString(shiftIds) + " ) ");
            query.append(" ORDER BY ");
            query.append("id");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(ShiftDAO.getShiftFromRs(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return list;
    }

    public Map<Integer, Shift> getAllShiftMap() {
        HashMap<Integer, Shift> result = new HashMap<Integer, Shift>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append("*");
            query.append(" FROM ");
            query.append(" callboard_shift ");
            query.append(" ORDER BY ");
            query.append("id");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                Shift shift = ShiftDAO.getShiftFromRs(rs);
                result.put(shift.getId(), shift);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public static Shift getShiftFromRs(ResultSet rs) {
        Shift result = new Shift();
        try {
            result.setId(rs.getInt("id"));
            result.setCategory(rs.getInt("category"));
            result.setTitle(rs.getString("title"));
            result.setComment(rs.getString("comment"));
            result.setColor(rs.getString("color"));
            result.setUseOwnColor(rs.getBoolean("use_own_color"));
            result.setWorkTypeTimeList(WorkTypeTime.createFromString(rs.getString("config")));
            result.setSymbol(rs.getString("symbol"));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Shift getShift(int id, int category) {
        Shift result = null;
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("SELECT * FROM  callboard_shift  WHERE id=? " + (String)(category > 0 ? "AND category=" + category : ""));
            ps.setInt(1, id);
            rs = ps.executeQuery();
            while (rs.next()) {
                result = ShiftDAO.getShiftFromRs(rs);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Shift getShift(int id) {
        return this.getShift(id, 0);
    }

    public void deleteShift(int id) {
        try {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append(" callboard_shift ");
            query.append(" WHERE ");
            query.append("id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateShift(Shift shift) {
        int index = 1;
        PreparedStatement ps = null;
        try {
            if (shift.getId() > 0) {
                String query = " UPDATE  callboard_shift  SET category=?, title=?, comment=?, config=?, color=?, use_own_color=?, symbol=? WHERE id=? ";
                ps = this.con.prepareStatement(query);
                ps.setInt(index++, shift.getCategory());
                ps.setString(index++, shift.getTitle());
                ps.setString(index++, shift.getComment());
                ps.setString(index++, shift.serializeToData());
                ps.setString(index++, shift.getColor());
                ps.setBoolean(index++, shift.isUseOwnColor());
                ps.setString(index++, shift.getSymbol());
                ps.setInt(index++, shift.getId());
                ps.executeUpdate();
            } else {
                String query = " INSERT INTO  callboard_shift  SET category=?, title=?, comment=?, config=?, color=?, use_own_color=?, symbol=? ";
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, shift.getCategory());
                ps.setString(index++, shift.getTitle());
                ps.setString(index++, shift.getComment());
                ps.setString(index++, shift.serializeToData());
                ps.setString(index++, shift.getColor());
                ps.setBoolean(index++, shift.isUseOwnColor());
                ps.setString(index++, shift.getSymbol());
                ps.executeUpdate();
                shift.setId(this.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public WorkShift getWorkShift(int graphId, int groupId, int userId, java.util.Date date) {
        WorkShift resultWorkShift = new WorkShift();
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  callboard_shift_user  WHERE graph=? and `group`=? and user=? and date=?");
            ps.setInt(1, graphId);
            ps.setInt(2, groupId);
            ps.setInt(3, userId);
            ps.setDate(4, TimeUtils.convertDateToSqlDate(date));
            rs = ps.executeQuery();
            if (rs.first()) {
                resultWorkShift = this.getWorkShiftFromRs(rs);
                ArrayList<WorkTypeTime> workTypeTimeList = new ArrayList<WorkTypeTime>();
                do {
                    workTypeTimeList.add(new WorkTypeTime(false, rs.getInt("work_type"), rs.getInt("time_from"), rs.getInt("time_to"), ""));
                } while (rs.next());
                resultWorkShift.setWorkTypeTimeList(workTypeTimeList);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return resultWorkShift;
    }

    public Map<Integer, List<WorkShift>> getWorkShift(CallboardConfig.Callboard callboard, java.util.Date fromDate, java.util.Date toDate, Map<Integer, List<Integer>> groupWithUsersSet) {
        LinkedHashMap<Integer, List<WorkShift>> resultMap = new LinkedHashMap<Integer, List<WorkShift>>();
        try {
            int graphId = callboard.getId();
            HashMap<Key, ArrayList<WorkShift>> workShiftData = new HashMap<Key, ArrayList<WorkShift>>();
            String query = "UPDATE  callboard_shift_user SET `group`=0 WHERE graph=? AND date BETWEEN DATE_SUB(?, INTERVAL 1 DAY) AND ? AND `group`=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, graphId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(fromDate));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(toDate));
            ps.setInt(4, callboard.getGroupId());
            ps.executeUpdate();
            ps.close();
            this.con.commit();
            query = "SELECT * FROM  callboard_shift_user WHERE graph=? AND date BETWEEN DATE_SUB(?, INTERVAL 1 DAY) AND ? ORDER BY time_from, time_to";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, graphId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(fromDate));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(toDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkShift shift = this.getWorkShiftFromRs(rs);
                Key key = new Key(shift.getGroupId(), shift.getUserId());
                ArrayList<WorkShift> shiftList = (ArrayList<WorkShift>)workShiftData.get(key);
                if (shiftList == null) {
                    shiftList = new ArrayList<WorkShift>();
                    workShiftData.put(key, shiftList);
                }
                shiftList.add(shift);
            }
            ps.close();
            for (Map.Entry<Integer, List<Integer>> entry : groupWithUsersSet.entrySet()) {
                ArrayList workShiftList = new ArrayList();
                for (Integer user : entry.getValue()) {
                    Key key = new Key(entry.getKey(), user);
                    List shiftList = (List)workShiftData.get(key);
                    if (shiftList == null) continue;
                    HashMap<java.util.Date, WorkShift> dateWorkShift = new HashMap<java.util.Date, WorkShift>();
                    for (WorkShift workShift : shiftList) {
                        if (dateWorkShift.containsKey(workShift.getDate())) {
                            ((WorkShift)dateWorkShift.get(workShift.getDate())).getWorkTypeTimeList().add(workShift.getWorkTypeTimeList().get(0));
                            continue;
                        }
                        dateWorkShift.put(workShift.getDate(), workShift);
                    }
                    for (WorkShift workShift : dateWorkShift.values()) {
                        if (this.checkWorkShiftTimeOrder(workShift.getWorkTypeTimeList())) continue;
                        Collections.sort(workShift.getWorkTypeTimeList(), workShiftComparator);
                    }
                    workShiftList.addAll(dateWorkShift.values());
                }
                resultMap.put(entry.getKey(), workShiftList);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return resultMap;
    }

    public Map<Integer, Map<Integer, Set<java.util.Date>>> getAvailableDateForShift(CallboardConfig.Callboard callboard, Map<Integer, List<Integer>> groupWithUsersMap, java.util.Date fromDate, java.util.Date toDate) {
        HashMap<Integer, Map<Integer, Set<java.util.Date>>> result = new HashMap<Integer, Map<Integer, Set<java.util.Date>>>();
        Calendar calTo = TimeUtils.convertDateToCalendar(toDate);
        for (Map.Entry<Integer, List<Integer>> groupUsers : groupWithUsersMap.entrySet()) {
            int groupId = groupUsers.getKey();
            if (groupId == 0) {
                groupId = callboard.getGroupId();
            }
            HashMap groupUserDates = new HashMap();
            result.put(groupId, groupUserDates);
            for (Integer userId : groupUsers.getValue()) {
                HashSet<java.util.Date> userDates = new HashSet<java.util.Date>();
                groupUserDates.put(userId, userDates);
                List<UserGroup> userGroups = UserCache.getUserGroupList(userId);
                if (userGroups.size() <= 0) continue;
                Calendar cal = TimeUtils.convertDateToCalendar(fromDate);
                while (TimeUtils.dateBeforeOrEq(cal, calTo)) {
                    for (UserGroup userGroup : userGroups) {
                        if (userGroup.getGroupId() != groupId || !TimeUtils.dateInRange(cal, TimeUtils.convertDateToCalendar(userGroup.getDateFrom()), TimeUtils.convertDateToCalendar(userGroup.getDateTo()))) continue;
                        userDates.add(TimeUtils.convertCalendarToDate(cal));
                        break;
                    }
                    cal.add(6, 1);
                }
            }
        }
        return result;
    }

    public Map<Integer, Map<java.util.Date, WorkShift>> getUserShifts(int graphId, java.util.Date fromDate, java.util.Date toDate) {
        HashMap<Integer, Map<java.util.Date, WorkShift>> result = new HashMap<Integer, Map<java.util.Date, WorkShift>>();
        try {
            String query = "SELECT * FROM  callboard_shift_user WHERE graph=? AND date BETWEEN DATE_SUB(?, INTERVAL 1 DAY) AND ? ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, graphId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(fromDate));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(toDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                WorkShift existWorkShift;
                WorkShift workShift = this.getWorkShiftFromRs(rs);
                HashMap<java.util.Date, WorkShift> dayUserShift = (HashMap<java.util.Date, WorkShift>)result.get(workShift.getUserId());
                if (dayUserShift == null) {
                    dayUserShift = new HashMap<java.util.Date, WorkShift>();
                    result.put(workShift.getUserId(), dayUserShift);
                }
                if ((existWorkShift = (WorkShift)dayUserShift.get(workShift.getDate())) != null) {
                    existWorkShift.getWorkTypeTimeList().add(workShift.getWorkTypeTimeList().get(0));
                    continue;
                }
                dayUserShift.put(workShift.getDate(), workShift);
            }
            ps.close();
            for (Map map : result.values()) {
                for (WorkShift workShift : map.values()) {
                    WorkTypeTime.setNextDays(workShift.getWorkTypeTimeList());
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Set<WorkShift> getWorkShiftSetFor(java.util.Date date, int userId) {
        HashSet<WorkShift> result = new HashSet<WorkShift>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  callboard_shift_user  WHERE user=? AND date=? AND shift <> 0");
            ps.setInt(1, userId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getWorkShiftFromRs(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Map<java.util.Date, Set<WorkShift>> getMonthWorkShift(java.util.Date date, int groupId) {
        LinkedHashMap<java.util.Date, Set<WorkShift>> resultMap = new LinkedHashMap<java.util.Date, Set<WorkShift>>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  callboard_shift_user  WHERE team <> 0 AND `group`=? AND date BETWEEN ? AND ?");
            ps.setInt(1, groupId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(calendar.getTime()));
            calendar.add(2, 1);
            ps.setDate(3, TimeUtils.convertDateToSqlDate(calendar.getTime()));
            rs = ps.executeQuery();
            while (rs.next()) {
                WorkShift workShift = this.getWorkShiftFromRs(rs);
                if (resultMap.containsKey(workShift.getDate())) {
                    ((Set)resultMap.get(workShift.getDate())).add(workShift);
                    continue;
                }
                LinkedHashSet<WorkShift> workShiftSet = new LinkedHashSet<WorkShift>();
                workShiftSet.add(workShift);
                resultMap.put(workShift.getDate(), workShiftSet);
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return resultMap;
    }

    private WorkShift getWorkShiftFromRs(ResultSet rs) {
        WorkShift result = new WorkShift();
        try {
            result.setId(rs.getInt("id"));
            result.setUserId(rs.getInt("user"));
            result.setGraphId(rs.getInt("graph"));
            result.setGroupId(rs.getInt("group"));
            result.setDate(rs.getDate("date"));
            result.setTeam(rs.getInt("team"));
            result.setShiftId(rs.getInt("shift"));
            ArrayList<WorkTypeTime> workTypeTimeList = new ArrayList<WorkTypeTime>();
            workTypeTimeList.add(new WorkTypeTime(rs.getBoolean("is_dynamic"), rs.getInt("work_type"), rs.getInt("time_from"), rs.getInt("time_to"), rs.getString("comment")));
            result.setWorkTypeTimeList(workTypeTimeList);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void updateWorkShift(WorkShift workShift) {
        PreparedStatement ps = null;
        try {
            String query = " INSERT INTO  callboard_shift_user  ( user, graph, `group`, date, team, shift, work_type, time_from, time_to, is_dynamic, comment ) VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
            ps = this.con.prepareStatement(query.toString(), 1);
            for (WorkTypeTime workTypeTime : workShift.getWorkTypeTimeList()) {
                int index = 1;
                ps.setInt(index++, workShift.getUserId());
                ps.setInt(index++, workShift.getGraphId());
                ps.setInt(index++, workShift.getGroupId());
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(workShift.getDate()));
                ps.setInt(index++, workShift.getTeam());
                ps.setInt(index++, workShift.getShiftId());
                ps.setInt(index++, workTypeTime.getWorkTypeId());
                ps.setInt(index++, workTypeTime.getDayMinuteFrom());
                ps.setInt(index++, workTypeTime.getDayMinuteTo());
                ps.setBoolean(index++, workTypeTime.isDynamic());
                ps.setString(index++, workTypeTime.getComment() == null ? "" : workTypeTime.getComment());
                ps.executeUpdate();
            }
            workShift.setId(this.lastInsertId(ps));
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteWorkShift(int graphId, int groupId, int userId, java.util.Date date) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM  callboard_shift_user  WHERE graph=? AND `group`=? AND user=? AND date=? ");
            ps.setInt(1, graphId);
            ps.setInt(2, groupId);
            ps.setInt(3, userId);
            ps.setDate(4, TimeUtils.convertDateToSqlDate(date));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void addCallboardTask(int process_id, int group, int team, int graph, java.util.Date date) {
        PreparedStatement ps = null;
        try {
            String query = " INSERT INTO  callboard_task  (`group`, team, date, graph, process_id) VALUES( ?, ?, ?, ?, ? )";
            ps = this.con.prepareStatement(query.toString(), 1);
            ps.setInt(1, group);
            ps.setInt(2, team);
            ps.setTimestamp(3, TimeConvert.toTimestamp(date));
            ps.setInt(4, graph);
            ps.setInt(5, process_id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteCallboardTask(int process_id, int group, int team, int graph, java.util.Date date) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM  callboard_task  WHERE process_id=? `group`=? AND team=? AND date=? AND graph=? ");
            ps.setInt(1, process_id);
            ps.setInt(2, group);
            ps.setInt(3, team);
            ps.setDate(4, TimeUtils.convertDateToSqlDate(date));
            ps.setInt(5, graph);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteCallboardTask(int process_id) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM  callboard_task  WHERE process_id=? ");
            ps.setInt(1, process_id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public boolean isTimeOccupied(int group, int team, int graph, java.util.Date date) {
        boolean result = false;
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  callboard_task  WHERE `group`=? AND date=? AND team=? AND graph=?");
            ps.setInt(1, group);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
            ps.setInt(3, team);
            ps.setInt(4, graph);
            rs = ps.executeQuery();
            if (rs.first()) {
                result = true;
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<CallboardTask> getDateTaskList(java.util.Date date) {
        ArrayList<CallboardTask> result = new ArrayList<CallboardTask>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  callboard_task  WHERE date BETWEEN ? AND ?");
            ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp(calendar));
            calendar.add(5, 1);
            ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp(calendar));
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new CallboardTask(rs.getInt("process_id"), rs.getInt("group"), rs.getInt("team"), rs.getInt("graph"), rs.getTimestamp("date")));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<WorkShift> findSameWorkShift(WorkShift workShift) {
        ArrayList<WorkShift> resultList = new ArrayList<WorkShift>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT DISTINCT(user) FROM  callboard_shift_user  WHERE graph=? and `group`=? and team=? and date=? and user<>?");
            ps.setInt(1, workShift.getGraphId());
            ps.setInt(2, workShift.getGroupId());
            ps.setInt(3, workShift.getTeam());
            ps.setDate(4, TimeUtils.convertDateToSqlDate(workShift.getDate()));
            ps.setInt(5, workShift.getUserId());
            rs = ps.executeQuery();
            if (rs.next()) {
                WorkShift sameWorkShift = workShift;
                sameWorkShift.setUserId(rs.getInt("user"));
                resultList.add(sameWorkShift);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return resultList;
    }

    public void updateShiftOrder(int graphId, int groupId, Map<Integer, Integer> orderMap) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM  callboard_shift_order  WHERE graph_id=? AND group_id=? ");
            ps.setInt(1, graphId);
            ps.setInt(2, groupId);
            ps.executeUpdate();
            ps.close();
            String query = " INSERT INTO  callboard_shift_order  ( graph_id, group_id, user_id, `order` ) VALUES( ?, ?, ?, ? )";
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, graphId);
            ps.setInt(2, groupId);
            for (Map.Entry<Integer, Integer> entry : orderMap.entrySet()) {
                ps.setInt(3, entry.getKey());
                ps.setInt(4, entry.getValue());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public Map<Integer, Integer> getShiftOrder(int graphId, int groupId) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM  callboard_shift_order  WHERE graph_id=? AND group_id=? ");
            ps.setInt(1, graphId);
            ps.setInt(2, groupId);
            rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getInt("user_id"), rs.getInt("order"));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void setDynamicShiftTime(int workShiftId, int timeBegin, int timeEnd) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE  callboard_shift_user  SET is_dynamic=0, time_from=?, time_to=? WHERE id=? AND is_dynamic=1  ");
            ps.setInt(1, timeBegin);
            ps.setInt(2, timeEnd);
            ps.setInt(3, workShiftId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public int getSameWorkTypeShiftCount(int workTypeId, int workShiftId, int time_from, int time_to) {
        int result = 0;
        try {
            PreparedStatement ps1 = this.con.prepareStatement("SELECT date FROM  callboard_shift_user  WHERE id=" + workShiftId);
            ResultSet rs = ps1.executeQuery();
            if (rs.next()) {
                Date date = rs.getDate("date");
                PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(*) as cnt FROM  callboard_shift_user  WHERE is_dynamic=0 AND work_type=? AND date=? AND time_from=? AND time_to=? ");
                ps.setInt(1, workTypeId);
                ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
                ps.setInt(3, time_from);
                ps.setInt(4, time_to);
                rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getInt("cnt");
                }
                ps.close();
            }
            ps1.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    private boolean checkWorkShiftTimeOrder(List<WorkTypeTime> workShiftList) {
        HashSet<Integer> beginTimeSet = new HashSet<Integer>();
        HashSet<Integer> endTimeSet = new HashSet<Integer>();
        HashSet copyTimeSet = new HashSet();
        for (WorkTypeTime workTypeTime : workShiftList) {
            beginTimeSet.add(workTypeTime.getDayMinuteFrom());
            endTimeSet.add(workTypeTime.getDayMinuteTo());
        }
        copyTimeSet = new HashSet(beginTimeSet);
        beginTimeSet.removeAll(endTimeSet);
        endTimeSet.removeAll(copyTimeSet);
        if (beginTimeSet.size() == 1 && endTimeSet.size() == 1) {
            int count = 0;
            int lastTime = (Integer)new ArrayList(beginTimeSet).get(0);
            ArrayList<WorkTypeTime> sortedShiftList = new ArrayList<WorkTypeTime>();
            while (sortedShiftList.size() < workShiftList.size()) {
                for (WorkTypeTime workTypeTime : workShiftList) {
                    if (workTypeTime.getDayMinuteFrom() != lastTime) continue;
                    sortedShiftList.add(workTypeTime);
                    lastTime = workTypeTime.getDayMinuteTo();
                    break;
                }
                if (count > workShiftList.size()) break;
                ++count;
            }
            if (sortedShiftList.size() == workShiftList.size()) {
                workShiftList.clear();
                workShiftList.addAll(sortedShiftList);
                return true;
            }
        }
        return false;
    }

    private static class Key {
        private int group;
        private int userId;

        private Key(int group, int userId) {
            this.group = group;
            this.userId = userId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.group;
            result = 31 * result + this.userId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.group != other.group) {
                return false;
            }
            return this.userId == other.userId;
        }
    }
}

