/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.blow.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.blow.model.Item;
import org.bgerp.plugin.pln.blow.model.ItemComparator;
import ru.bgcrm.dao.expression.Expression;
import ru.bgcrm.dao.expression.ProcessExpressionObject;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.servlet.filter.SetRequestParamsFilter;
import ru.bgcrm.util.Utils;

public class BoardConfig
extends IdTitle {
    private final int queueId;
    private final String cellExpression;
    private final String openUrl;
    private final List<BoardFilter> filters = new ArrayList<BoardFilter>();
    private final List<ItemComparator> comparators;
    private final Set<Integer> executorGroupIds;
    private final Set<Integer> executorRoleIds;

    BoardConfig(int id, ConfigMap config) throws BGMessageException {
        super(id, config.get("title"));
        this.queueId = config.getInt("queueId");
        this.cellExpression = config.getSok("process.getDescription()", false, "expressionCell", "stringExpressionCell");
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("filter.").entrySet()) {
            this.filters.add(new BoardFilter((int)me.getKey(), me.getValue()));
        }
        this.openUrl = config.get("openUrl");
        this.comparators = this.parseComparators(config.get("sort", Utils.toString(List.of("priority", "has_executor", "status_pos", "has_children"))));
        this.executorGroupIds = Utils.toIntegerSet(config.getSok("executor.groups", "executor.groupIds"));
        this.executorRoleIds = Utils.toIntegerSet(config.get("executor.roles", "0"));
    }

    private List<ItemComparator> parseComparators(String config) {
        ArrayList<ItemComparator> result = new ArrayList<ItemComparator>();
        for (String pair : Utils.toList(config, ";,")) {
            String[] tokens = pair.split(":");
            result.add(new ItemComparator(tokens[0], tokens.length > 1 ? tokens[1] : null));
        }
        return Collections.unmodifiableList(result);
    }

    public Queue getQueue() {
        return ProcessQueueCache.getQueue(this.queueId);
    }

    public String getOpenUrl() {
        return this.openUrl;
    }

    public List<Pair<BoardFilter, String>> getFilterValues(Iterable<Item> items) {
        ArrayList<Pair<BoardFilter, String>> result = new ArrayList<Pair<BoardFilter, String>>(this.filters.size());
        for (BoardFilter filter : this.filters) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("items", items);
            context.put("filter", filter);
            context.putAll(SetRequestParamsFilter.getContextVariables(null));
            String text = new Expression(context).executeGetString(filter.getStringExpression());
            result.add(new Pair<BoardFilter, String>(filter, text));
        }
        return result;
    }

    public String getCellContent(Item item) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        new ProcessExpressionObject(item.getProcess()).toContext(context);
        context.put("params", item.getParams());
        context.putAll(SetRequestParamsFilter.getContextVariables(null));
        return new Expression(context).executeGetString(this.cellExpression);
    }

    public Set<Integer> getExecutorGroupIds() {
        return this.executorGroupIds;
    }

    public Set<Integer> getExecutorRoleIds() {
        return this.executorRoleIds;
    }

    public Comparator<Item> getItemComparator() {
        return (o1, o2) -> {
            for (ItemComparator c : this.comparators) {
                int result = c.compare((Item)o1, (Item)o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public static class BoardFilter
    extends IdTitle {
        private final String stringExpression;
        private final String color;

        private BoardFilter(int id, ConfigMap config) {
            super(id, config.get("title", "NONAME"));
            this.stringExpression = config.getSok("expression", "stringExpression");
            this.color = config.get("color");
        }

        public String getColor() {
            return this.color;
        }

        public String getStringExpression() {
            return this.stringExpression;
        }
    }
}

