/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.message;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.model.msg.Message;
import org.bgerp.plugin.msg.email.MessageParser;
import org.bgerp.plugin.msg.email.message.MessageTypeEmail;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

class FolderCache {
    private static final Log log = Log.getLog();
    private static final FetchProfile FETCH_PROFILE_SIZE = new FetchProfile();
    private static final FetchProfile FETCH_PROFILE_LIST;
    private static final String SYSTEM_ID_PREFIX = "index";
    private static final long MAX_CACHE_VALID_TIMEOUT_MS;
    private final MessageTypeEmail type;
    private long lastListTimeMs;
    private List<Item> data;

    FolderCache(MessageTypeEmail type) {
        this.type = type;
    }

    public synchronized List<Message> list(Folder folder) throws Exception {
        if (this.data == null || !this.isListActual(folder) || System.currentTimeMillis() - this.lastListTimeMs > MAX_CACHE_VALID_TIMEOUT_MS) {
            this.relist(folder);
        }
        return this.data.stream().map(item -> item.message).collect(Collectors.toList());
    }

    private boolean isListActual(Folder folder) throws MessagingException {
        javax.mail.Message[] messages = folder.getMessages();
        folder.fetch(messages, FETCH_PROFILE_SIZE);
        ArrayList<Integer> sizes = new ArrayList<Integer>(messages.length);
        for (javax.mail.Message m : messages) {
            sizes.add(m.getSize());
        }
        List dataSizes = this.data.stream().map(item -> item.size).collect(Collectors.toList());
        return dataSizes.equals(sizes);
    }

    public synchronized void relist(Folder folder) throws Exception {
        log.debug("relist", new Object[0]);
        javax.mail.Message[] messages = folder.getMessages();
        folder.fetch(messages, FETCH_PROFILE_LIST);
        this.data = new ArrayList<Item>(messages.length);
        for (int i = 0; i < messages.length; ++i) {
            MessageParser mp = new MessageParser(messages[i]);
            Message m = new Message().withTypeId(this.type.getId()).withSystemId(SYSTEM_ID_PREFIX + i).withSubject(mp.getMessageSubject()).withFromTime(mp.getFromTime()).withFrom(mp.getFrom());
            this.data.add(new Item(i, messages[i].getSize(), m));
            if (i >= 20) continue;
            log.debug("Message subject: {}, from: {}, fromTime: {}", m.getSubject(), m.getFrom(), m.getFromTime());
        }
        log.debug("relist, size: {}", this.data.size());
        this.lastListTimeMs = System.currentTimeMillis();
    }

    void delete(String ... ids) {
        for (String id : ids) {
            this.data.remove(this.idToIndex(id));
        }
    }

    int idToIndex(String id) throws ArrayIndexOutOfBoundsException {
        int result = Utils.parseInt(StringUtils.substringAfter((String)id, (String)SYSTEM_ID_PREFIX), -1);
        if (result < 0 || this.data.size() <= result) {
            throw new ArrayIndexOutOfBoundsException("Incorrect new message ID: " + id + "; index: " + result + "; size: " + this.data.size());
        }
        return result;
    }

    static {
        FETCH_PROFILE_SIZE.add(FetchProfile.Item.SIZE);
        FETCH_PROFILE_LIST = new FetchProfile();
        FETCH_PROFILE_LIST.add(FetchProfile.Item.ENVELOPE);
        FETCH_PROFILE_LIST.add("Message-ID");
        FETCH_PROFILE_LIST.add("Received");
        MAX_CACHE_VALID_TIMEOUT_MS = Duration.ofMinutes(10L).toMillis();
    }

    public static class Item {
        public final int index;
        private final int size;
        public final Message message;

        private Item(int index, int size, Message message) {
            this.index = index;
            this.size = size;
            this.message = message;
        }
    }
}

