/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.action;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.msg.email.config.RecipientsConfig;
import org.bgerp.plugin.msg.email.dao.EMailDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/email/email")
public class EMailAction
extends BaseAction {
    public ActionForward recipients(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId", Utils::isPositive);
        RecipientsConfig config = this.setup.getConfig(RecipientsConfig.class);
        SortedSet values = Collections.synchronizedSortedSet(new TreeSet());
        ExecutorService executors = Executors.newFixedThreadPool(config.areas().size());
        for (String area : config.areas()) {
            executors.submit(() -> {
                try (Connection con = this.setup.getDBSlaveConnectionFromPool();){
                    EMailDAO dao = new EMailDAO(con);
                    List<ParameterEmailValue> emails = null;
                    if ("users".equals(area)) {
                        emails = dao.getUserEmails(null);
                    } else if ("process".equals(area)) {
                        emails = dao.getProcessEmails(processId);
                    } else if ("executors".equals(area)) {
                        Process process = new ProcessDAO(con).getProcessOrThrow(processId);
                        emails = dao.getUserEmails(process.getExecutorIds());
                    } else if ("process_customers".equals(area)) {
                        Set<Integer> ids = new ProcessLinkDAO(con).getLinkCustomers(processId, "customer%").stream().map(Id::getId).collect(Collectors.toSet());
                        if (!ids.isEmpty()) {
                            emails = dao.getCustomerEmails(ids);
                        }
                    } else {
                        throw new Exception("Unknown area: " + area);
                    }
                    if (emails != null) {
                        values.addAll(emails.stream().map(ParameterEmailValue::toString).collect(Collectors.toList()));
                    }
                }
                catch (Exception e) {
                    this.log.error(e);
                }
            });
        }
        executors.shutdown();
        if (!executors.awaitTermination(2L, TimeUnit.MINUTES)) {
            this.log.error("Timeout waiting threads", new Object[0]);
        }
        form.setResponseData("values", values);
        return this.json(conSet, form);
    }
}

