/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.clb.team.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.clb.team.model.Party;
import org.bgerp.plugin.clb.team.model.PartyMember;
import org.bgerp.plugin.clb.team.model.PartyPayment;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;

public class PartyDAO
extends CommonDAO {
    public PartyDAO(Connection con) {
        super(con);
    }

    public void update(Party party) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            if (party.getId() <= 0) {
                pq.addQuery("INSERT INTO  team_party (title, secret)VALUES (?, ?)");
                pq.addString(party.getTitle());
                pq.addString(party.getSecret());
                party.setId(pq.executeInsert());
            } else {
                pq.addQuery("UPDATE  team_party  SET title=? WHERE id=?");
                pq.addString(party.getTitle());
                pq.addInt(party.getId());
                pq.executeUpdate();
            }
        }
    }

    public Party get(String secret) throws SQLException {
        Party result = null;
        try (PreparedQuery pq = new PreparedQuery(this.con, "SELECT * FROM  team_party  WHERE secret=?");){
            pq.addString(secret);
            ResultSet rs = pq.executeQuery();
            if (rs.next()) {
                result = new Party();
                result.setId(rs.getInt("id"));
                result.setTitle(rs.getString("title"));
                result.setSecret(rs.getString("secret"));
            }
        }
        return result;
    }

    public PartyMember getOrCreateMember(int partyId, String title) throws SQLException {
        PartyMember result = null;
        try (PreparedQuery pq = new PreparedQuery(this.con, "SELECT * FROM  team_party_member  WHERE party_id=? AND title=?");){
            ResultSet rs = pq.addInt(partyId).addString(title).executeQuery();
            if (rs.next()) {
                result = this.getMemberFromRs(rs, "");
            } else {
                result = new PartyMember();
                result.setPartyId(partyId);
                result.setTitle(title);
                this.memberUpdate(result);
            }
        }
        return result;
    }

    public List<PartyMember> getMembersWithPayments(int partyId) throws SQLException {
        ArrayList<PartyMember> result = new ArrayList<PartyMember>();
        String query = "SELECT p.*, m.* FROM  team_party_payment AS p INNER JOIN  team_party_member AS m ON p.member_id=m.id WHERE p.party_id=? ORDER BY m.title, p.id";
        Id current = null;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, partyId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PartyMember member = this.getMemberFromRs(rs, "m.");
                if (current == null || current.getId() != member.getId()) {
                    current = member;
                    result.add((PartyMember)current);
                    ((PartyMember)current).setPayments(new ArrayList<PartyPayment>());
                }
                ((PartyMember)current).getPayments().add(this.getPaymentFromRs(rs, "p."));
            }
        }
        return result;
    }

    public void memberUpdate(PartyMember member) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            if (member.getId() <= 0) {
                pq.addQuery("INSERT INTO  team_party_member (party_id, title)VALUES (?, ?)");
                pq.addInt(member.getPartyId());
                pq.addString(member.getTitle());
                member.setId(pq.executeInsert());
            } else {
                pq.addQuery("UPDATE  team_party_member  SET title=? WHERE id=?");
                pq.addString(member.getTitle());
                pq.addInt(member.getId());
                pq.executeUpdate();
            }
        }
    }

    public void memberDelete(int id) throws SQLException {
        String query = "DELETE FROM  team_party_payment  WHERE member_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        query = "DELETE FROM  team_party_member  WHERE id=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void paymentUpdate(PartyPayment payment) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            if (payment.getId() <= 0) {
                pq.addQuery("INSERT INTO  team_party_payment (party_id, member_id, amount, description)VALUES (?, ?, ?, ?)");
                pq.addInt(payment.getPartyId()).addInt(payment.getMemberId()).addBigDecimal(payment.getAmount()).addString(payment.getDescription());
                payment.setId(pq.executeInsert());
            } else {
                pq.addQuery("UPDATE  team_party_payment  SET amount=?, description=? WHERE id=?");
                pq.addBigDecimal(payment.getAmount()).addString(payment.getDescription()).addInt(payment.getId());
                pq.executeUpdate();
            }
        }
    }

    public void paymentDelete(int id) throws SQLException {
        String query = "DELETE FROM  team_party_payment  WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    private PartyMember getMemberFromRs(ResultSet rs, String prefix) throws SQLException {
        PartyMember result = new PartyMember();
        result.setId(rs.getInt(prefix + "id"));
        result.setPartyId(rs.getInt(prefix + "party_id"));
        result.setTitle(rs.getString(prefix + "title"));
        return result;
    }

    private PartyPayment getPaymentFromRs(ResultSet rs, String prefix) throws SQLException {
        PartyPayment result = new PartyPayment();
        result.setId(rs.getInt(prefix + "id"));
        result.setPartyId(rs.getInt(prefix + "party_id"));
        result.setMemberId(rs.getInt(prefix + "member_id"));
        result.setAmount(rs.getBigDecimal(prefix + "amount"));
        result.setDescription(rs.getString(prefix + "description"));
        return result;
    }
}

