/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javassist.NotFoundException;
import org.bgerp.action.base.BaseAction;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.plugin.bil.invoice.model.Position;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.PeriodicDAO;

public class InvoiceDAO
extends PeriodicDAO {
    public InvoiceDAO(Connection con) {
        super(con);
    }

    public void update(Invoice invoice) throws Exception {
        String query = invoice.getId() > 0 ? "UPDATE  invoice  SET amount=?, sent_dt=?, sent_user_id=?, payment_date=?, payment_user_id=?, positions=? WHERE id=?" : "INSERT INTO  invoice (amount, sent_dt, sent_user_id, payment_date, payment_user_id, positions, type_id, process_id, date_from, date_to, create_dt, create_user_id, number_cnt, number)VALUES (?, ?, ?, ?, ?, ?,?, ?, ?, ?, NOW(), ?, ?, ?)";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addBigDecimal(invoice.getAmount());
            pq.addTimestamp(invoice.getSentTime());
            pq.addInt(invoice.getSentUserId());
            pq.addDate(invoice.getPaymentDate());
            pq.addInt(invoice.getPaymentUserId());
            pq.addString(BaseAction.MAPPER.writeValueAsString(invoice.getPositions()));
            if (invoice.getId() <= 0) {
                pq.addInt(invoice.getTypeId());
                pq.addInt(invoice.getProcessId());
                pq.addDate(invoice.getDateFrom());
                pq.addDate(invoice.getDateTo());
                pq.addInt(invoice.getCreateUserId());
                pq.addInt(invoice.getNumberCnt());
                pq.addString(invoice.getNumber());
                invoice.setId(pq.executeUpdate());
            } else {
                pq.addInt(invoice.getId());
                pq.executeUpdate();
            }
        }
        this.updatePositions(invoice);
    }

    private void updatePositions(Invoice invoice) throws SQLException {
        String positionTable = this.checkAndCreateMonthTable("invoice_position", invoice.getDateFrom(), "(invoice_id INT NOT NULL,id CHAR(20) NOT NULL,amount DECIMAL(10,2) NOT NULL,title CHAR(100) NOT NULL,KEY invoice_id(invoice_id))");
        String query = "DELETE FROM " + positionTable + " WHERE invoice_id=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(invoice.getId()).executeUpdate();
        }
        query = "INSERT INTO " + positionTable + "(invoice_id, id, amount, title)VALUES (?,?,?,?)";
        pq = new PreparedQuery(this.con, query);
        try {
            pq.addInt(invoice.getId());
            for (Position position : invoice.getPositions()) {
                pq.setPos(1);
                pq.addString(position.getId()).addBigDecimal(position.getAmount()).addString(position.getTitle());
                pq.executeUpdate();
            }
        }
        finally {
            pq.close();
        }
    }

    public Invoice get(int id) throws Exception {
        Invoice result = null;
        String query = "SELECT * FROM  invoice  WHERE id=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            ResultSet rs = pq.addInt(id).executeQuery();
            if (rs.next()) {
                result = InvoiceDAO.getFromRs(rs);
            }
        }
        return result;
    }

    public Invoice getOrThrow(int id) throws Exception {
        Invoice result = this.get(id);
        if (result == null) {
            throw new NotFoundException("Not found invoice, id=" + id);
        }
        return result;
    }

    public void delete(int id) throws Exception {
        Invoice invoice = this.get(id);
        if (invoice == null) {
            return;
        }
        Object query = "DELETE FROM  invoice  WHERE id=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, (String)query);){
            pq.addInt(id).executeUpdate();
        }
        String positionTable = this.getMonthTableName("invoice_position", invoice.getDateFrom());
        if (this.tableExists(positionTable)) {
            query = "DELETE FROM " + positionTable + " WHERE invoice_id=?";
            try (PreparedQuery pq = new PreparedQuery(this.con, (String)query);){
                pq.addInt(id).executeUpdate();
            }
        }
    }

    public static Invoice getFromRs(ResultSet rs) throws Exception {
        Invoice result = new Invoice();
        result.setAmount(rs.getBigDecimal("amount"));
        result.setSentTime(rs.getTimestamp("sent_dt"));
        result.setSentUserId(rs.getInt("sent_user_id"));
        result.setPaymentDate(rs.getDate("payment_date"));
        result.setPaymentUserId(rs.getInt("payment_user_id"));
        result.setPositions((List)BaseAction.MAPPER.readValue(rs.getString("positions"), (TypeReference)new TypeReference<List<Position>>(){}));
        result.setId(rs.getInt("id"));
        result.setTypeId(rs.getInt("type_id"));
        result.setProcessId(rs.getInt("process_id"));
        result.setNumber(rs.getString("number"));
        result.setDateFrom(rs.getDate("date_from"));
        result.setDateTo(rs.getDate("date_to"));
        result.setCreateTime(rs.getTimestamp("create_dt"));
        result.setCreateUserId(rs.getInt("create_user_id"));
        return result;
    }
}

