/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.queue.filter;

import java.util.List;
import java.util.Set;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.util.Dynamic;
import ru.bgcrm.util.Utils;

public class Filter {
    public static final String VALUES = "values";
    public static final String ON_EMPTY_VALUES = "onEmptyValues";
    private final ConfigMap configMap;
    private final int id;
    private final String title;
    private final List<Integer> availableValues;
    private final Set<Integer> defaultValues;
    private final Set<String> values;
    private final Set<Integer> onEmptyValues;
    private final boolean show;
    private final String width;
    private final String type;

    public Filter(int id, ConfigMap filter) {
        this.id = id;
        this.type = filter.get("type");
        this.title = filter.get("title");
        this.configMap = filter;
        this.onEmptyValues = Utils.toIntegerSet(filter.get(ON_EMPTY_VALUES));
        this.defaultValues = Utils.emptyToNull(Utils.toIntegerSet(filter.get("defaultValues")));
        this.values = Utils.toSet(filter.get(VALUES));
        this.availableValues = Utils.emptyToNull(Utils.toIntegerList(filter.get("availableValues")));
        this.show = Utils.parseBoolean(filter.get("show"), true);
        this.width = filter.get("width");
    }

    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    @Dynamic
    public Set<Integer> getDefaultValues() {
        return this.defaultValues;
    }

    @Dynamic
    public List<Integer> getAvailableValues() {
        return this.availableValues;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public Set<Integer> getOnEmptyValues() {
        return this.onEmptyValues;
    }

    public boolean isShow() {
        return this.show;
    }

    public String getWidth() {
        return this.width;
    }
}

