/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.config;

import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.util.Utils;

public class ProcessCreateInConfig
extends Config {
    private final Set<String> areas;
    private final Set<String> objectTypes;
    private final String copyParams;
    private final ConfigMap config;

    protected ProcessCreateInConfig(ConfigMap config) {
        super(null);
        config = config.sub("create.in.");
        this.areas = Utils.toSet(config.get("areas", "*"));
        this.objectTypes = Utils.toSet(config.get("objectTypes", "*"));
        this.copyParams = config.get("copyParams", "");
        this.config = config;
    }

    public boolean check(String area, String objectType) {
        return !(!this.areas.contains(area) && !this.areas.contains("*") || objectType != null && !this.objectTypes.contains(objectType) && !this.objectTypes.contains("*"));
    }

    public String getCopyParams() {
        return this.copyParams;
    }

    public boolean openCreated(String objectType) {
        return this.config.getBoolean(objectType + ".openCreated", this.config.getBoolean("*.openCreated"));
    }
}

