/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.config;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import ru.bgcrm.util.Utils;

public class IsolationConfig
extends Config {
    private final IsolationProcess isolationProcess;

    protected IsolationConfig(ConfigMap config) throws BGMessageException {
        super(null);
        this.isolationProcess = this.loadProcessIsolation(config);
    }

    public IsolationProcess getIsolationProcess() {
        return this.isolationProcess;
    }

    private IsolationProcess loadProcessIsolation(ConfigMap config) throws BGMessageException {
        String isolation = config.get("isolation.process");
        if ("executor".equals(isolation)) {
            return IsolationProcess.EXECUTOR;
        }
        if ("group".equals(isolation)) {
            IsolationProcess result = IsolationProcess.GROUP;
            Set<Integer> executorFilteredTypes = Utils.toIntegerSet(config.get("isolation.process.group.executor.typeIds"));
            if (!executorFilteredTypes.isEmpty()) {
                result.executorTypeIds = Utils.toString(executorFilteredTypes);
            }
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)isolation)) {
            throw new BGMessageException("Unsupported isolation level: " + String.valueOf(config), new Object[0]);
        }
        return null;
    }

    public static class IsolationProcess {
        public static final IsolationProcess EXECUTOR = new IsolationProcess();
        public static final IsolationProcess GROUP = new IsolationProcess();
        private String executorTypeIds;

        public String getExecutorTypeIds() {
            return this.executorTypeIds;
        }
    }
}

