/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.param;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.dao.FileDataDAO;
import ru.bgcrm.model.FileData;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ParameterValuePair {
    private Parameter parameter;
    private Object value;
    private String valueTitle;

    public ParameterValuePair(Parameter parameter) {
        this.parameter = parameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setValueTitle(String valueTitle) {
        this.valueTitle = valueTitle;
    }

    public String getValueTitle() {
        String result = this.valueTitle;
        if (result == null) {
            result = ParameterValuePair.getValueTitle(this.parameter, this.value);
        }
        return result;
    }

    public String getBase64EncodedImgSrc() throws Exception {
        if (this.value == null) {
            return null;
        }
        if (!"file".equals(this.parameter.getType())) {
            throw new IllegalArgumentException("Attempt to get");
        }
        FileData fileData = (FileData)Utils.getFirst(((Map)this.value).values());
        if (fileData == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(100000).append("data:").append(URLConnection.guessContentTypeFromName(fileData.getTitle())).append(";base64, ");
        try (FileInputStream fis = new FileInputStream(new FileDataDAO(null).getFile(fileData));){
            byte[] data = IOUtils.toByteArray((InputStream)fis);
            result.append(Base64.getEncoder().encodeToString(data));
        }
        return result.toString();
    }

    public static final String getValueTitle(Parameter parameter, Object value) {
        String result = null;
        if (value == null) {
            return result;
        }
        String type = parameter.getType();
        if ("address".equals(type)) {
            StringBuilder address = new StringBuilder();
            for (ParameterAddressValue item : ((Map)value).values()) {
                Utils.addSeparated(address, "; ", item.getValue());
            }
            result = address.toString();
        } else if ("date".equals(type)) {
            result = TimeUtils.format((Date)value, "ymd");
        } else if ("datetime".equals(type)) {
            result = TimeUtils.format((Date)value, "ymdhms");
        } else if ("email".equals(type)) {
            result = Utils.toString(((TreeMap)value).values(), "", "; ");
        } else if ("list".equals(type) || "listcount".equals(type) || "tree".equals(type) || "treecount".equals(type)) {
            result = Utils.getObjectTitles((Collection)value);
        } else {
            int pos;
            String string = result = value == null ? "" : String.valueOf(value);
            if ("text".equals(type) && "hideProtocol".equals(parameter.getShowAsLink()) && (pos = result.indexOf("//")) > 0) {
                result = result.substring(pos + 2);
            }
        }
        return result;
    }
}

