/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.exec;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exec.Runnable;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.util.Utils;

public class CorrectPermissions
implements Runnable {
    private static final Log log = Log.getLog();

    @Override
    public void run() {
        log.debug("Run", new Object[0]);
        this.replace(" user_permission ");
        this.replace(" user_permset_permission ");
    }

    private void replace(String tableName) {
        Map<String, String> replacements = this.replacements(tableName);
        if (replacements.isEmpty()) {
            return;
        }
        this.delete(tableName, replacements);
        this.replace(tableName, replacements);
    }

    private void delete(String tableName, Map<String, String> replacements) {
        String actions = replacements.entrySet().stream().filter(me -> me.getValue() == null).map(Map.Entry::getKey).collect(Collectors.joining("', '"));
        if (Utils.isBlankString(actions)) {
            return;
        }
        log.debug("Deleting: {}", actions);
        String query = "DELETE FROM" + tableName + "WHERE action IN ('" + actions + "')";
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            con.createStatement().executeUpdate(query);
            con.commit();
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private void replace(String tableName, Map<String, String> replacements) {
        if ((replacements = replacements.entrySet().stream().filter(me -> me.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            return;
        }
        log.debug("Replacing: {}", replacements);
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            String query = "UPDATE" + tableName + "SET action=? WHERE action=?";
            PreparedStatement ps = con.prepareStatement(query);
            for (Map.Entry<String, String> me2 : replacements.entrySet()) {
                ps.setString(1, me2.getValue());
                ps.setString(2, me2.getKey());
                ps.executeUpdate();
            }
            con.commit();
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private Map<String, String> replacements(String tableName) {
        TreeMap<String, String> replacements = new TreeMap<String, String>();
        try (Connection conSlave = Setup.getSetup().getDBSlaveConnectionFromPool();){
            String query = "SELECT DISTINCT action FROM" + tableName;
            PreparedStatement ps = conSlave.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String action = rs.getString(1);
                PermissionNode node = PermissionNode.getPermissionNode(action);
                if (node == null) {
                    replacements.put(action, null);
                    continue;
                }
                if (node.getAction().equals(action)) continue;
                replacements.put(action, node.getAction());
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        return replacements;
    }
}

