/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.util.Collection;
import java.util.Set;
import org.bgerp.dao.process.Order;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

abstract class SearchDAO
extends CommonDAO {
    protected final DynActionForm form;
    private Boolean open;
    private Set<Integer> typeIds;
    private Collection<Integer> statusIds;
    private Order order;

    protected SearchDAO(Connection con) {
        super(con);
        this.form = null;
    }

    protected SearchDAO(Connection con, DynActionForm form) {
        super(con);
        this.form = form;
    }

    public SearchDAO withOpen(Boolean value) {
        this.open = value;
        return this;
    }

    public SearchDAO withType(Set<Integer> value) {
        this.typeIds = value;
        return this;
    }

    public SearchDAO withStatus(Collection<Integer> value) {
        this.statusIds = value;
        return this;
    }

    public SearchDAO order(Order value) {
        this.order = value;
        return this;
    }

    protected void filterOpen(PreparedQuery pq) {
        if (this.open != null) {
            pq.addQuery(" AND p.close_dt IS ");
            if (!this.open.booleanValue()) {
                pq.addQuery("NOT ");
            }
            pq.addQuery("NULL ");
        }
    }

    protected void filterType(PreparedQuery pq) {
        if (this.typeIds != null && !this.typeIds.isEmpty()) {
            pq.addQuery(" AND p.type_id IN (");
            pq.addQuery(Utils.toString(this.typeIds));
            pq.addQuery(") ");
        }
    }

    protected void filterStatus(PreparedQuery pq) {
        if (this.statusIds != null && !this.statusIds.isEmpty()) {
            pq.addQuery(" AND p.status_id IN (");
            pq.addQuery(Utils.toString(this.statusIds));
            pq.addQuery(") ");
        }
    }

    protected void order(PreparedQuery pq) {
        if (this.order != null) {
            pq.addQuery(" ORDER BY ");
            pq.addQuery(this.order.sql("p."));
        }
    }
}

