/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.SearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class ProcessSearchDAO
extends SearchDAO {
    private Set<Integer> excludeIds;
    private String idOrDescriptionLike;

    public ProcessSearchDAO(Connection con) {
        super(con);
    }

    public ProcessSearchDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    @Override
    public ProcessSearchDAO withOpen(Boolean value) {
        return (ProcessSearchDAO)super.withOpen(value);
    }

    @Override
    public ProcessSearchDAO withType(Set<Integer> value) {
        return (ProcessSearchDAO)super.withType(value);
    }

    @Override
    public ProcessSearchDAO withStatus(Collection<Integer> value) {
        return (ProcessSearchDAO)super.withStatus(value);
    }

    public ProcessSearchDAO withExcludeIds(Set<Integer> value) {
        this.excludeIds = value;
        return this;
    }

    public ProcessSearchDAO withIdOrDescriptionLike(String value) {
        this.idOrDescriptionLike = value;
        return this;
    }

    @Override
    public ProcessSearchDAO order(Order value) {
        return (ProcessSearchDAO)super.order(value);
    }

    public void search(Pageable<Process> result) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            List<Process> list = result.getList();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS p.* FROM  process AS p");
            pq.addQuery(" WHERE 1>0 ");
            this.filterOpen(pq);
            this.filterType(pq);
            this.filterStatus(pq);
            if (CollectionUtils.isNotEmpty(this.excludeIds)) {
                pq.addQuery(" AND p.id NOT IN (" + Utils.toString(this.excludeIds) + ") ");
            }
            if (Utils.notBlankString(this.idOrDescriptionLike)) {
                pq.addQuery(" AND (p.id LIKE ? OR p.description LIKE ?)");
                pq.addString(this.idOrDescriptionLike).addString(this.idOrDescriptionLike);
            }
            this.order(pq);
            pq.addQuery(this.getPageLimit(page));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(ProcessDAO.getProcessFromRs(rs, "p."));
            }
            page.setRecordCount(this.foundRows(pq.getPrepared()));
        }
    }
}

