/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.dao.process.SearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class ProcessParamSearchDAO
extends SearchDAO {
    private Set<Integer> paramTextIds;
    private String paramTextValue;

    public ProcessParamSearchDAO(Connection con) {
        super(con);
    }

    public ProcessParamSearchDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    @Override
    public ProcessParamSearchDAO withOpen(Boolean value) {
        return (ProcessParamSearchDAO)super.withOpen(value);
    }

    public ProcessParamSearchDAO withParamTextIds(Set<Integer> values) {
        this.paramTextIds = values;
        return this;
    }

    public ProcessParamSearchDAO withParamTextValue(String value) {
        this.paramTextValue = value;
        return this;
    }

    public void search(Pageable<ParameterSearchedObject<Process>> result) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            List<ParameterSearchedObject<Process>> list = result.getList();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS p.*, param.* FROM  process AS p");
            if (!Utils.notBlankString(this.paramTextValue)) {
                throw new IllegalArgumentException("No param value filter was defined");
            }
            pq.addQuery(" INNER JOIN  param_text AS param ON p.id=param.id AND param.value LIKE ?");
            pq.addString(this.paramTextValue);
            pq.addQuery(" INNER JOIN  param_pref AS param_pref ON param.param_id=param_pref.id AND param_pref.object=?");
            pq.addString("process");
            if (CollectionUtils.isNotEmpty(this.paramTextIds)) {
                pq.addQuery(" AND param.param_id IN (").addQuery(Utils.toString(this.paramTextIds)).addQuery(")");
            }
            pq.addQuery(" WHERE 1>0 ");
            this.filterOpen(pq);
            pq.addQuery(this.getPageLimit(page));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(new ParameterSearchedObject<Process>(ProcessDAO.getProcessFromRs(rs, "p."), rs.getInt("param.param_id"), rs.getString("param.value")));
            }
            page.setRecordCount(this.foundRows(pq.getPrepared()));
        }
    }
}

