/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.dao.message.process.MessagePossibleProcessConfig;
import org.bgerp.dao.message.process.MessagePossibleProcessSearch;
import org.bgerp.model.Pageable;
import org.bgerp.model.process.link.ProcessLink;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;

public class ProcessMessageDAO
extends ProcessDAO {
    public ProcessMessageDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    public void searchProcessListForMessage(Pageable<Pair<Process, MessagePossibleProcessSearch>> searchResult, String from, List<ProcessLink> links, Boolean open) throws SQLException {
        MessagePossibleProcessConfig config = Setup.getSetup().getConfig(MessagePossibleProcessConfig.class);
        if (config == null) {
            return;
        }
        Iterator<Map.Entry<Integer, MessagePossibleProcessSearch>> typesIt = config.getSearches().entrySet().iterator();
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Pair<Process, MessagePossibleProcessSearch>> list = searchResult.getList();
            PreparedQuery pq = new PreparedQuery(this.con);
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS * FROM  (");
            boolean first = true;
            while (typesIt.hasNext()) {
                boolean added = typesIt.next().getValue().addQuery(this.form.getUser(), pq, first, from, links, open);
                first = first && !added;
            }
            if (!first) {
                pq.addQuery(") p");
                pq.addQuery(" GROUP BY id");
                pq.addQuery(" ORDER BY create_dt DESC ");
                pq.addQuery(this.getPageLimit(page));
                ResultSet rs = pq.executeQuery();
                while (rs.next()) {
                    list.add(new Pair<Process, MessagePossibleProcessSearch>(ProcessMessageDAO.getProcessFromRs(rs, ""), (MessagePossibleProcessSearch)config.getSearches().get(rs.getInt("type"))));
                }
                this.setRecordCount(page, pq.getPrepared());
                pq.close();
            }
        }
    }
}

