/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.SearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class ProcessLinkSearchDAO
extends SearchDAO {
    private String linkObjectType;
    private int linkObjectId;

    public ProcessLinkSearchDAO(Connection con) {
        super(con);
    }

    public ProcessLinkSearchDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    @Override
    public ProcessLinkSearchDAO withOpen(Boolean value) {
        return (ProcessLinkSearchDAO)super.withOpen(value);
    }

    @Override
    public ProcessLinkSearchDAO order(Order value) {
        return (ProcessLinkSearchDAO)super.order(value);
    }

    public ProcessLinkSearchDAO withLinkObjectType(String value) {
        this.linkObjectType = value;
        return this;
    }

    public ProcessLinkSearchDAO withLinkObjectId(int value) {
        this.linkObjectId = value;
        return this;
    }

    public void search(Pageable<Process> result) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            List<Process> list = result.getList();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS DISTINCT p.* FROM  process AS p");
            pq.addQuery(" INNER JOIN  process_link AS l ON ");
            pq.addQuery("p.id=l.process_id");
            if (Utils.notBlankString(this.linkObjectType)) {
                pq.addQuery(" AND l.object_type=?").addString(this.linkObjectType);
            }
            if (this.linkObjectId > 0) {
                pq.addQuery(" AND l.object_id=?").addInt(this.linkObjectId);
            }
            pq.addQuery(ProcessDAO.getIsolationJoin(this.form, "p"));
            pq.addQuery(" WHERE 1>0 ");
            this.filterOpen(pq);
            this.order(pq);
            pq.addQuery(this.getPageLimit(page));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(ProcessDAO.getProcessFromRs(rs, "p."));
            }
            page.setRecordCount(this.foundRows(pq.getPrepared()));
        }
    }
}

