/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.param;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.OldParamSearchDAO;
import org.bgerp.dao.param.ParamLogDAO;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.IdTitleComment;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.param.ParameterValuePair;
import org.bgerp.util.Log;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.FileDataDAO;
import ru.bgcrm.model.FileData;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.AddressUtils;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ParamValueDAO
extends CommonDAO {
    private static final Log log = Log.getLog();
    public static final String[] TABLE_NAMES = new String[]{" param_address ", " param_blob ", " param_date ", " param_datetime ", " param_email ", " param_file ", " param_list ", " param_listcount ", " param_money ", " param_phone ", " param_phone_item ", " param_text ", " param_tree "};
    public static final String COPY_PARAMS_SEPARATORS = ";,";
    private boolean history;
    private int userId;

    public ParamValueDAO(Connection con) {
        super(con);
    }

    public ParamValueDAO(Connection con, boolean history, int userId) {
        this(con);
        this.history = history;
        this.userId = userId;
    }

    public void copyParam(int fromObjectId, int toObjectId, int paramId) throws SQLException, BGException {
        this.copyParam(fromObjectId, paramId, toObjectId, paramId);
    }

    public void copyParam(int fromObjectId, int fromParamId, int toObjectId, int toParamId) throws SQLException, BGException {
        Object query = null;
        ArrayList<PreparedStatement> psList = new ArrayList<PreparedStatement>();
        Parameter paramFrom = ParameterCache.getParameter(fromParamId);
        if (paramFrom == null) {
            throw new BGException("Param not found: " + fromParamId, new Object[0]);
        }
        Parameter paramTo = ParameterCache.getParameter(toParamId);
        if (paramTo == null) {
            throw new BGException("Param not found: " + toParamId, new Object[0]);
        }
        if (!paramFrom.getType().equals(paramTo.getType())) {
            throw new BGException("Different copy param types.", new Object[0]);
        }
        Parameter.Type paramType = Parameter.Type.of(paramFrom.getType());
        switch (paramType) {
            case ADDRESS: {
                query = "INSERT INTO  param_address  (id, param_id, n, house_id, flat, room, pod, floor, value, comment, custom) SELECT ?, ?, n, house_id, flat, room, pod, floor, value, comment, custom FROM  param_address  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case EMAIL: {
                query = "INSERT INTO  param_email  (id, param_id, n, value) SELECT ?, ?, n, value FROM  param_email  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case LIST: {
                query = "INSERT IGNORE INTO  param_list (id, param_id, value, comment)SELECT ?, ?, value, comment  FROM  param_list  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case LISTCOUNT: {
                query = "INSERT INTO  param_listcount (id, param_id, value, count)SELECT ?, ?, value, count FROM  param_listcount  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case TREE: {
                query = "INSERT INTO  param_tree (id, param_id, value) SELECT ?, ?, value FROM  param_tree  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case TREECOUNT: {
                query = "INSERT INTO  param_treecount (id, param_id, value, count)SELECT ?, ?, value, count FROM  param_treecount  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case DATE: 
            case DATETIME: 
            case MONEY: 
            case TEXT: 
            case BLOB: 
            case PHONE: {
                String tableName = "param_" + paramType.toString().toLowerCase();
                query = "INSERT INTO " + tableName + " (id, param_id, value) SELECT ?, ?, value FROM " + tableName + " WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                if (Parameter.Type.PHONE != paramType) break;
                query = "INSERT INTO  param_phone_item  (id, param_id, n, phone, comment) SELECT ?, ?, n, phone, comment FROM  param_phone_item  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
                break;
            }
            case FILE: {
                query = "INSERT INTO  param_file (id, param_id, n, value) SELECT ?, ?, n, value FROM  param_file  WHERE id=? AND param_id=?";
                psList.add(this.con.prepareStatement((String)query));
            }
        }
        for (PreparedStatement ps : psList) {
            ps.setInt(1, toObjectId);
            ps.setInt(2, toParamId);
            ps.setInt(3, fromObjectId);
            ps.setInt(4, fromParamId);
            ps.executeUpdate();
            ps.close();
        }
    }

    public void copyParams(int fromObjectId, int toObjectId, String copyMapping) throws SQLException, BGException {
        if (Utils.isBlankString(copyMapping)) {
            return;
        }
        for (String token : Utils.toList(copyMapping, COPY_PARAMS_SEPARATORS)) {
            String[] pair = token.split(":");
            if (pair.length == 2) {
                this.copyParam(fromObjectId, Utils.parseInt(pair[0]), toObjectId, Utils.parseInt(pair[1]));
                continue;
            }
            if (Utils.parseInt(token) > 0) {
                int paramId = Utils.parseInt(token);
                this.copyParam(fromObjectId, paramId, toObjectId, paramId);
                continue;
            }
            log.error("Incorrect copy param mapping: {}", token);
        }
    }

    public void copyParams(int fromObjectId, int toObjectId, Collection<Integer> paramIds) throws SQLException, BGException {
        for (int paramId : paramIds) {
            this.copyParam(fromObjectId, paramId, toObjectId, paramId);
        }
    }

    public void deleteParams(String objectType, int id) throws SQLException {
        String query = "DELETE pl FROM  param_log AS pl INNER JOIN  param_pref AS pref ON pl.param_id=pref.id AND pref.object='" + objectType + "' WHERE pl.object_id=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(id);
            pq.executeUpdate();
        }
        for (String tableName : TABLE_NAMES) {
            query = "DELETE pv FROM " + tableName + " AS pv INNER JOIN  param_pref AS pref ON pv.param_id=pref.id AND pref.object=? WHERE pv.id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, objectType);
                ps.setInt(2, id);
                ps.executeUpdate();
            }
        }
    }

    public ParameterAddressValue getParamAddress(int id, int paramId, int position) throws SQLException {
        ParameterAddressValue result = null;
        String query = "SELECT * FROM  param_address WHERE id=? AND param_id=? AND n=? LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ps.setInt(3, position);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = this.getParameterAddressValueFromRs(rs, "");
        }
        ps.close();
        return result;
    }

    public SortedMap<Integer, ParameterAddressValue> getParamAddress(int id, int paramId) throws SQLException {
        return this.getParamAddress(id, paramId, false, null);
    }

    public SortedMap<Integer, ParameterAddressValue> getParamAddress(int id, int paramId, boolean loadDirs) throws SQLException {
        return this.getParamAddress(id, paramId, loadDirs, null);
    }

    public SortedMap<Integer, ParameterAddressValue> getParamAddress(int id, int paramId, boolean loadDirs, String formatName) throws SQLException {
        TreeMap<Integer, ParameterAddressValue> result = new TreeMap<Integer, ParameterAddressValue>();
        StringBuilder query = new StringBuilder(300);
        query.append("SELECT * FROM  param_address  AS param ");
        if (loadDirs) {
            query.append(" LEFT JOIN  address_house  AS house ON param.house_id=house.id ");
            AddressDAO.addHouseSelectQueryJoins(query, 4);
        }
        query.append(" WHERE param.id=? AND param.param_id=? ORDER BY param.n");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.put(rs.getInt("n"), this.getParameterAddressValueFromRs(rs, "param.", loadDirs, formatName));
        }
        ps.close();
        return result;
    }

    private ParameterAddressValue getParameterAddressValueFromRs(ResultSet rs, String prefix) throws SQLException {
        return this.getParameterAddressValueFromRs(rs, "", false, null);
    }

    private ParameterAddressValue getParameterAddressValueFromRs(ResultSet rs, String prefix, boolean loadDirs, String formatName) throws SQLException {
        ParameterAddressValue result = new ParameterAddressValue();
        result.setHouseId(rs.getInt(prefix + "house_id"));
        result.setFlat(rs.getString(prefix + "flat"));
        result.setRoom(rs.getString(prefix + "room"));
        result.setPod(rs.getInt(prefix + "pod"));
        result.setFloor(rs.getInt(prefix + "floor"));
        result.setValue(rs.getString(prefix + "value"));
        result.setComment(rs.getString(prefix + "comment"));
        result.setCustom(rs.getString(prefix + "custom"));
        if (loadDirs) {
            result.setHouse(AddressDAO.getAddressHouseFromRs(rs, "house.", 4));
            if (Utils.notBlankString(formatName)) {
                result.setValue(AddressUtils.buildAddressValue(result, null, formatName));
            }
        }
        return result;
    }

    public String getParamBlob(int id, int paramId) throws SQLException {
        return this.getTextParam(id, paramId, " param_blob ");
    }

    private String getTextParam(int id, int paramId, String table) throws SQLException {
        String result = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("value");
        query.append(" FROM ");
        query.append(table);
        query.append(" WHERE ");
        query.append("id=? AND param_id=? LIMIT 1");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getString(1);
        }
        ps.close();
        return result;
    }

    public Date getParamDate(int id, int paramId) throws SQLException {
        return this.getParamDate(id, paramId, " param_date ");
    }

    public Date getParamDateTime(int id, int paramId) throws SQLException {
        return this.getParamDate(id, paramId, " param_datetime ");
    }

    private Date getParamDate(int id, int paramId, String table) throws SQLException {
        Timestamp result = null;
        String query = "SELECT value FROM " + table + " WHERE id=? AND param_id=? LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        ps.close();
        return result;
    }

    public ParameterEmailValue getParamEmail(int id, int paramId, int position) throws SQLException {
        ParameterEmailValue emailItem = null;
        String query = "SELECT * FROM  param_email WHERE id=? AND param_id=? AND n=? LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ps.setInt(3, position);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            emailItem = new ParameterEmailValue(rs.getString("value"), rs.getString("comment"));
        }
        ps.close();
        return emailItem;
    }

    public SortedMap<Integer, ParameterEmailValue> getParamEmail(int id, int paramId) throws SQLException {
        TreeMap<Integer, ParameterEmailValue> emailItems = new TreeMap<Integer, ParameterEmailValue>();
        String query = "SELECT * FROM  param_email WHERE id=? AND param_id=? ORDER BY n ";
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            emailItems.put(rs.getInt("n"), new ParameterEmailValue(rs.getString("value"), rs.getString("comment")));
        }
        ps.close();
        return emailItems;
    }

    public FileData getParamFile(int id, int paramId, int position) throws SQLException {
        FileData result = null;
        String query = "SELECT fd.*, pf.n FROM  param_file  AS pf INNER JOIN  file_data  AS fd ON pf.value=fd.id WHERE pf.id=? AND pf.param_id=? AND pf.n=? LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ps.setInt(3, position);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = FileDataDAO.getFromRs(rs, "fd.");
        }
        ps.close();
        return result;
    }

    public SortedMap<Integer, FileData> getParamFile(int id, int paramId) throws SQLException {
        TreeMap<Integer, FileData> fileMap = new TreeMap<Integer, FileData>();
        String query = "SELECT fd.*, pf.n FROM  param_file  AS pf INNER JOIN  file_data  AS fd ON pf.value=fd.id WHERE pf.id=? AND pf.param_id=? ";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            fileMap.put(rs.getInt("pf.n"), FileDataDAO.getFromRs(rs, "fd."));
        }
        ps.close();
        return fileMap;
    }

    public Set<Integer> getParamList(int id, int paramId) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        String query = "SELECT value FROM  param_list WHERE id=? AND param_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        ps.close();
        return result;
    }

    @Deprecated
    public List<IdTitle> getParamListWithTitles(int id, int paramId) throws SQLException {
        List<IdTitleComment> values = this.getParamListWithTitlesAndComments(id, paramId);
        return new ArrayList<IdTitle>(values);
    }

    public Map<Integer, String> getParamListWithComments(int id, int paramId) throws SQLException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        String query = "SELECT value, comment FROM  param_list WHERE id=? AND param_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.put(rs.getInt(1), rs.getString(2));
        }
        ps.close();
        return result;
    }

    @Deprecated
    public List<IdTitleComment> getParamListWithTitlesAndComments(int id, int paramId) throws SQLException {
        ArrayList<IdTitleComment> result = new ArrayList<IdTitleComment>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(" val.value, dir.title, val.comment ");
        query.append(" FROM ");
        query.append(" param_list ");
        query.append(" AS val ");
        this.addListParamJoin(query, paramId);
        query.append(" WHERE ");
        query.append(" val.id=? AND val.param_id=? ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new IdTitleComment(rs.getInt(1), rs.getString(2), rs.getString(3)));
        }
        ps.close();
        return result;
    }

    private void addListParamJoin(StringBuilder query, int paramId) throws SQLException {
        Parameter param = ParameterCache.getParameter(paramId);
        String joinTable = param.getConfigMap().get("directory", " param_list_value ");
        this.addListTableJoin(query, joinTable);
    }

    private void addListTableJoin(StringBuilder query, String tableName) {
        query.append(" LEFT JOIN ");
        query.append(tableName);
        query.append(" AS dir ON ");
        if (tableName.equals(" param_list_value ")) {
            query.append(" val.param_id=dir.param_id AND val.value=dir.id ");
        } else {
            query.append(" val.value=dir.id ");
        }
    }

    public Map<Integer, BigDecimal> getParamListCount(int id, int paramId) throws SQLException {
        HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
        String query = "SELECT value, count FROM  param_listcount  WHERE id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getInt(1), rs.getBigDecimal(2));
            }
        }
        return result;
    }

    @Deprecated
    public List<IdTitle> getParamListCountWithTitles(int id, int paramId) throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("val.value, dir.title");
        query.append(" FROM ");
        query.append(" param_listcount ");
        query.append("AS val");
        this.addListCountParamJoin(query);
        query.append(" WHERE ");
        query.append("val.id=? AND val.param_id=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new IdTitle(rs.getInt(1), rs.getString(2)));
        }
        ps.close();
        return result;
    }

    private void addListCountParamJoin(StringBuilder query) throws SQLException {
        query.append(" LEFT JOIN  param_listcount_value AS dir ON val.param_id=dir.param_id AND val.value=dir.id");
    }

    public BigDecimal getParamMoney(int id, int paramId) throws SQLException {
        return Utils.parseBigDecimal(this.getTextParam(id, paramId, " param_money "), null);
    }

    public ParameterPhoneValue getParamPhone(int id, int paramId) throws SQLException {
        ParameterPhoneValue result = new ParameterPhoneValue();
        ArrayList<ParameterPhoneValueItem> itemList = new ArrayList<ParameterPhoneValueItem>();
        String query = "SELECT phone, comment FROM  param_phone_item  WHERE id=? AND param_id=? ORDER BY n";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                itemList.add(ParamValueDAO.getParamPhoneValueItemFromRs(rs));
            }
            result.setItemList(itemList);
        }
        return result;
    }

    public static ParameterPhoneValueItem getParamPhoneValueItemFromRs(ResultSet rs) throws SQLException {
        ParameterPhoneValueItem item = new ParameterPhoneValueItem();
        item.setPhone(rs.getString("phone"));
        item.setComment(rs.getString("comment"));
        return item;
    }

    public String getParamText(int id, int paramId) throws SQLException {
        return this.getTextParam(id, paramId, " param_text ");
    }

    public Set<String> getParamTree(int id, int paramId) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        String query = "SELECT value FROM  param_tree WHERE id=? AND param_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        ps.close();
        return result;
    }

    @Deprecated
    public List<IdStringTitle> getParamTreeWithTitles(int id, int paramId) throws SQLException {
        ArrayList<IdStringTitle> result = new ArrayList<IdStringTitle>();
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT ");
        query.append("val.value, dir.title");
        query.append(" FROM ");
        query.append(" param_tree ");
        query.append("AS val");
        this.addTreeParamJoin(query);
        query.append(" WHERE ");
        query.append("val.id=? AND val.param_id=?");
        query.append(" ORDER BY ").append("val.value");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new IdStringTitle(rs.getString(1), rs.getString(2)));
        }
        ps.close();
        return result;
    }

    private void addTreeParamJoin(StringBuilder query) throws SQLException {
        query.append(" LEFT JOIN  param_tree_value AS dir ON val.param_id=dir.param_id AND val.value=dir.id");
    }

    public Map<String, BigDecimal> getParamTreeCount(int id, int paramId) throws SQLException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(10);
        String query = "SELECT value, count FROM  param_treecount  WHERE id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getString("value"), rs.getBigDecimal("count"));
            }
        }
        return result;
    }

    public boolean isParameterFilled(int id, Parameter param) throws Exception {
        String query = "SELECT * FROM param_" + param.getType() + " WHERE id=? AND param_id=? LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setInt(2, param.getId());
        boolean result = ps.executeQuery().next();
        ps.close();
        return result;
    }

    public void objectIdInvert(String objectType, int currentObjectId) throws SQLException {
        for (String tableName : TABLE_NAMES) {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(tableName);
            query.append(" AS param");
            query.append(" INNER JOIN ");
            query.append(" param_pref ");
            query.append("AS pref ON param.param_id=pref.id AND pref.object=? ");
            query.append("SET param.id=?");
            query.append(" WHERE ");
            query.append("param.id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, objectType);
            ps.setInt(2, -currentObjectId);
            ps.setInt(3, currentObjectId);
            ps.executeUpdate();
            ps.close();
        }
    }

    public Map<Integer, ParameterValuePair> parameters(Id object) throws SQLException {
        List<Parameter> parameters = null;
        if (object instanceof Customer) {
            parameters = ParameterCache.getObjectTypeParameterList("customer", ((Customer)object).getParamGroupId());
        } else if (object instanceof Process) {
            ProcessType type = ((Process)object).getType();
            parameters = Utils.getObjectList(ParameterCache.getParameterMap(), type.getProperties().getParameterIds());
        } else if (object instanceof User) {
            parameters = ParameterCache.getObjectTypeParameterList("user");
        } else if (object instanceof AddressHouse) {
            parameters = ParameterCache.getObjectTypeParameterList("address_house");
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + String.valueOf(object));
        }
        return this.loadParameters(parameters, object.getId()).stream().collect(Collectors.toMap(pv -> pv.getParameter().getId(), pv -> pv));
    }

    public void updateParamAddress(int id, int paramId, int position, ParameterAddressValue value) throws SQLException {
        int index = 1;
        if (value == null) {
            PreparedQuery pq = new PreparedQuery(this.con);
            pq.addQuery("DELETE FROM  param_address  WHERE id=? AND param_id=? ");
            pq.addInt(id);
            pq.addInt(paramId);
            if (position > 0) {
                pq.addQuery(" AND n=?");
                pq.addInt(position);
            }
            pq.executeUpdate();
            pq.close();
        } else {
            if (value.getValue() == null) {
                value.setValue(AddressUtils.buildAddressValue(value, this.con));
            }
            try {
                if (position <= 0) {
                    position = 1;
                    query = "SELECT MAX(n) + 1 FROM  param_address  WHERE id=? AND param_id=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, id);
                    ps.setInt(2, paramId);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next() && rs.getObject(1) != null) {
                        position = rs.getInt(1);
                    }
                    ps.close();
                    this.insertParamAddress(id, paramId, position, value);
                } else {
                    query = "UPDATE  param_address  SET value=?, house_id=?, flat=?, room=?, pod=?, floor=?, comment=?, custom=? WHERE id=? AND param_id=? AND n=?";
                    ps = this.con.prepareStatement(query);
                    ps.setString(index++, value.getValue());
                    ps.setInt(index++, value.getHouseId());
                    ps.setString(index++, value.getFlat());
                    ps.setString(index++, value.getRoom());
                    ps.setInt(index++, value.getPod());
                    ps.setInt(index++, value.getFloor());
                    ps.setString(index++, value.getComment());
                    ps.setString(index++, value.getCustom());
                    ps.setInt(index++, id);
                    ps.setInt(index++, paramId);
                    ps.setInt(index++, position);
                    int cnt = ps.executeUpdate();
                    ps.close();
                    if (cnt == 0) {
                        this.insertParamAddress(id, paramId, position, value);
                    }
                }
            }
            catch (SQLIntegrityConstraintViolationException e) {
                log.debug("Duplicated address value failed to be inserted: {}", value);
            }
        }
        if (this.history) {
            StringBuffer result = new StringBuffer();
            SortedMap<Integer, ParameterAddressValue> addresses = this.getParamAddress(id, paramId);
            Iterator<Integer> it = addresses.keySet().iterator();
            while (it.hasNext()) {
                if (result.length() > 0) {
                    result.append("; ");
                }
                Integer key = it.next();
                result.append(((ParameterAddressValue)addresses.get(key)).getValue());
            }
            this.logParam(id, paramId, this.userId, result.toString());
        }
    }

    private void insertParamAddress(int id, int paramId, int position, ParameterAddressValue value) throws SQLException {
        int index = 1;
        String query = "INSERT INTO  param_address  SET id=?, param_id=?, n=?, value=?, house_id=?, flat=?, room=?, pod=?, floor=?, comment=?, custom=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(index++, id);
        ps.setInt(index++, paramId);
        ps.setInt(index++, position);
        ps.setString(index++, value.getValue());
        ps.setInt(index++, value.getHouseId());
        ps.setString(index++, value.getFlat());
        ps.setString(index++, value.getRoom());
        ps.setInt(index++, value.getPod());
        ps.setInt(index++, value.getFloor());
        ps.setString(index++, value.getComment());
        ps.setString(index++, value.getCustom());
        ps.executeUpdate();
        ps.close();
    }

    private void logParam(int id, int paramId, int userId, String newValue) throws SQLException {
        if (Utils.isBlankString(newValue)) {
            newValue = null;
        }
        ParamLogDAO paramLogDAO = new ParamLogDAO(this.con);
        if (newValue == null) {
            paramLogDAO.insertParamLog(id, paramId, userId, "");
        } else {
            paramLogDAO.insertParamLog(id, paramId, userId, newValue);
        }
    }

    public void updateParamsAddressOnHouseUpdate(int houseId) throws SQLException {
        String query = "SELECT * FROM  param_address  WHERE house_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, houseId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int id = rs.getInt("id");
            int paramId = rs.getInt("param_id");
            int pos = rs.getInt("n");
            ParameterAddressValue value = this.getParameterAddressValueFromRs(rs, "");
            value.setValue(AddressUtils.buildAddressValue(value, this.con));
            this.updateParamAddress(id, paramId, pos, value);
        }
        ps.close();
    }

    public void updateParamBlob(int id, int paramId, String value) throws SQLException {
        if (Utils.isBlankString(value)) {
            value = null;
        }
        this.updateSimpleParam(id, paramId, value, " param_blob ");
        if (this.history) {
            this.logParam(id, paramId, this.userId, value != null ? Localization.getLocalizer().l("Length: {}", value.length()) : null);
        }
    }

    private void updateSimpleParam(int id, int paramId, Object value, String tableName) throws SQLException {
        if (value == null) {
            this.deleteFromParamTable(id, paramId, tableName);
        } else {
            StringBuilder query = new StringBuilder(200);
            query.append("UPDATE ");
            query.append(tableName);
            query.append("SET value=?");
            query.append(" WHERE ");
            query.append("id=? AND param_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setObject(1, value);
            ps.setInt(2, id);
            ps.setInt(3, paramId);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query.setLength(0);
                query.append("INSERT INTO ");
                query.append(tableName);
                query.append("(id, param_id, value) VALUES (?,?,?)");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, id);
                ps.setInt(2, paramId);
                ps.setObject(3, value);
                ps.executeUpdate();
            }
            ps.close();
        }
    }

    public void updateParamDate(int id, int paramId, Date value) throws SQLException {
        this.updateSimpleParam(id, paramId, value, " param_date ");
        if (this.history) {
            this.logParam(id, paramId, this.userId, TimeUtils.format(value, "ymd"));
        }
    }

    public void updateParamDateTime(int id, int paramId, Date value) throws SQLException {
        this.updateSimpleParam(id, paramId, value, " param_datetime ");
        if (this.history) {
            this.logParam(id, paramId, this.userId, TimeUtils.format(value, "ymdhms"));
        }
    }

    public void updateParamEmail(int id, int paramId, int position, ParameterEmailValue value) throws SQLException {
        int index = 1;
        if (value == null) {
            PreparedQuery psDelay = new PreparedQuery(this.con);
            psDelay.addQuery("DELETE FROM  param_email  WHERE id=? AND param_id=?");
            psDelay.addInt(id);
            psDelay.addInt(paramId);
            if (position > 0) {
                psDelay.addQuery(" AND n=?");
                psDelay.addInt(position);
            }
            psDelay.executeUpdate();
            psDelay.close();
        } else if (position <= 0) {
            position = 1;
            String query = "SELECT MAX(n) + 1 FROM  param_email  WHERE id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getObject(1) != null) {
                position = rs.getInt(1);
            }
            ps.close();
            query = "INSERT INTO  param_email  SET id=?, param_id=?, n=?, value=?, comment=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, id);
            ps.setInt(index++, paramId);
            ps.setInt(index++, position);
            ps.setString(index++, value.getValue());
            ps.setString(index++, value.getComment());
            ps.executeUpdate();
            ps.close();
        } else {
            String query = "UPDATE  param_email  SET value=?, comment=? WHERE id=? AND param_id=? AND n=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(index++, value.getValue());
            ps.setString(index++, value.getComment());
            ps.setInt(index++, id);
            ps.setInt(index++, paramId);
            ps.setInt(index++, position);
            ps.executeUpdate();
            ps.close();
        }
        if (this.history) {
            this.logParam(id, paramId, this.userId, ParameterEmailValue.toString(this.getParamEmail(id, paramId).values()));
        }
    }

    public void updateParamFile(int id, int paramId, int position, FileData fileData) throws Exception {
        PreparedQuery pq;
        String query;
        if (fileData == null) {
            Map<Integer, FileData> currentValue = null;
            if (position == -1) {
                currentValue = this.getParamFile(id, paramId);
            } else {
                FileData value = this.getParamFile(id, paramId, position);
                Map<Object, Object> map = currentValue = value != null ? Map.of(position, value) : Map.of();
            }
            if (!currentValue.isEmpty()) {
                for (FileData value : currentValue.values()) {
                    new FileDataDAO(this.con).delete(value);
                }
                query = "DELETE FROM  param_file  WHERE id=? AND param_id=?";
                pq = new PreparedQuery(this.con, query);
                try {
                    pq.addInt(id);
                    pq.addInt(paramId);
                    if (position != -1) {
                        pq.addQuery(" AND n=?");
                        pq.addInt(position);
                    }
                    pq.executeUpdate();
                }
                finally {
                    pq.close();
                }
            }
        } else {
            PreparedStatement ps;
            String query2;
            if (fileData.getId() <= 0 && fileData.getData() != null) {
                try (FileOutputStream fos = new FileDataDAO(this.con).add(fileData);){
                    fos.write(fileData.getData());
                }
            }
            if (position == 0) {
                query2 = "SELECT MAX(n) + 1 FROM  param_file  WHERE id=? AND param_id=?";
                ps = this.con.prepareStatement(query2);
                ps.setInt(1, id);
                ps.setInt(2, paramId);
                ResultSet rs = ps.executeQuery();
                position = rs.next() && rs.getObject(1) != null ? rs.getInt(1) : 1;
                ps.close();
            }
            query2 = "INSERT INTO  param_file (id, param_id, n, value) VALUES (?, ?, ?, ?)";
            ps = this.con.prepareStatement(query2);
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            ps.setInt(3, position);
            ps.setInt(4, fileData.getId());
            ps.executeUpdate();
            ps.close();
        }
        if (this.history) {
            String values = "";
            query = "SELECT GROUP_CONCAT(fd.title SEPARATOR ', ') FROM  param_file AS pf  INNER JOIN  file_data AS fd ON pf.value=fd.id WHERE pf.id=? AND pf.param_id=?";
            pq = new PreparedQuery(this.con, query);
            pq.addInt(id).addInt(paramId);
            ResultSet rs = pq.executeQuery();
            if (rs.next()) {
                values = rs.getString(1);
            }
            pq.close();
            this.logParam(id, paramId, this.userId, values);
        }
    }

    @Deprecated
    public void updateParamFile(int id, int paramId, int position, String comment, FileData fileData) throws Exception {
        this.updateParamFile(id, paramId, position, fileData);
    }

    public void updateParamList(int id, int paramId, Set<Integer> values) throws SQLException {
        if (values == null) {
            values = Set.of();
        }
        this.updateParamListWithComments(id, paramId, values.stream().collect(Collectors.toMap(Function.identity(), unused -> "")));
    }

    public void updateParamListWithComments(int id, int paramId, Map<Integer, String> values) throws SQLException {
        this.deleteFromParamTable(id, paramId, " param_list ");
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO  param_list (id, param_id, value, comment)VALUES (?, ?, ?, ?)");){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            for (Map.Entry<Integer, String> value : values.entrySet()) {
                ps.setInt(3, value.getKey());
                ps.setString(4, value.getValue());
                ps.executeUpdate();
            }
        }
        if (this.history) {
            StringBuilder logRecord = new StringBuilder(30);
            for (IdTitle item : ParameterCache.getListParamValues(paramId)) {
                String comment = values.get(item.getId());
                if (comment == null) continue;
                if (!logRecord.isEmpty()) {
                    logRecord.append(", ");
                }
                logRecord.append(item.getTitle());
                if (!Utils.notBlankString(comment)) continue;
                logRecord.append(" [").append(comment).append("]");
            }
            this.logParam(id, paramId, this.userId, logRecord.toString());
        }
    }

    @Deprecated
    public void updateParamList(int id, int paramId, Map<Integer, String> values) throws SQLException {
        log.warndMethod("updateParamList", "updateParamListWithComments");
        this.updateParamListWithComments(id, paramId, values);
    }

    public void updateParamListCount(int id, int paramId, Map<Integer, ?> values) throws SQLException {
        if (values == null) {
            values = Map.of();
        }
        this.deleteFromParamTable(id, paramId, " param_listcount ");
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO  param_listcount (id, param_id, value, count) VALUES (?, ?, ?, ?)");){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            for (Map.Entry<Integer, Object> me : values.entrySet()) {
                BigDecimal count;
                ps.setInt(3, me.getKey());
                Object value = me.getValue();
                if (value instanceof BigDecimal) {
                    count = (BigDecimal)value;
                } else if (value instanceof String) {
                    count = Utils.parseBigDecimal((String)value);
                } else {
                    throw new IllegalArgumentException("Usupported value type: " + String.valueOf(value));
                }
                ps.setBigDecimal(4, count);
                ps.executeUpdate();
            }
        }
        if (this.history) {
            StringBuilder logRecord = new StringBuilder(30);
            for (IdTitle item : ParameterCache.getListParamValues(paramId)) {
                Object count = values.get(item.getId());
                if (count == null) continue;
                Utils.addCommaSeparated(logRecord, item.getTitle() + ": " + String.valueOf(count));
            }
            this.logParam(id, paramId, this.userId, logRecord.toString());
        }
    }

    @Deprecated
    public void updateParamListCount(int id, int paramId, Map<Integer, Double> values, Map<Integer, String> valuesComments) throws SQLException {
        HashMap<Integer, BigDecimal> valuesFixed = new HashMap<Integer, BigDecimal>(values.size());
        for (Map.Entry<Integer, Double> me : values.entrySet()) {
            valuesFixed.put(me.getKey(), new BigDecimal(me.getValue()));
        }
        this.updateParamListCount(id, paramId, valuesFixed);
    }

    public void updateParamMoney(int id, int paramId, BigDecimal value) throws SQLException {
        this.updateSimpleParam(id, paramId, value, " param_money ");
        if (this.history) {
            this.logParam(id, paramId, this.userId, String.valueOf(value));
        }
    }

    public void updateParamMoney(int id, int paramId, String value) throws SQLException {
        if (Utils.isBlankString(value)) {
            value = null;
        }
        this.updateSimpleParam(id, paramId, Utils.parseBigDecimal(value), " param_money ");
        if (this.history) {
            this.logParam(id, paramId, this.userId, value);
        }
    }

    public void updateParamPhone(int id, int paramId, ParameterPhoneValue value) throws SQLException {
        String newPhones = null;
        if (value == null || value.getItemList().size() == 0) {
            this.deleteFromParamTable(id, paramId, " param_phone ");
            this.deleteFromParamTable(id, paramId, " param_phone_item ");
        } else {
            newPhones = value.toString();
            this.updateSimpleParam(id, paramId, newPhones, " param_phone ");
            this.deleteFromParamTable(id, paramId, " param_phone_item ");
            int index = 1;
            String query = "INSERT INTO param_phone_item SET id=?, param_id=?, n=?, phone=?, comment=?";
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, id);
            ps.setInt(index++, paramId);
            int n = 1;
            for (ParameterPhoneValueItem item : value.getItemList()) {
                index = 3;
                ps.setInt(index++, n++);
                ps.setString(index++, item.getPhone());
                ps.setString(index++, item.getComment());
                ps.executeUpdate();
            }
            ps.close();
        }
        if (this.history) {
            this.logParam(id, paramId, this.userId, newPhones);
        }
    }

    public void updateParamText(int id, int paramId, String value) throws SQLException {
        if (Utils.isBlankString(value)) {
            value = null;
        }
        this.updateSimpleParam(id, paramId, value, " param_text ");
        if (this.history) {
            this.logParam(id, paramId, this.userId, value);
        }
    }

    public void updateParamTree(int id, int paramId, Set<String> values) throws SQLException {
        if (values == null) {
            values = Set.of();
        }
        this.deleteFromParamTable(id, paramId, " param_tree ");
        String query = "INSERT INTO  param_tree (id, param_id, value) VALUES (?,?,?)";
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, paramId);
        for (String value : values) {
            ps.setString(3, value);
            ps.executeUpdate();
        }
        ps.close();
        if (this.history) {
            this.logParam(id, paramId, this.userId, Utils.getObjectTitles(this.getParamTreeWithTitles(id, paramId)));
        }
    }

    public void updateParamTreeCount(int id, int paramId) throws SQLException {
    }

    public void updateParamTreeCount(int id, int paramId, Map<String, BigDecimal> values) throws SQLException {
        if (values == null) {
            values = Map.of();
        }
        this.deleteFromParamTable(id, paramId, " param_treecount ");
        String query = "INSERT INTO  param_treecount (id, param_id, value, count)VALUES (?,?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            for (Map.Entry<String, BigDecimal> me : values.entrySet()) {
                ps.setString(3, me.getKey());
                ps.setBigDecimal(4, me.getValue());
                ps.executeUpdate();
            }
        }
        if (this.history) {
            this.logParam(id, paramId, this.userId, this.treeCountValuesString(paramId, values));
        }
    }

    private String treeCountValuesString(int paramId, Map<String, BigDecimal> values) {
        StringBuilder result = new StringBuilder(100);
        Map<String, String> valuesMap = ParameterCache.getTreeParamValues(paramId);
        for (Map.Entry<String, String> me : valuesMap.entrySet()) {
            BigDecimal value = values.get(me.getKey());
            if (value == null) continue;
            Utils.addCommaSeparated(result, this.treeCountValueString(valuesMap, me.getKey(), value));
        }
        return result.toString();
    }

    private String treeCountValueString(Map<String, String> valuesMap, String value, BigDecimal count) {
        Object title = valuesMap.get(value);
        if (title == null) {
            title = "??? " + value;
        }
        return (String)title + ": " + String.valueOf(count);
    }

    public List<ParameterValuePair> loadParameters(List<Parameter> paramList, int id, boolean offEncryption) throws SQLException {
        HashMap<String, ArrayList<Integer>> paramTypeMap = new HashMap<String, ArrayList<Integer>>();
        ArrayList<ParameterValuePair> result = new ArrayList<ParameterValuePair>(paramList.size());
        HashMap<Integer, ParameterValuePair> paramMap = new HashMap<Integer, ParameterValuePair>(paramList.size());
        for (Parameter parameter : paramList) {
            String type = parameter.getType();
            ArrayList<Integer> ids = (ArrayList<Integer>)paramTypeMap.get(type);
            if (ids == null) {
                ids = new ArrayList<Integer>();
                paramTypeMap.put(type, ids);
            }
            ids.add(parameter.getId());
            ParameterValuePair pvp = new ParameterValuePair(parameter);
            paramMap.put(parameter.getId(), pvp);
            result.add(pvp);
        }
        for (String type : paramTypeMap.keySet()) {
            this.updateParamValueMap(paramMap, type, (Collection)paramTypeMap.get(type), id, offEncryption);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void updateParamValueMap(Map<Integer, ParameterValuePair> paramMap, String type, Collection<Integer> ids, int objectId, boolean offEncryption) throws SQLException {
        StringBuilder query = new StringBuilder();
        ResultSet rs = null;
        Statement ps = null;
        if ("address".equals(type)) {
            query.append("SELECT param_id, n, value, house_id FROM param_");
            query.append(type);
            query.append(" WHERE id=? AND param_id IN ( ");
            query.append(Utils.toString(ids));
            query.append(" ) ORDER BY n");
        } else if ("email".equals(type)) {
            query.append("SELECT param_id, n, value, comment FROM param_");
            query.append(type);
            query.append(" WHERE id=? AND param_id IN ( ");
            query.append(Utils.toString(ids));
            query.append(" ) ORDER BY n");
        } else if ("file".equals(type)) {
            query.append("SELECT pf.param_id, pf.n, fd.* FROM  param_file  AS pf INNER JOIN  file_data  AS fd ON pf.value=fd.id  WHERE pf.id=? AND pf.param_id IN ( ");
            query.append(Utils.toString(ids));
            query.append(" ) ORDER BY n");
        } else if ("list".equals(type)) {
            String tableName;
            HashMap<String, HashSet<Integer>> tableParamsMap = new HashMap<String, HashSet<Integer>>();
            for (Integer n : ids) {
                HashSet<Integer> pids;
                Parameter parameter = ParameterCache.getParameter(n);
                tableName = parameter.getConfigMap().get("directory");
                if (tableName == null) {
                    tableName = " param_list_value ";
                }
                if ((pids = (HashSet<Integer>)tableParamsMap.get(tableName)) == null) {
                    pids = new HashSet<Integer>();
                    tableParamsMap.put(tableName, pids);
                }
                pids.add(n);
            }
            String standartPrefix = "SELECT val.param_id, val.value, dir.title, val.comment FROM  param_list AS val ";
            for (Map.Entry entry : tableParamsMap.entrySet()) {
                tableName = (String)entry.getKey();
                if (query.length() > 0) {
                    query.append("\nUNION ");
                }
                query.append("SELECT val.param_id, val.value, dir.title, val.comment FROM  param_list AS val ");
                this.addListTableJoin(query, tableName);
                query.append(" WHERE ");
                query.append("val.id=" + objectId + " AND val.param_id IN (");
                query.append(Utils.toString((Collection)entry.getValue()));
                query.append(")");
            }
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
        } else if ("listcount".equals(type)) {
            query.append("SELECT val.param_id, val.value, val.count, dir.title FROM  param_listcount AS val ");
            this.addListCountParamJoin(query);
            query.append(" WHERE val.id=? AND val.param_id IN (");
            query.append(Utils.toString(ids));
            query.append(") ORDER BY dir.title");
        } else if ("phone".equals(type)) {
            query.append("SELECT pi.param_id, pi.n, pi.phone, pi.comment  FROM  param_phone_item AS pi WHERE pi.id=? AND pi.param_id IN ( ");
            query.append(Utils.toString(ids));
            query.append(" ) ORDER BY pi.n");
        } else if ("tree".equals(type)) {
            query.append("SELECT val.param_id, val.value, dir.title FROM  param_tree AS val ");
            this.addTreeParamJoin(query);
            query.append(" WHERE val.id=? AND val.param_id IN (");
            query.append(Utils.toString(ids));
            query.append(") ORDER BY val.value");
        } else if ("treecount".equals(type)) {
            query.append("SELECT val.param_id, val.value, val.count, dir.title FROM  param_treecount AS val ");
            query.append(" LEFT JOIN  param_treecount_value AS dir ON val.param_id=dir.param_id AND val.value=dir.id");
            query.append(" WHERE val.id=? AND val.param_id IN (");
            query.append(Utils.toString(ids));
            query.append(") ORDER BY val.value");
        } else {
            query.append("SELECT param_id, value FROM param_");
            query.append(type);
            query.append(" WHERE id=? AND param_id IN ( ");
            query.append(Utils.toString(ids));
            query.append(" )");
        }
        if (ps == null) {
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, objectId);
            rs = ps.executeQuery();
        }
        while (rs.next()) {
            int paramId = rs.getInt(1);
            ParameterValuePair param = paramMap.get(paramId);
            if ("address".equals(type)) {
                void var11_17;
                Map map = (Map)param.getValue();
                if (map == null) {
                    TreeMap treeMap = new TreeMap();
                    param.setValue(treeMap);
                }
                ParameterAddressValue parameterAddressValue = new ParameterAddressValue();
                parameterAddressValue.setValue(rs.getString("value"));
                parameterAddressValue.setHouseId(rs.getInt("house_id"));
                var11_17.put(rs.getInt("n"), parameterAddressValue);
                continue;
            }
            if ("date".equals(type)) {
                param.setValue(rs.getDate("value"));
                continue;
            }
            if ("datetime".equals(type)) {
                param.setValue(rs.getTimestamp("value"));
                continue;
            }
            if ("email".equals(type)) {
                void var11_20;
                Map map = (Map)param.getValue();
                if (map == null) {
                    TreeMap treeMap = new TreeMap();
                    param.setValue(treeMap);
                }
                if (!"".equals(rs.getString("comment"))) {
                    var11_20.put(rs.getInt("n"), rs.getString("value") + " [" + rs.getString("comment") + "]");
                    continue;
                }
                var11_20.put(rs.getInt("n"), rs.getString("value"));
                continue;
            }
            if ("file".equals(type)) {
                void var11_23;
                Map map = (Map)param.getValue();
                if (map == null) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap();
                    param.setValue(linkedHashMap);
                }
                var11_23.put(rs.getString("pf.n"), FileDataDAO.getFromRs(rs, "fd."));
                continue;
            }
            if ("list".equals(type)) {
                void var11_26;
                List list = (List)param.getValue();
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    param.setValue(arrayList);
                }
                IdTitle idTitle = new IdTitle(rs.getInt("value"), rs.getString("title"));
                String comment = rs.getString("comment");
                if (Utils.notBlankString(comment)) {
                    idTitle.setTitle(idTitle.getTitle() + " [" + comment + "]");
                }
                var11_26.add(idTitle);
                continue;
            }
            if ("listcount".equals(type)) {
                void var11_29;
                List list = (List)param.getValue();
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    param.setValue(arrayList);
                }
                var11_29.add(new IdTitle(rs.getInt("val.value"), rs.getString("dir.title") + ": " + Utils.format(rs.getBigDecimal("val.count"))));
                continue;
            }
            if ("money".equals(type)) {
                param.setValue(rs.getBigDecimal("value"));
                continue;
            }
            if ("phone".equals(type)) {
                void var11_32;
                ParameterPhoneValue parameterPhoneValue = (ParameterPhoneValue)param.getValue();
                if (parameterPhoneValue == null) {
                    ParameterPhoneValue parameterPhoneValue2 = new ParameterPhoneValue();
                    param.setValue(parameterPhoneValue2);
                }
                var11_32.addItem(ParamValueDAO.getParamPhoneValueItemFromRs(rs));
                continue;
            }
            if ("tree".equals(type)) {
                void var11_35;
                List list = (List)param.getValue();
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    param.setValue(arrayList);
                }
                var11_35.add(new IdStringTitle(rs.getString("val.value"), rs.getString("dir.title")));
                continue;
            }
            if ("treecount".equals(type)) {
                void var11_38;
                List list = (List)param.getValue();
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    param.setValue(arrayList);
                }
                String string = rs.getString("val.value");
                var11_38.add(new IdStringTitle(string, this.treeCountValueString(ParameterCache.getTreeParamValues(paramId), string, rs.getBigDecimal("val.count"))));
                continue;
            }
            if ("encrypted".equals(param.getParameter().getConfigMap().get("encrypt")) && !offEncryption) {
                param.setValue("<\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415 \u0417\u0410\u0428\u0418\u0424\u0420\u041e\u0412\u0410\u041d\u041e>");
                continue;
            }
            param.setValue(rs.getString(2));
        }
        ps.close();
    }

    private void deleteFromParamTable(int id, int paramId, String tableName) throws SQLException {
        String query = "DELETE FROM " + tableName + " WHERE id=? AND param_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.setInt(2, paramId);
            ps.executeUpdate();
        }
    }

    @Deprecated
    public List<ParameterValuePair> loadParameters(List<Parameter> paramList, int id) throws SQLException {
        return this.loadParameters(paramList, id, false);
    }

    @Deprecated
    public void loadParameterValue(ParameterValuePair param, int objectId, boolean offEncription) throws Exception {
        Parameter parameter = param.getParameter();
        this.updateParamValueMap(Collections.singletonMap(parameter.getId(), param), parameter.getType(), Collections.singletonList(parameter.getId()), objectId, offEncription);
    }

    @Deprecated
    public Set<Integer> searchObjectByParameterPhone(int parameterId, ParameterPhoneValue parameterPhoneValue) throws SQLException {
        return new OldParamSearchDAO(this.con).searchObjectByParameterPhone(parameterId, parameterPhoneValue);
    }

    @Deprecated
    public Set<Integer> searchObjectByParameterAddress(int parameterId, ParameterAddressValue parameterAddressValue) throws SQLException {
        return new OldParamSearchDAO(this.con).searchObjectByParameterAddress(parameterId, parameterAddressValue);
    }

    @Deprecated
    public Set<Integer> searchObjectByParameterText(int parameterId, String parameterTextValue) throws SQLException {
        return new OldParamSearchDAO(this.con).searchObjectByParameterText(parameterId, parameterTextValue);
    }

    @Deprecated
    public Set<Integer> searchObjectByParameterList(int parameterId, int value) throws Exception {
        return new OldParamSearchDAO(this.con).searchObjectByParameterList(parameterId, value);
    }

    @Deprecated
    public SortedMap<Integer, ParameterAddressValue> getParamAddressExt(int id, int paramId, boolean loadDirs, String formatName) throws SQLException {
        log.warndMethod("getParamAddressExt", "getParamAddress");
        return this.getParamAddress(id, paramId, loadDirs, formatName);
    }

    @Deprecated
    public SortedMap<Integer, ParameterAddressValue> getParamAddressExt(int id, int paramId, boolean loadDirs) throws SQLException {
        log.warndMethod("getParamAddressExt", "getParamAddress");
        return this.getParamAddress(id, paramId, loadDirs);
    }
}

