/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.param;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.tree.IdStringTitleTreeItem;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.util.Utils;

public class ParamDAO
extends CommonDAO {
    public ParamDAO(Connection con) {
        super(con);
    }

    public Parameter getParameter(int id) throws SQLException {
        Parameter parameter = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM param_pref WHERE id=?");){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                parameter = this.getParameterFromRs(rs);
                String type = parameter.getType();
                if ("list".equals(type)) {
                    parameter.setValuesConfig(this.getListParamValuesConfig(id));
                    continue;
                }
                if ("listcount".equals(parameter.getType())) {
                    parameter.setValuesConfig(this.getListCountParamValuesConfig(id));
                    continue;
                }
                if ("tree".equals(parameter.getType())) {
                    parameter.setValuesConfig(this.getTreeParamValuesConfig(id, " param_tree_value "));
                    continue;
                }
                if (!"treecount".equals(parameter.getType())) continue;
                parameter.setValuesConfig(this.getTreeParamValuesConfig(id, " param_treecount_value "));
            }
        }
        return parameter;
    }

    private String getTreeParamValuesConfig(int paramId, String tableName) throws SQLException {
        IdStringTitleTreeItem root = this.getTreeParamRootNode(paramId, tableName);
        return this.getTreeConfig(root, "");
    }

    private String getTreeConfig(IdStringTitleTreeItem node, String prefix) {
        StringBuilder config = new StringBuilder();
        if (Utils.notBlankString((String)node.getId())) {
            config.append(prefix + "=" + node.getTitle());
            config.append("\n");
        }
        List children = node.getChildren();
        for (IdStringTitleTreeItem child : children) {
            Object curPrefix = prefix;
            curPrefix = Utils.notBlankString((String)child.getParentId()) ? (String)curPrefix + String.valueOf(child.getId()).substring(String.valueOf(child.getParentId()).length()) : (String)curPrefix + String.valueOf(child.getId());
            config.append(this.getTreeConfig(child, (String)curPrefix));
        }
        return config.toString();
    }

    private String getListCountParamValuesConfig(int paramId) throws SQLException {
        StringBuilder query = new StringBuilder();
        ResultSet rs = null;
        PreparedStatement ps = null;
        query.append("SELECT id, title FROM ");
        query.append(" param_listcount_value ");
        query.append(" WHERE param_id=? ORDER BY id");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, paramId);
        rs = ps.executeQuery();
        StringBuilder result = new StringBuilder(100);
        while (rs.next()) {
            result.append(rs.getInt(1));
            result.append("=");
            result.append(rs.getString(2));
            if (rs.isLast()) continue;
            result.append("\n");
        }
        ps.close();
        return result.toString();
    }

    public Map<Integer, IdStringTitleTreeItem> getTreeParamRootNodes() throws SQLException {
        HashMap<Integer, IdStringTitleTreeItem> result = new HashMap<Integer, IdStringTitleTreeItem>(2000);
        this.loadTreeParamRootNodes(result, " param_tree_value ");
        this.loadTreeParamRootNodes(result, " param_treecount_value ");
        return Collections.unmodifiableMap(result);
    }

    private void loadTreeParamRootNodes(Map<Integer, IdStringTitleTreeItem> result, String tableName) throws SQLException {
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT DISTINCT(param_id) FROM ");
        query.append(tableName);
        query.append(" ORDER BY id");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Integer paramId = rs.getInt("param_id");
                result.put(paramId, this.getTreeParamRootNode(paramId, tableName));
            }
        }
    }

    private IdStringTitleTreeItem getTreeParamRootNode(int paramId, String tableName) throws SQLException {
        IdStringTitleTreeItem root = new IdStringTitleTreeItem("", "", "");
        ArrayList<IdStringTitleTreeItem> items = new ArrayList<IdStringTitleTreeItem>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id, parent_id, title FROM " + tableName + " WHERE param_id=? ORDER BY id");){
            ps.setInt(1, paramId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                items.add(new IdStringTitleTreeItem(rs.getString("id"), rs.getString("title"), rs.getString("parent_id")));
            }
        }
        Collections.sort(items, IdStringTitleTreeItem.COMPARATOR);
        items.forEach(item -> {
            IdStringTitleTreeItem child = (IdStringTitleTreeItem)root.getChild((String)item.getParentId());
            if (child != null) {
                child.addChild(item);
            } else {
                root.addChild(item);
            }
        });
        return root;
    }

    public void updateParameter(Parameter parameter) throws SQLException {
        int index = 1;
        String query = null;
        PreparedStatement ps = null;
        if (parameter.getId() <= 0) {
            query = "INSERT INTO param_pref SET object=?, type=?, title=?, `order`=?, config=?, comment=?";
            ps = this.con.prepareStatement(query, 1);
            ps.setString(index++, parameter.getObjectType());
            ps.setString(index++, parameter.getType());
            ps.setString(index++, parameter.getTitle());
            ps.setInt(index++, parameter.getOrder());
            ps.setString(index++, parameter.getConfig());
            ps.setString(index++, parameter.getComment());
            ps.executeUpdate();
            parameter.setId(this.lastInsertId(ps));
        } else {
            query = "UPDATE param_pref SET title=?, `order`=?, config=?, comment=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setString(index++, parameter.getTitle());
            ps.setInt(index++, parameter.getOrder());
            ps.setString(index++, parameter.getConfig());
            ps.setString(index++, parameter.getComment());
            ps.setInt(index++, parameter.getId());
            ps.executeUpdate();
        }
        ps.close();
        if ("list".equals(parameter.getType())) {
            this.updateListValues(parameter, " param_list_value ");
        } else if ("listcount".equals(parameter.getType())) {
            this.updateListValues(parameter, " param_listcount_value ");
        } else if ("tree".equals(parameter.getType())) {
            this.updateTreeValues(parameter, " param_tree_value ");
        } else if ("treecount".equals(parameter.getType())) {
            this.updateTreeValues(parameter, " param_treecount_value ");
        }
    }

    private void updateListValues(Parameter parameter, String tableName) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + tableName + " WHERE param_id=?");){
            ps.setInt(1, parameter.getId());
            ps.executeUpdate();
        }
        ps = this.con.prepareStatement("INSERT INTO " + tableName + " (id, title, param_id) VALUES (?, ?, ?)");
        try {
            ps.setInt(3, parameter.getId());
            for (Map.Entry<Integer, String> me : this.convertListValuesConfigToMap(parameter.getValuesConfig()).entrySet()) {
                ps.setInt(1, me.getKey());
                ps.setString(2, me.getValue());
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void updateTreeValues(Parameter parameter, String tableName) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + tableName + " WHERE param_id=?");){
            ps.setInt(1, parameter.getId());
            ps.executeUpdate();
        }
        ps = this.con.prepareStatement("INSERT INTO " + tableName + " (id, parent_id, title, param_id) VALUES (?, ?, ?, ?)");
        try {
            ps.setInt(4, parameter.getId());
            for (IdStringTitleTreeItem node : this.convertTreeValuesConfigToNodeList(parameter.getValuesConfig())) {
                ps.setString(1, (String)node.getId());
                ps.setString(2, (String)node.getParentId());
                ps.setString(3, node.getTitle());
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private List<IdStringTitleTreeItem> convertTreeValuesConfigToNodeList(String valuesConfig) {
        ArrayList<IdStringTitleTreeItem> nodes = new ArrayList<IdStringTitleTreeItem>();
        if (valuesConfig == null) {
            return nodes;
        }
        for (String line : valuesConfig.split("\\n")) {
            String[] id_value = line.split("=");
            if (id_value.length < 2) continue;
            String id = id_value[0];
            String parentId = "";
            if (id_value[0].contains(".")) {
                int lastIndex = id_value[0].lastIndexOf(".");
                parentId = id_value[0].substring(0, lastIndex);
            }
            nodes.add(new IdStringTitleTreeItem(id, id_value[1], parentId));
        }
        return nodes;
    }

    public void deleteParameter(int id) {
        try {
            String query = "DELETE FROM  param_pref  WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM  param_list_value  WHERE param_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public Map<String, List<Parameter>> getParameterMapByObjectType() throws SQLException {
        HashMap<String, List<Parameter>> result = new HashMap<String, List<Parameter>>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT param_pref.* FROM ");
        query.append(" param_pref ");
        query.append("ORDER BY object, `order`");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Parameter param = this.getParameterFromRs(rs);
            ArrayList<Parameter> paramList = (ArrayList<Parameter>)result.get(param.getObjectType());
            if (paramList == null) {
                paramList = new ArrayList<Parameter>();
                result.put(param.getObjectType(), paramList);
            }
            paramList.add(param);
        }
        ps.close();
        return result;
    }

    public Map<Integer, Set<Integer>> getParameterIdsByGroupIds() throws SQLException {
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT group_id, param_id FROM ");
        query.append(" param_group ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int groupId = rs.getInt(1);
            HashSet<Integer> paramIds = (HashSet<Integer>)result.get(groupId);
            if (paramIds == null) {
                paramIds = new HashSet<Integer>();
                result.put(groupId, paramIds);
            }
            paramIds.add(rs.getInt(2));
        }
        ps.close();
        return result;
    }

    public Map<Integer, List<IdTitle>> getListParamValuesMap() throws SQLException {
        LinkedHashMap<Integer, List<IdTitle>> result = new LinkedHashMap<Integer, List<IdTitle>>();
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT id, param_id, title FROM ");
        query.append(" param_list_value ");
        query.append("UNION SELECT id, param_id, title FROM ");
        query.append(" param_listcount_value ");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int paramId = rs.getInt(2);
            ArrayList<IdTitle> valueList = (ArrayList<IdTitle>)result.get(paramId);
            if (valueList == null) {
                valueList = new ArrayList<IdTitle>();
                result.put(paramId, valueList);
            }
            valueList.add(new IdTitle(rs.getInt(1), rs.getString(3)));
        }
        ps.close();
        return result;
    }

    private String getListParamValuesConfig(int paramId) throws SQLException {
        StringBuilder query = new StringBuilder();
        ResultSet rs = null;
        PreparedStatement ps = null;
        query.append("SELECT id, title FROM ");
        query.append(" param_list_value ");
        query.append(" WHERE param_id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, paramId);
        rs = ps.executeQuery();
        StringBuilder result = new StringBuilder(100);
        while (rs.next()) {
            result.append(rs.getInt(1));
            result.append("=");
            result.append(rs.getString(2));
            if (rs.isLast()) continue;
            result.append("\n");
        }
        ps.close();
        return result.toString();
    }

    private Map<Integer, String> convertListValuesConfigToMap(String valuesConfig) {
        LinkedHashMap<Integer, String> listValuesMap = new LinkedHashMap<Integer, String>();
        if (valuesConfig == null) {
            return listValuesMap;
        }
        for (String line : valuesConfig.split("\\n")) {
            String[] id_value = line.split("=");
            if (id_value.length < 2) continue;
            listValuesMap.put(Utils.parseInt(id_value[0]), id_value[1]);
        }
        return listValuesMap;
    }

    public void searchParameter(Pageable<Parameter> result, String objectType, String filter, int paramGroupId, Set<Integer> parameterIds) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS param_pref.* FROM  param_pref ");
            if ("customer".equals(objectType) && paramGroupId > 0) {
                pq.addQuery(" INNER JOIN param_group ON param_pref.id=param_group.param_id AND param_group.group_id=?");
                pq.addInt(paramGroupId);
            }
            pq.addQuery(" WHERE object=?");
            pq.addString(objectType);
            if (Utils.notBlankString(filter)) {
                pq.addQuery(" AND (param_pref.id LIKE ? OR param_pref.title LIKE ? OR param_pref.comment LIKE ? OR param_pref.config LIKE ?)");
                pq.addString(filter).addString(filter).addString(filter).addString(filter);
            }
            if (parameterIds != null && !parameterIds.isEmpty()) {
                pq.addQuery(" AND param_pref.id IN ( ").addQuery(Utils.toString(parameterIds)).addQuery(" )");
            }
            pq.addQuery(" ORDER BY `order`, title");
            Page page = result.getPage();
            pq.addQuery(this.getPageLimit(page));
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(this.getParameterFromRs(rs));
            }
            if (page != null) {
                page.setRecordCount(this.foundRows(pq.getPrepared()));
            }
        }
    }

    public List<Parameter> getParameterList(String objectType, int paramGroupId) throws SQLException {
        return this.getParameterList(objectType, paramGroupId, null);
    }

    public List<Parameter> getParameterList(String objectType, int paramGroupId, Set<Integer> parameterIdList) throws SQLException {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT param_pref.* FROM ");
        query.append(" param_pref ");
        if (objectType != null && "customer".equals(objectType) && paramGroupId > 0) {
            query.append(" LEFT JOIN param_group ON param_pref.id=param_group.param_id");
        }
        query.append(" WHERE object=?");
        if (parameterIdList != null && parameterIdList.size() > 0) {
            StringBuilder pids = new StringBuilder();
            for (Integer pid : parameterIdList) {
                if (pids.length() > 0) {
                    pids.append(", ");
                }
                pids.append(pid);
            }
            if (pids.length() > 0) {
                query.append(" AND param_pref.id IN ( ");
                query.append((CharSequence)pids);
                query.append(" )");
            }
        }
        if (objectType != null && "customer".equals(objectType) && paramGroupId > 0) {
            query.append(" AND param_group.group_id=");
            query.append(paramGroupId);
            query.append(" ");
        }
        query.append(" ORDER BY `order`");
        ps = this.con.prepareStatement(query.toString());
        ps.setString(1, objectType);
        rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getParameterFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    private Parameter getParameterFromRs(ResultSet rs) throws SQLException {
        Parameter parameter = new Parameter();
        parameter.setId(rs.getInt("id"));
        parameter.setType(rs.getString("type"));
        parameter.setTitle(rs.getString("title"));
        parameter.setObjectType(rs.getString("object"));
        parameter.setOrder(rs.getInt("order"));
        parameter.setConfig(rs.getString("config"));
        parameter.setComment(rs.getString("comment"));
        return parameter;
    }

    @Deprecated
    public void getParameterList(Pageable<Parameter> searchResult, String objectType, String filter, int paramGroupId, Set<Integer> parameterIdList) throws SQLException {
        this.log.warndMethod("getParameterList", "searchParameter");
        this.searchParameter(searchResult, objectType, filter, paramGroupId, parameterIdList);
    }
}

