/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.message;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.Period;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class MessageSearchDAO
extends MessageDAO {
    private Set<Integer> tagIds;
    private Set<Integer> processIds;
    private Set<Integer> typeIds;
    private Integer direction;
    private Boolean processed;
    private Boolean read;
    private Boolean attach;
    private Period dateFrom;
    private String from;
    private List<Order> orders = new ArrayList<Order>();

    public MessageSearchDAO(Connection con) {
        super(con);
    }

    public MessageSearchDAO withTagIds(Set<Integer> value) {
        this.tagIds = value;
        return this;
    }

    public MessageSearchDAO withTagId(int value) {
        if (value > 0) {
            this.tagIds = Collections.singleton(value);
        }
        return this;
    }

    public MessageSearchDAO withProcessIds(Set<Integer> value) {
        this.processIds = value;
        return this;
    }

    public MessageSearchDAO withTypeIds(Set<Integer> value) {
        this.typeIds = value;
        return this;
    }

    public MessageSearchDAO withTypeId(int value) {
        if (value > 0) {
            this.typeIds = Collections.singleton(value);
        }
        return this;
    }

    public MessageSearchDAO withDirection(Integer value) {
        this.direction = value;
        return this;
    }

    public MessageSearchDAO withProcessed(Boolean value) {
        this.processed = value;
        return this;
    }

    public MessageSearchDAO withRead(Boolean value) {
        this.read = value;
        return this;
    }

    public MessageSearchDAO withAttach(Boolean value) {
        this.attach = value;
        return this;
    }

    public MessageSearchDAO withFrom(String value) {
        this.from = value;
        return this;
    }

    public MessageSearchDAO withDateFrom(Date from, Date to) {
        this.dateFrom = new Period(from, to);
        return this;
    }

    public MessageSearchDAO order(Order value) {
        this.orders.add(value);
        return this;
    }

    public void search(Pageable<Message> result) throws SQLException {
        Page page = result.getPage();
        boolean pinnedFirst = this.orders.contains((Object)Order.PINNED_FIRST);
        PreparedQuery pq = new PreparedQuery(this.con);
        pq.addQuery("SELECT SQL_CALC_FOUND_ROWS m.*, p.*" + (pinnedFirst ? ", pin_tag.tag_id" : "") + " FROM  message AS m LEFT JOIN  process AS p ON m.process_id=p.id");
        if (pinnedFirst) {
            pq.addQuery(" LEFT JOIN  message_tag AS pin_tag ON m.id=pin_tag.message_id AND pin_tag.tag_id=?");
            pq.addInt(-4);
        }
        if (CollectionUtils.isNotEmpty(this.tagIds)) {
            pq.addQuery(" INNER JOIN  message_tag  AS mt ON m.id=mt.message_id AND mt.tag_id IN (" + Utils.toString(this.tagIds) + ")");
        }
        pq.addQuery(" WHERE 1>0 ");
        if (this.processIds != null) {
            pq.addQuery(" AND m.process_id IN (");
            pq.addQuery(Utils.toString(this.processIds));
            pq.addQuery(")");
        }
        if (CollectionUtils.isNotEmpty(this.typeIds)) {
            pq.addQuery(" AND m.type_id IN (");
            pq.addQuery(Utils.toString(this.typeIds));
            pq.addQuery(")");
        }
        if (this.direction != null) {
            pq.addQuery(" AND m.direction=?");
            pq.addInt(this.direction);
        }
        if (this.processed != null) {
            if (this.processed.booleanValue()) {
                pq.addQuery(" AND process_id!=0");
            } else {
                pq.addQuery(" AND process_id=0");
            }
        }
        if (this.read != null) {
            pq.addQuery(" AND to_dt IS");
            if (this.read.booleanValue()) {
                pq.addQuery(" NOT");
            }
            pq.addQuery(" NULL");
        }
        if (this.attach != null) {
            if (this.attach.booleanValue()) {
                pq.addQuery(" AND attach_data");
            } else {
                pq.addQuery(" AND NOT(attach_data)");
            }
        }
        if (this.dateFrom != null) {
            if (this.dateFrom.getDateFrom() != null) {
                pq.addQuery(" AND ?<m.from_dt");
                pq.addDate(this.dateFrom.getDateFrom());
            }
            if (this.dateFrom.getDateTo() != null) {
                pq.addQuery(" AND m.from_dt<?");
                pq.addDate(TimeUtils.getNextDay(this.dateFrom.getDateTo()));
            }
        }
        if (Utils.notBlankString(this.from)) {
            pq.addQuery(" AND m.from LIKE ?");
            pq.addString(this.from);
        }
        pq.addQuery(" ORDER BY ");
        if (this.orders.isEmpty()) {
            pq.addQuery("m.from_dt");
        } else {
            boolean first = true;
            for (Order order : this.orders) {
                if (!first) {
                    pq.addQuery(", ");
                }
                pq.addQuery(switch (order.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> "m.from_dt";
                    case 1 -> "m.from_dt DESC";
                    case 2 -> "pin_tag.tag_id DESC";
                });
                first = false;
            }
        }
        pq.addQuery(this.getPageLimit(page));
        ResultSet rs = pq.executeQuery();
        while (rs.next()) {
            Message message = MessageSearchDAO.getMessageFromRs(rs, "m.");
            result.getList().add(message);
            if (rs.getInt("p.id") <= 0) continue;
            message.setProcess(ProcessDAO.getProcessFromRs(rs, "p."));
        }
        this.setRecordCount(page, pq.getPrepared());
        pq.close();
    }

    public static enum Order {
        FROM_TIME,
        FROM_TIME_DESC,
        PINNED_FIRST;

    }
}

