/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.custom.java;

import java.util.ArrayList;
import java.util.List;
import org.bgerp.custom.java.CompilationMessage;

public class CompilationResult {
    private boolean result;
    private List<CompilationMessage> errors = new ArrayList<CompilationMessage>();
    private List<CompilationMessage> warnings = new ArrayList<CompilationMessage>();
    private List<String> log = new ArrayList<String>();

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void addWarning(CompilationMessage warning) {
        this.warnings.add(warning);
    }

    public void addError(CompilationMessage error) {
        this.errors.add(error);
    }

    public void addLog(String message) {
        this.log.add(message);
    }

    public String getLogString() {
        StringBuilder result = new StringBuilder(1000);
        this.addMessages(this.errors, "\nErrors", result);
        this.addMessages(this.warnings, "\nWarnings", result);
        this.addMessages(this.log, "\nLog", result);
        return result.toString();
    }

    private void addMessages(List<?> log, String prefix, StringBuilder result) {
        result.append(prefix);
        result.append(" (");
        result.append(log.size());
        result.append("):\n");
        for (Object message : log) {
            result.append(message);
            result.append("\n");
        }
    }
}

