/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.cache;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.cache.Cache;
import org.bgerp.cache.CacheHolder;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.process.config.ProcessCreateInConfig;
import org.bgerp.util.Log;
import ru.bgcrm.dao.ConfigDAO;
import ru.bgcrm.dao.process.ProcessTypeDAO;
import ru.bgcrm.dao.process.StatusDAO;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.Status;
import ru.bgcrm.util.Utils;

public class ProcessTypeCache
extends Cache<ProcessTypeCache> {
    private static final Log log = Log.getLog();
    private static final CacheHolder<ProcessTypeCache> HOLDER = new CacheHolder<ProcessTypeCache>(new ProcessTypeCache());
    private List<ProcessType> typeList;
    private Map<Integer, ProcessType> typeMap;
    private ProcessType tree;
    private List<Status> statusList;
    private Map<Integer, Status> statusMap;

    public static Map<Integer, ProcessType> getProcessTypeMap() {
        return ProcessTypeCache.HOLDER.getInstance().typeMap;
    }

    public static ProcessType getProcessType(int id) {
        return ProcessTypeCache.HOLDER.getInstance().typeMap.get(id);
    }

    public static ProcessType getProcessTypeOrThrow(int id) throws NotFoundException {
        ProcessType result = ProcessTypeCache.getProcessType(id);
        if (result == null) {
            throw new NotFoundException("Not found process type with ID: " + id);
        }
        return result;
    }

    public static ProcessType getProcessTypeSafe(int id) {
        return Utils.maskNull(ProcessTypeCache.getProcessType(id), new ProcessType(id, IdTitle.unknown(id)));
    }

    public static List<ProcessType> getTypeList(String area, String objectType, Set<Integer> ids) {
        List<ProcessType> typeList = ProcessTypeCache.HOLDER.getInstance().typeList;
        ArrayList<ProcessType> result = new ArrayList<ProcessType>(typeList.size());
        for (ProcessType type : typeList) {
            ProcessCreateInConfig config = type.getProperties().getConfigMap().getConfig(ProcessCreateInConfig.class);
            if (!config.check(area, objectType) || ids != null && !ids.contains(type.getId())) continue;
            result.add(type);
        }
        return result;
    }

    public static ProcessType getTypeTreeRoot() {
        return ProcessTypeCache.HOLDER.getInstance().tree;
    }

    public static List<Status> getStatusList() {
        return ProcessTypeCache.HOLDER.getInstance().statusList;
    }

    public static Map<Integer, Status> getStatusMap() {
        return ProcessTypeCache.HOLDER.getInstance().statusMap;
    }

    public static Status getStatusSafe(int statusId) {
        return Utils.maskNull(ProcessTypeCache.getStatusMap().get(statusId), new Status(statusId, IdTitle.unknown(statusId)));
    }

    public static List<ProcessType> getTypePath(int id) {
        ArrayList<ProcessType> result = new ArrayList<ProcessType>();
        ProcessType type = new ProcessType();
        type.setParentId(id);
        while ((Integer)type.getParentId() != 0) {
            int parentId = (Integer)type.getParentId();
            if ((type = ProcessTypeCache.HOLDER.getInstance().typeMap.get(parentId)) == null) {
                type = new ProcessType();
                type.setTitle(IdTitle.unknown(parentId));
            }
            result.add(0, type);
        }
        return result;
    }

    public static void flush(Connection con) {
        HOLDER.flush(con);
    }

    @Override
    protected ProcessTypeCache newInstance() {
        ProcessTypeCache result = new ProcessTypeCache();
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            ConfigDAO configDao = new ConfigDAO(con);
            ProcessTypeDAO typeDAO = new ProcessTypeDAO(con);
            result.typeList = typeDAO.getFullProcessTypeList();
            result.typeMap = new HashMap<Integer, ProcessType>();
            for (ProcessType type : result.typeList) {
                if (!type.isUseParentProperties()) {
                    type.getProperties().setConfigMap(Preferences.processIncludes(configDao, type.getProperties().getConfig(), false));
                }
                result.typeMap.put((Integer)type.getId(), type);
            }
            result.tree = typeDAO.getTypeTreeRoot();
            result.statusList = new StatusDAO(con).getStatusList();
            result.statusMap = new HashMap<Integer, Status>();
            for (Status status : result.statusList) {
                result.statusMap.put(status.getId(), status);
            }
        }
        catch (Exception e2) {
            log.error(e2);
        }
        EventProcessor.subscribe((conSet, e) -> ProcessTypeCache.flush(null), SetupChangedEvent.class);
        return result;
    }
}

