/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.Maintenance;
import org.bgerp.app.dist.lic.AppLicense;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.app.servlet.user.LoginStat;
import org.bgerp.app.servlet.util.ServletUtils;
import org.bgerp.cache.UserCache;
import org.bgerp.event.AuthEvent;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.User;
import ru.bgcrm.servlet.filter.SetRequestParamsFilter;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SingleConnectionSet;

public class AuthFilter
implements Filter {
    private static Log log = Log.getLog();
    public static final String REQUEST_ATTRIBUTE_USER_ID_NAME = "ru.bgcrm.servlet.filter.AuthFilter.session.USER_ID";
    public static final String REQUEST_ATTRIBUTE_USER_IP_ADDRESS_NAME = "ru.bgcrm.servlet.filter.AuthFilter.session.USER_IP_ADDRESS";
    private static final String REQUEST_ATTRIBUTE_USER_NAME = "ru.bgcrm.servlet.filter.AuthFilter.request.USER";
    private static final String LOGIN_ACTION = "/login.do";
    private static final String SHELL_PAGE = "/shell.jsp";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Localizer l = Localization.getLocalizer();
        User user = this.authUser(request, response);
        if (user != null) {
            if (!user.isAdmin() && !AppLicense.instance().checkSessionLimit()) {
                this.forwardError(request, response, l.l("License limit reached", new Object[0]));
                return;
            }
            Maintenance maintenance = Maintenance.instance();
            if (maintenance != null && maintenance.getUser().getId() != user.getId()) {
                this.forwardError(request, response, l.l("Maintenance is running", new Object[0]));
                return;
            }
        }
        if ((user = this.userInSession(request, user)) != null) {
            String requestURI = request.getRequestURI();
            if (!requestURI.endsWith(".do") && !requestURI.endsWith(".jsp")) {
                request.setAttribute(REQUEST_ATTRIBUTE_USER_NAME, (Object)user);
                for (Map.Entry<String, Object> me : SetRequestParamsFilter.getContextVariables(request).entrySet()) {
                    request.setAttribute(me.getKey(), me.getValue());
                }
                Object app = request.getParameter("app");
                app = Utils.notBlankString((String)app) ? "?app=" + (String)app : "";
                String ifaceRealm = null;
                if (requestURI.startsWith("/user")) {
                    ifaceRealm = requestURI.substring(1);
                    int pos = ifaceRealm.indexOf(47);
                    if (pos > 0) {
                        ifaceRealm = ifaceRealm.substring(0, pos);
                        request.setAttribute("l", (Object)l);
                        this.forward(request, response, "/" + ifaceRealm + SHELL_PAGE + (String)app);
                    } else {
                        response.sendRedirect(requestURI + "/" + (String)app);
                    }
                }
            } else {
                request.setAttribute(REQUEST_ATTRIBUTE_USER_NAME, (Object)user);
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            this.forwardError(request, response, l.l("Login failed", new Object[0]));
        }
    }

    private User authUser(HttpServletRequest request, HttpServletResponse response) {
        String login = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (Utils.isBlankString(login) || Utils.isBlankString(password)) {
            return null;
        }
        User user = UserCache.getUser(login);
        if (user != null && user.getStatus() == 0) {
            if (!password.equals(user.getPassword())) {
                log.debug("User ID: {} password is wrong", user.getId());
                user = null;
            }
            return user;
        }
        if (user == null || user.getStatus() == 2) {
            AuthEvent event = new AuthEvent(login, password, user);
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                EventProcessor.processEvent(event, new SingleConnectionSet(con));
            }
            catch (Exception e) {
                log.error(e);
            }
            user = event.isProcessed() ? event.getUser() : null;
        }
        return user;
    }

    private User userInSession(HttpServletRequest request, User user) {
        if (user != null) {
            if (Utils.parseBoolean(request.getParameter("authToSession"), true).booleanValue()) {
                HttpSession session = request.getSession();
                session.setAttribute(REQUEST_ATTRIBUTE_USER_ID_NAME, (Object)user.getId());
                LoginStat.instance().userLoggedIn(session, user, ServletUtils.getHttpRequestRemoteAddr(request));
            }
        } else {
            Integer userId;
            HttpSession session = request.getSession(false);
            if (session != null && (userId = (Integer)session.getAttribute(REQUEST_ATTRIBUTE_USER_ID_NAME)) != null) {
                user = UserCache.getUser(userId);
            }
        }
        return user;
    }

    public static final User getUser(HttpServletRequest request) {
        return (User)request.getAttribute(REQUEST_ATTRIBUTE_USER_NAME);
    }

    private void forward(HttpServletRequest request, HttpServletResponse response, String page) throws IOException {
        ServletContext servletContext = request.getServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(page);
        try {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            log.error(e);
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            response.sendError(500, "ERROR");
        }
    }

    private void forwardError(HttpServletRequest request, HttpServletResponse response, String error) throws IOException {
        String responseType = request.getParameter("responseType");
        if (Utils.isBlankString(responseType)) {
            responseType = "html";
        }
        if (responseType.equals("html")) {
            this.forward(request, response, LOGIN_ACTION);
        } else if (responseType.equals("json")) {
            response.setContentType("text/plain; charset=" + StandardCharsets.UTF_8.name());
            response.setStatus(401);
            PrintWriter out = response.getWriter();
            out.write(error);
            out.close();
        }
    }
}

