/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.exception.alarm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.alarm.AlarmMessage;
import org.bgerp.app.exception.alarm.Health;
import org.bgerp.util.Log;
import org.bgerp.util.mail.MailMsg;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.model.FileData;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class AlarmSender
extends Thread {
    private static final Log log = Log.getLog();
    private static volatile AlarmSender instance;
    private volatile boolean run = true;
    private final String name;
    private final String mail;
    private volatile Map<String, Long> minAlarmInterval = new HashMap<String, Long>();
    private final Map<String, Long> lastAlarmTime = new ConcurrentHashMap<String, Long>();
    private final BlockingQueue<AlarmMessage> queue = new ArrayBlockingQueue<AlarmMessage>(256);
    private final Health health = new Health();

    public static void init(Setup setup) {
        AlarmSender.initInternal(setup);
        EventProcessor.subscribe((e, conSet) -> {
            if (instance != null) {
                AlarmSender.instance.run = false;
            }
            AlarmSender.initInternal(Setup.getSetup());
        }, SetupChangedEvent.class);
    }

    private static void initInternal(Setup setup) {
        String mail = setup.get("alarm.mail");
        if (Utils.notBlankString(mail)) {
            instance = new AlarmSender(setup, mail);
        }
    }

    public static void send(String key, long defaultInterval, String subject, Supplier<String> text, Exception ex, Supplier<List<FileData>> attachments) {
        long time = System.currentTimeMillis();
        if (instance != null && instance.isSendingNeeded(key, time, defaultInterval)) {
            instance.send(new AlarmMessage(key, subject, text.get(), ex, attachments == null ? null : attachments.get()), time);
        }
    }

    public static void send(String key, long defaultInterval, String subject, Supplier<String> text) {
        AlarmSender.send(key, defaultInterval, subject, text, null, null);
    }

    private AlarmSender(Setup setup, String mail) {
        this.name = setup.get("title");
        this.mail = mail;
        this.reloadMinAlarmIntervals(setup);
        this.setName("alarm-sender");
        this.start();
    }

    private void reloadMinAlarmIntervals(ConfigMap config) {
        HashMap<String, Long> newMinIntervalMap = new HashMap<String, Long>();
        for (Map.Entry<String, String> me : config.sub("alarm.min.interval.").entrySet()) {
            String key = me.getKey();
            int value = Utils.parseInt(me.getValue());
            if (value < 0) continue;
            newMinIntervalMap.put(key, (long)value * 1000L);
        }
        this.minAlarmInterval = newMinIntervalMap;
    }

    private boolean isSendingNeeded(String key, long time, long defaultInterval) {
        Long lastSendTime = this.lastAlarmTime.get(key);
        Long interval = this.minAlarmInterval.get(key);
        if (interval == null) {
            interval = defaultInterval;
        }
        return lastSendTime == null || time - lastSendTime > interval;
    }

    private void send(AlarmMessage message, long time) {
        while (!this.queue.offer(message)) {
            this.queue.poll();
        }
        this.lastAlarmTime.put(message.getKey(), time);
    }

    @Override
    public void run() {
        log.info("Starting", new Object[0]);
        while (this.run) {
            try {
                AlarmMessage message = (AlarmMessage)this.queue.poll();
                if (message != null) {
                    StringBuilder text = new StringBuilder(200).append("Alarm Key: ").append(message.getKey()).append("\n").append("First Registration: ").append(TimeUtils.format(message.getTime(), "dd.MM.yyyy HH:mm:ss")).append("\n\n").append(message.getText());
                    new MailMsg(Setup.getSetup()).withAttachments(message.getAttachments()).send(this.mail, "[" + this.name + "] " + message.getSubject(), text.toString());
                    log.debug("Sending '{}' to {}", message.getSubject(), this.mail);
                } else {
                    AlarmSender.sleep(5000L);
                }
                this.health.check();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }
}

