/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.event;

import java.util.concurrent.Callable;
import org.bgerp.app.event.iface.Event;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.util.log.SessionLogAppender;
import org.bgerp.util.log.TrackedSession;
import ru.bgcrm.util.sql.ConnectionSet;

class RequestTask
implements Callable<byte[]> {
    private final ConnectionSet conSet;
    private final Event event;
    private final EventListener<Event> listener;
    private final TrackedSession trackedSession;

    public RequestTask(ConnectionSet conSet, Event event, EventListener<Event> listener) {
        this.conSet = conSet;
        this.event = event;
        this.listener = listener;
        this.trackedSession = SessionLogAppender.getTracked();
    }

    @Override
    public byte[] call() throws Exception {
        try {
            if (this.trackedSession != null) {
                SessionLogAppender.track(this.trackedSession.getSession(), false);
            }
            this.listener.notify(this.event, this.conSet);
        }
        finally {
            if (this.trackedSession != null) {
                SessionLogAppender.untrack();
            }
        }
        return new byte[0];
    }
}

