/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.event;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.PrioritizedListener;
import org.bgerp.app.event.RequestTask;
import org.bgerp.app.event.iface.Event;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.util.Log;
import ru.bgcrm.util.sql.ConnectionSet;

public class EventProcessor {
    private static final Log log = Log.getLog();
    private static final Map<Class<?>, List<PrioritizedListener>> SUBSCRIBERS = new ConcurrentHashMap();
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("EventProcessor-%d").build());

    public static <E extends Event> void subscribe(EventListener<? super E> l, Class<E> clazz) {
        EventProcessor.subscribe(l, clazz, 0);
    }

    public static <E extends Event> void subscribe(EventListener<? super E> l, Class<E> clazz, int priority) {
        List list = SUBSCRIBERS.computeIfAbsent(clazz, c -> new ArrayList());
        PrioritizedListener item = new PrioritizedListener(l, priority);
        for (int i = 0; i < list.size(); ++i) {
            if (((PrioritizedListener)list.get(i)).priority() >= priority) continue;
            list.add(i, item);
            return;
        }
        list.add(item);
    }

    public static void unsubscribe(EventListener<?> l) {
        SUBSCRIBERS.values().remove(l);
    }

    public static void processEvent(Event event, ConnectionSet conSet) throws Exception {
        log.trace("Processing event: {}", event);
        List<PrioritizedListener> listeners = SUBSCRIBERS.get(event.getClass());
        if (listeners != null) {
            for (PrioritizedListener item : listeners) {
                if (!event.processing()) break;
                EventProcessor.processEvent(event, item.listener(), conSet);
            }
        }
    }

    private static void processEvent(Event event, EventListener<Event> listener, ConnectionSet conSet) throws Exception {
        long timeout = Setup.getSetup().getLong("event.process.timeout", 5000L);
        try {
            if (!EventProcessor.isDebugMode()) {
                Future<byte[]> future = EXECUTOR.submit(new RequestTask(conSet, event, listener));
                future.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                listener.notify(event, conSet);
            }
        }
        catch (TimeoutException e) {
            log.error("Timeout {} ms was exceeded in listener {}", timeout, listener.getClass().getName());
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof BGMessageException)) {
                log.error("In listener {} occurred an exception: {}", listener.getClass().getName(), e.getMessage());
                log.error(e);
            }
            throw (Exception)cause;
        }
    }

    private static boolean isDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
    }
}

