/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.lic;

import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.util.Base64;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.bgerp.util.Log;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import ru.bgcrm.util.Utils;

public class Sign {
    private static final Log log = Log.getLog();
    final String id;
    private final Signer sign;

    Sign(String id, String publicKey) {
        this.id = id;
        this.sign = this.initSignerVerify(publicKey);
    }

    public Sign(String id, String privateKey, String password) {
        this.id = id;
        this.sign = this.initSignerGenerate(privateKey, password);
    }

    private Signer initSignerVerify(String publicKey) {
        AsymmetricKeyParameter keyParameters = OpenSSHPublicKeyUtil.parsePublicKey((byte[])Base64.getDecoder().decode(publicKey));
        if (keyParameters.isPrivate()) {
            throw new IllegalArgumentException("Private key is not allowed");
        }
        return this.initSigner(keyParameters, false);
    }

    private Signer initSignerGenerate(String privateKey, String password) {
        try {
            AsymmetricKeyParameter keyParameter = null;
            try {
                keyParameter = this.loadKeyParameters((BaseFileKeyProvider)new OpenSSHKeyV1KeyFile(), privateKey, password);
            }
            catch (IOException e) {
                if (e.getMessage().equals("This key is not in 'openssh-key-v1' format")) {
                    keyParameter = this.loadKeyParameters((BaseFileKeyProvider)new OpenSSHKeyFile(), privateKey, password);
                }
                throw e;
            }
            return this.initSigner(keyParameter, true);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Parse exception for key: " + this.id, e);
        }
    }

    private AsymmetricKeyParameter loadKeyParameters(BaseFileKeyProvider keyFile, String privateKey, String password) throws IOException {
        StringReader privateKeyReader = new StringReader(privateKey);
        if (Utils.notBlankString(password)) {
            keyFile.init((Reader)privateKeyReader, PasswordUtils.createOneOff((char[])password.toCharArray()));
        } else {
            keyFile.init((Reader)privateKeyReader);
        }
        PrivateKey privateKeyJca = keyFile.getPrivate();
        return PrivateKeyFactory.createKey((byte[])privateKeyJca.getEncoded());
    }

    private Signer initSigner(AsymmetricKeyParameter keyParameters, boolean signing) {
        try {
            if (keyParameters instanceof RSAKeyParameters) {
                RSADigestSigner signer = new RSADigestSigner((Digest)new SHA256Digest());
                signer.init(signing, (CipherParameters)keyParameters);
                return signer;
            }
            if (keyParameters instanceof Ed25519PublicKeyParameters || keyParameters instanceof Ed25519PrivateKeyParameters) {
                Ed25519Signer signer = new Ed25519Signer();
                signer.init(signing, (CipherParameters)keyParameters);
                return signer;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parse exception for key: " + this.id, e);
        }
        throw new IllegalArgumentException("Unsupported key type: " + String.valueOf(keyParameters) + "; id: " + this.id);
    }

    public boolean signatureVerify(byte[] data, String signature) {
        try {
            this.sign.update(data, 0, data.length);
            return this.sign.verifySignature(Base64.getDecoder().decode(signature));
        }
        catch (Exception e) {
            log.info("Error in license signature verification: {}", e.getMessage());
            return false;
        }
    }

    public String signatureGenerate(byte[] data) throws CryptoException {
        this.sign.update(data, 0, data.length);
        return Base64.getEncoder().encodeToString(this.sign.generateSignature());
    }
}

