/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.inst;

import java.time.Duration;
import java.time.Instant;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.inst.InstalledModule;
import org.bgerp.app.dist.inst.InstallerModules;
import org.bgerp.app.dist.inst.ModuleFile;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class VersionCheck {
    private static final Log log = Log.getLog();
    public static final VersionCheck INSTANCE = new VersionCheck();
    private static final Duration REMOTE_VERSION_CHECK_INTERVAL = Duration.ofHours(2L);
    private final InstalledModule currentVersion = this.currentVersionInfo();
    private volatile Instant remoteVersionCheckTime;
    private volatile ModuleFile remoteVersion;

    private VersionCheck() {
    }

    private InstalledModule currentVersionInfo() {
        ConfigMap props = Setup.getSetup().sub("test.version.check.current.");
        return props.isEmpty() ? InstalledModule.get("update") : new InstalledModule(props);
    }

    public boolean isUpdateNeeded() {
        int remoteBuild;
        boolean result;
        if (this.currentVersion == null) {
            return false;
        }
        if (this.remoteVersionCheckTime == null || 0 < Duration.between(this.remoteVersionCheckTime, Instant.now()).compareTo(REMOTE_VERSION_CHECK_INTERVAL)) {
            this.remoteVersionCheckTime = Instant.now();
            new Thread(){

                @Override
                public void run() {
                    log.info("Retrieving remote version", new Object[0]);
                    VersionCheck.this.remoteVersion = new InstallerModules(VersionCheck.this.currentVersion.getVersion()).getRemoteFileMap().get("update");
                    if (VersionCheck.this.remoteVersion == null) {
                        log.error("Not found remote version info", new Object[0]);
                    }
                }
            }.start();
        }
        if (this.remoteVersion == null) {
            return false;
        }
        int currentBuild = Utils.parseInt(this.currentVersion.getBuildNumber());
        boolean bl = result = currentBuild < (remoteBuild = Utils.parseInt(this.remoteVersion.getBuildNumber()));
        if (result) {
            log.info("Update is needed; currentBuild: {}, remoteBuild: {}", currentBuild, remoteBuild);
        } else {
            log.trace("Update is NOT needed; currentBuild: {}, remoteBuild: {}", currentBuild, remoteBuild);
        }
        return result;
    }
}

