/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.inst;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.inst.InstalledModule;
import org.bgerp.app.dist.inst.InstallerModule;
import org.bgerp.app.dist.inst.ModuleFile;
import org.bgerp.util.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import ru.bgcrm.util.Utils;

public class InstallerModules {
    private static final Log log = Log.getLog();
    private static final String VERSION_URL = Utils.getSystemProperty("version.url", "https://bgerp.org/version");
    private static final String TMP_DIR_PATH = Utils.getTmpDir();
    private final String version;
    private final Map<String, ModuleFile> remoteFileMap = new HashMap<String, ModuleFile>();
    private final List<ModuleFile> listForInstall = new ArrayList<ModuleFile>();

    public InstallerModules(String version) {
        this.version = version;
        this.loadRemoteFileList();
    }

    public InstallerModules() {
        this(null);
    }

    public void update(boolean force) {
        this.selectModulesForUpdate(force);
        this.installSelected();
    }

    private void loadRemoteFileList() {
        try {
            String kernelVersion = this.getVersion();
            String updateUrl = Log.format("{}/{}/", VERSION_URL, kernelVersion);
            log.info("Loading remote file list from: {}", updateUrl);
            Document doc = this.getRemoteHtml(updateUrl);
            for (Element link : doc.select("a")) {
                Matcher m;
                String href = link.attr("href");
                if (!ModuleFile.isValidFileName(href) || !(m = ModuleFile.PATTERN_ZIP.matcher(href)).find()) continue;
                ModuleFile fi = new ModuleFile(m.group(1), m.group(2), href, new URI(updateUrl + href).toURL());
                this.remoteFileMap.put(fi.moduleName, fi);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    @VisibleForTesting
    protected Document getRemoteHtml(String updateUrl) throws IOException {
        return Jsoup.connect((String)updateUrl).get();
    }

    public Map<String, ModuleFile> getRemoteFileMap() {
        return this.remoteFileMap;
    }

    private String getVersion() {
        String result = this.version;
        if (Utils.isBlankString(result)) {
            InstalledModule vi = InstalledModule.get("update");
            result = vi == null ? null : vi.getVersion();
        }
        return Utils.maskNull(result);
    }

    private void installSelected() {
        try {
            if (this.listForInstall.isEmpty()) {
                log.info("Not updates found, press Enter for exit..", new Object[0]);
                System.in.read();
                System.exit(0);
            } else {
                for (ModuleFile fi : this.listForInstall) {
                    log.info("Downloading {} to {}", fi.fileName, TMP_DIR_PATH);
                    FileUtils.copyURLToFile((URL)fi.url, (File)new File(TMP_DIR_PATH + "/" + fi.fileName));
                    log.info(" OK!", new Object[0]);
                }
                log.info("Start installing..", new Object[0]);
                for (ModuleFile fi : this.listForInstall) {
                    File file = new File(TMP_DIR_PATH + "/" + fi.fileName);
                    InstallerModule im = new InstallerModule(Setup.getSetup(), new File("."), file);
                    log.info(im.getReport().toString(), new Object[0]);
                    file.deleteOnExit();
                }
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private void selectModulesForUpdate(boolean force) {
        List<InstalledModule> modules = InstalledModule.getInstalled();
        for (InstalledModule vi : modules) {
            String name = vi.getModuleName();
            String buildNumber = vi.getBuildNumber();
            log.info("Checking update for '{}'..", name);
            ModuleFile fi = this.remoteFileMap.get(name);
            if (fi == null || !force && fi.buildNumber.equals(buildNumber)) continue;
            log.info("Found update for '{}' build {} updating to build {}", name, buildNumber, fi.buildNumber);
            this.listForInstall.add(fi);
        }
    }
}

