/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.inst;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.dist.inst.ModuleFile;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.util.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import ru.bgcrm.util.Utils;

public class InstallerChanges {
    private static final Log log = Log.getLog();
    public static final String UPDATE_TO_CHANGE_URL = "https://bgerp.org/change";
    public static final String MASTER_RELEASE_CHANGE_ID = "0";
    private static final String TMP_DIR_PATH = Utils.getTmpDir();
    private final List<Change> changes = new ArrayList<Change>();
    private final List<String> updateFiles = new ArrayList<String>(2);

    public InstallerChanges() throws IOException, ParseException {
        this.changes();
    }

    public InstallerChanges(String changeId) throws IOException, URISyntaxException {
        this.updateFiles(changeId);
    }

    private void changes() throws IOException, ParseException {
        Document doc = this.changes(UPDATE_TO_CHANGE_URL);
        for (Element link : doc.select("a")) {
            String id = link.attr("href").replace("/", "");
            if (id.contains(".")) continue;
            this.changes.add(new Change(id, StringUtils.substringBeforeLast((String)link.nextSibling().toString(), (String)"-").trim()));
        }
        Collections.sort(this.changes, (o1, o2) -> {
            if (MASTER_RELEASE_CHANGE_ID.equals(o1.getId())) {
                return -1;
            }
            if (MASTER_RELEASE_CHANGE_ID.equals(o2.getId())) {
                return 1;
            }
            return o2.time.compareTo(o1.time);
        });
    }

    private void updateFiles(String changeId) throws IOException, URISyntaxException {
        String url = "https://bgerp.org/change/" + changeId;
        Document doc = this.changes(url);
        for (Element link : doc.select("a")) {
            String name = link.attr("href");
            if (!ModuleFile.isValidFileName(name)) continue;
            log.info("Downloading {} to {}", name, TMP_DIR_PATH);
            this.download(url, name);
            this.updateFiles.add(name);
        }
    }

    @VisibleForTesting
    protected Document changes(String url) throws IOException {
        return Jsoup.connect((String)url).get();
    }

    @VisibleForTesting
    protected void download(String url, String name) throws IOException, URISyntaxException {
        FileUtils.copyURLToFile((URL)new URI(url + "/" + name).toURL(), (File)new File(TMP_DIR_PATH, name));
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public List<String> getUpdateFiles() {
        return this.updateFiles;
    }

    public static class Change
    extends IdStringTitle {
        private final Date time;

        private Change(String id, String time) throws ParseException {
            super(id, id + " " + time);
            this.time = new SimpleDateFormat("dd-MMM-yyyy HH:mm", Locale.US).parse(time);
        }
    }
}

