/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist;

import java.io.File;
import java.util.List;
import org.bgerp.util.Log;
import org.bgerp.util.RuntimeRunner;

public class Scripts {
    private static final Log log = Log.getLog();
    private static final String BACKUP = "./backup.sh";
    private static final String INSTALLER = " ./installer.sh ";
    private static final String RESTART = " ./erp_restart.sh ";

    public Scripts backup(boolean db) throws Exception {
        new RuntimeRunner("bash", BACKUP, db ? "create_db" : "create").run();
        return this;
    }

    public Scripts backupRestore(String name) throws Exception {
        new RuntimeRunner("bash", BACKUP, "restore", name).run();
        return this;
    }

    public Scripts update(boolean force) throws Exception {
        new RuntimeRunner("sh", "-c", INSTALLER + (force ? "updatef" : "update")).run();
        return this;
    }

    public Scripts restart(boolean force) throws Exception {
        File pid = new File(".run/bgerp.pid");
        if (!pid.exists()) {
            log.info("Stopping container instead of restart", new Object[0]);
            System.exit(0);
        } else {
            new RuntimeRunner("sh", "-c", RESTART + (force ? "force" : "")).run();
        }
        return this;
    }

    public Scripts install(List<String> files) throws Exception {
        for (String file : files) {
            new RuntimeRunner("sh", "-c", " ./installer.sh install " + file).run();
        }
        return this;
    }

    public Scripts installc(String changeId) throws Exception {
        new RuntimeRunner("sh", "-c", " ./installer.sh installc " + changeId).run();
        return this;
    }
}

